/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Matrix;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class MovieHeaderAtom
extends QTAtom {
    Date creationTime;
    Date modificationTime;
    long timeScale = -1L;
    long duration = -1L;
    float preferredRate = -1.0f;
    long preferredVolume = -1L;
    byte[] reserved = new byte[10];
    Matrix matrix;
    long previewTime = -1L;
    long previewDuration = -1L;
    long posterTime = -1L;
    long selectionTime = -1L;
    long selectionDuration = -1L;
    long currentTime = -1L;
    long nextTrackId = -1L;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.creationTime = BitstreamReader.readDate(movieFile);
        this.modificationTime = BitstreamReader.readDate(movieFile);
        this.timeScale = BitstreamReader.readU32((DataInput)movieFile);
        this.duration = BitstreamReader.readU32((DataInput)movieFile);
        this.preferredRate = BitstreamReader.readFixed32(movieFile);
        this.preferredVolume = BitstreamReader.readU16(movieFile);
        movieFile.readFully(this.reserved);
        this.matrix = new Matrix(quickTimeParser, movieFile);
        this.previewTime = BitstreamReader.readU32((DataInput)movieFile);
        this.previewDuration = BitstreamReader.readU32((DataInput)movieFile);
        this.posterTime = BitstreamReader.readU32((DataInput)movieFile);
        this.selectionTime = BitstreamReader.readU32((DataInput)movieFile);
        this.selectionDuration = BitstreamReader.readU32((DataInput)movieFile);
        this.currentTime = BitstreamReader.readU32((DataInput)movieFile);
        this.nextTrackId = BitstreamReader.readU32((DataInput)movieFile);
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] timeScale=" + this.timeScale + "; duration=" + this.duration + "; preferredRate=" + this.preferredRate + "; modificationTime=" + this.modificationTime + "; nextTrackId=" + this.nextTrackId;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("creationTime", this.creationTime.toString()));
        l.add(new KeyValuePair("modificationTime", this.modificationTime.toString()));
        l.add(new KeyValuePair("timeScale", this.timeScale + ""));
        l.add(new KeyValuePair("duration", this.duration + ""));
        l.add(new KeyValuePair("preferredRate", this.preferredRate + ""));
        l.add(new KeyValuePair("preferredVolume", this.preferredVolume + ""));
        l.add(new KeyValuePair("previewTime", this.previewTime + ""));
        l.add(new KeyValuePair("previewDuration", this.previewDuration + ""));
        l.add(new KeyValuePair("posterTime", this.posterTime + ""));
        l.add(new KeyValuePair("selectionTime", this.selectionTime + ""));
        l.add(new KeyValuePair("selectionDuration", this.selectionDuration + ""));
        l.add(new KeyValuePair("currentTime", this.currentTime + ""));
        l.add(new KeyValuePair("nextTrackId", this.nextTrackId + ""));
        return l;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public long getDuration() {
        return this.duration;
    }

    public float getPreferredRate() {
        return this.preferredRate;
    }

    public long getPreferredVolume() {
        return this.preferredVolume;
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public long getPreviewTime() {
        return this.previewTime;
    }

    public long getPreviewDuration() {
        return this.previewDuration;
    }

    public long getPosterTime() {
        return this.posterTime;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public long getSelectionDuration() {
        return this.selectionDuration;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }
}

