/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.CtryAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.HdlrAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.IlstAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.KeysAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.LangAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class MetaAtom
extends QTContainerAtom {
    protected static final Map<String, Class<? extends QTAtom>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends QTAtom>>();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        if (this.parent == null) {
            movieFile.seek(this.offset + this.size);
            return;
        }
        while (movieFile.getFilePointer() < this.offset + this.size - 4L) {
            long offset = movieFile.getFilePointer();
            long size = BitstreamReader.readU32((DataInput)movieFile);
            String type = BitstreamReader.readFourCC((DataInput)movieFile);
            Atom atom = null;
            if (TYPE_CLASS_MAP.containsKey(type)) {
                try {
                    atom = TYPE_CLASS_MAP.get(type).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (atom == null) {
                atom = new UserDataListAtom();
                movieFile.seek(offset + size);
            }
            atom.setAttributes(offset, size, type);
            atom.setParent(this);
            atom.parseAtom(ctx, quickTimeParser, movieFile);
            this.atoms.add(atom);
        }
    }

    static {
        TYPE_CLASS_MAP.put("hdlr", HdlrAtom.class);
        TYPE_CLASS_MAP.put("keys", KeysAtom.class);
        TYPE_CLASS_MAP.put("ilst", IlstAtom.class);
        TYPE_CLASS_MAP.put("ctry", CtryAtom.class);
        TYPE_CLASS_MAP.put("lang", LangAtom.class);
    }
}

