/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MediaHeaderAtom
extends QTAtom {
    Date creationTime;
    Date modificationTime;
    long timeScale;
    long duration;
    int language;
    int quality;
    public static Map<Integer, String> macOsIntegerToLanguage = new HashMap<Integer, String>();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.creationTime = BitstreamReader.readDate(movieFile);
        this.modificationTime = BitstreamReader.readDate(movieFile);
        this.timeScale = BitstreamReader.readU32((DataInput)movieFile);
        this.duration = BitstreamReader.readU32((DataInput)movieFile);
        this.language = BitstreamReader.readU16(movieFile);
        this.quality = BitstreamReader.readU16(movieFile);
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] timeScale=" + this.timeScale + "; duration=" + this.duration + "; language=" + this.language + "(" + this.getLanguageCode() + "); quality=" + this.quality + "; created=" + this.creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getLanguage() {
        return this.language;
    }

    public String getLanguageCode() {
        if (this.language < 1024 || this.language == Short.MAX_VALUE) {
            if (macOsIntegerToLanguage.containsKey(this.language)) {
                return macOsIntegerToLanguage.get(this.language);
            }
            throw new RuntimeException("Mac OS integer coding to 3-char language code contains no entry for integer: " + this.language);
        }
        int[] indexes = new int[3];
        indexes[2] = this.language & 0x1F;
        indexes[1] = this.language >> 5 & 0x1F;
        indexes[0] = this.language >> 10 & 0x1F;
        String charCode = "";
        for (int i : indexes) {
            if (i > 26 || i < 1) {
                throw new RuntimeException("Invalid language code character with index: " + i);
            }
            charCode = charCode + (char)(97 + (i - 1));
        }
        return charCode;
    }

    public int getQuality() {
        return this.quality;
    }

    static {
        macOsIntegerToLanguage.put((Integer)Short.MAX_VALUE, "und");
        macOsIntegerToLanguage.put(141, "afr");
        macOsIntegerToLanguage.put(36, "sqi");
        macOsIntegerToLanguage.put(85, "amh");
        macOsIntegerToLanguage.put(12, "ara");
        macOsIntegerToLanguage.put(51, "hye");
        macOsIntegerToLanguage.put(68, "asm");
        macOsIntegerToLanguage.put(134, "aym");
        macOsIntegerToLanguage.put(49, "aze");
        macOsIntegerToLanguage.put(129, "eus");
        macOsIntegerToLanguage.put(67, "ben");
        macOsIntegerToLanguage.put(142, "bre");
        macOsIntegerToLanguage.put(44, "bul");
        macOsIntegerToLanguage.put(77, "mya");
        macOsIntegerToLanguage.put(130, "cat");
        macOsIntegerToLanguage.put(19, "zho");
        macOsIntegerToLanguage.put(33, "zho");
        macOsIntegerToLanguage.put(38, "ces");
        macOsIntegerToLanguage.put(7, "dan");
        macOsIntegerToLanguage.put(4, "nld");
        macOsIntegerToLanguage.put(92, "nya");
        macOsIntegerToLanguage.put(34, "nld");
        macOsIntegerToLanguage.put(137, "dzo");
        macOsIntegerToLanguage.put(0, "eng");
        macOsIntegerToLanguage.put(94, "epo");
        macOsIntegerToLanguage.put(27, "est");
        macOsIntegerToLanguage.put(31, "fas");
        macOsIntegerToLanguage.put(46, "bel");
        macOsIntegerToLanguage.put(30, "fao");
        macOsIntegerToLanguage.put(13, "fin");
        macOsIntegerToLanguage.put(1, "fra");
        macOsIntegerToLanguage.put(52, "kat");
        macOsIntegerToLanguage.put(2, "deu");
        macOsIntegerToLanguage.put(140, "glg");
        macOsIntegerToLanguage.put(144, "gla");
        macOsIntegerToLanguage.put(35, "gle");
        macOsIntegerToLanguage.put(145, "glv");
        macOsIntegerToLanguage.put(148, "grc");
        macOsIntegerToLanguage.put(14, "ell");
        macOsIntegerToLanguage.put(133, "grn");
        macOsIntegerToLanguage.put(69, "guj");
        macOsIntegerToLanguage.put(10, "heb");
        macOsIntegerToLanguage.put(21, "hin");
        macOsIntegerToLanguage.put(26, "hmn");
        macOsIntegerToLanguage.put(15, "isl");
        macOsIntegerToLanguage.put(81, "ind");
        macOsIntegerToLanguage.put(3, "ita");
        macOsIntegerToLanguage.put(138, "jav");
        macOsIntegerToLanguage.put(11, "jpn");
        macOsIntegerToLanguage.put(149, "kal");
        macOsIntegerToLanguage.put(73, "kan");
        macOsIntegerToLanguage.put(61, "kas");
        macOsIntegerToLanguage.put(48, "kaz");
        macOsIntegerToLanguage.put(78, "khm");
        macOsIntegerToLanguage.put(90, "kin");
        macOsIntegerToLanguage.put(54, "kir");
        macOsIntegerToLanguage.put(23, "kor");
        macOsIntegerToLanguage.put(60, "kur");
        macOsIntegerToLanguage.put(79, "lao");
        macOsIntegerToLanguage.put(131, "lat");
        macOsIntegerToLanguage.put(28, "lav");
        macOsIntegerToLanguage.put(24, "lit");
        macOsIntegerToLanguage.put(43, "mkd");
        macOsIntegerToLanguage.put(72, "mal");
        macOsIntegerToLanguage.put(66, "mar");
        macOsIntegerToLanguage.put(83, "msa");
        macOsIntegerToLanguage.put(93, "mlg");
        macOsIntegerToLanguage.put(16, "mlt");
        macOsIntegerToLanguage.put(53, "mol");
        macOsIntegerToLanguage.put(57, "mon");
        macOsIntegerToLanguage.put(64, "nep");
        macOsIntegerToLanguage.put(9, "nob");
        macOsIntegerToLanguage.put(151, "nno");
        macOsIntegerToLanguage.put(71, "ori");
        macOsIntegerToLanguage.put(87, "orm");
        macOsIntegerToLanguage.put(70, "pan");
        macOsIntegerToLanguage.put(25, "pol");
        macOsIntegerToLanguage.put(8, "por");
        macOsIntegerToLanguage.put(132, "que");
        macOsIntegerToLanguage.put(37, "ron");
        macOsIntegerToLanguage.put(91, "run");
        macOsIntegerToLanguage.put(32, "rus");
        macOsIntegerToLanguage.put(65, "san");
        macOsIntegerToLanguage.put(42, "srp");
        macOsIntegerToLanguage.put(18, "hrv");
        macOsIntegerToLanguage.put(76, "sin");
        macOsIntegerToLanguage.put(63, "sit");
        macOsIntegerToLanguage.put(39, "slk");
        macOsIntegerToLanguage.put(40, "slv");
        macOsIntegerToLanguage.put(29, "sme");
        macOsIntegerToLanguage.put(62, "snd");
        macOsIntegerToLanguage.put(88, "som");
        macOsIntegerToLanguage.put(6, "spa");
        macOsIntegerToLanguage.put(139, "sun");
        macOsIntegerToLanguage.put(89, "swa");
        macOsIntegerToLanguage.put(5, "swe");
        macOsIntegerToLanguage.put(74, "tam");
        macOsIntegerToLanguage.put(135, "tat");
        macOsIntegerToLanguage.put(75, "tel");
        macOsIntegerToLanguage.put(55, "tgk");
        macOsIntegerToLanguage.put(82, "tgl");
        macOsIntegerToLanguage.put(22, "tha");
        macOsIntegerToLanguage.put(86, "tir");
        macOsIntegerToLanguage.put(147, "tog");
        macOsIntegerToLanguage.put(17, "tur");
        macOsIntegerToLanguage.put(56, "tuk");
        macOsIntegerToLanguage.put(136, "uig");
        macOsIntegerToLanguage.put(45, "ukr");
        macOsIntegerToLanguage.put(20, "urd");
        macOsIntegerToLanguage.put(47, "uzb");
        macOsIntegerToLanguage.put(80, "vie");
        macOsIntegerToLanguage.put(128, "cym");
        macOsIntegerToLanguage.put(41, "yid");
        macOsIntegerToLanguage.put(50, "aze");
        macOsIntegerToLanguage.put(150, "aze");
        macOsIntegerToLanguage.put(58, "mon");
        macOsIntegerToLanguage.put(59, "pus");
        macOsIntegerToLanguage.put(84, "msa");
        macOsIntegerToLanguage.put(143, "iku");
        macOsIntegerToLanguage.put(146, "gle");
    }
}

