/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.List;

public class HandlerReferenceAtom
extends Atom {
    int version;
    byte[] flags = new byte[3];
    String type;
    String subtype;
    String manufacturer;
    byte[] componentFlags = new byte[4];
    byte[] componentFlagsMask = new byte[4];
    String componentName;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.version = BitstreamReader.readU8(movieFile);
        movieFile.readFully(this.flags);
        this.type = BitstreamReader.readFourCC((DataInput)movieFile);
        this.subtype = BitstreamReader.readFourCC((DataInput)movieFile);
        this.manufacturer = BitstreamReader.readFourCC((DataInput)movieFile);
        movieFile.readFully(this.componentFlags);
        movieFile.readFully(this.componentFlagsMask);
        this.componentName = quickTimeParser.readString(movieFile, 0);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] type=" + this.type + "; subtype=" + this.subtype + "; manufacturer=" + this.manufacturer + "; componentName=" + this.componentName;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("version", this.version + ""));
        l.add(new KeyValuePair("flags", HandlerReferenceAtom.bytesAsHex(this.flags)));
        l.add(new KeyValuePair("type", this.type));
        l.add(new KeyValuePair("subtype", this.subtype));
        l.add(new KeyValuePair("manufacturer", "manufacturer"));
        l.add(new KeyValuePair("componentFlags", HandlerReferenceAtom.bytesAsHex(this.componentFlags)));
        l.add(new KeyValuePair("componentFlagsMask", HandlerReferenceAtom.bytesAsHex(this.componentFlagsMask)));
        l.add(new KeyValuePair("componentName", this.componentName));
        return l;
    }
}

