/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileTypeCompatabilityAtom
extends Atom {
    String majorBrand = "????";
    String minorVersion = "";
    private List<String> compatibleBrands = new ArrayList<String>();
    private Set<QuickTimeFile.Type> compatibleTypes = new HashSet<QuickTimeFile.Type>();
    private static final Map<String, QuickTimeFile.Type> BRAND_TO_FILE_TYPE_MAP = new HashMap<String, QuickTimeFile.Type>();

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public QuickTimeFile.Type getFileType() {
        QuickTimeFile.Type type = BRAND_TO_FILE_TYPE_MAP.get(this.majorBrand);
        if (type == null) {
            String brand;
            Iterator<String> i$ = this.getCompatibleBrands().iterator();
            while (i$.hasNext() && null == (type = BRAND_TO_FILE_TYPE_MAP.get(brand = i$.next()))) {
            }
        }
        if (null == type) {
            type = QuickTimeFile.Type.Unknown;
        }
        return type;
    }

    public List<String> getCompatibleBrands() {
        return this.compatibleBrands;
    }

    public Set<QuickTimeFile.Type> getCompatibleTypes() {
        return this.compatibleTypes;
    }

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.majorBrand = BitstreamReader.readFourCC((DataInput)movieFile);
        this.minorVersion = Integer.toHexString(movieFile.readUnsignedByte()) + Integer.toHexString(movieFile.readUnsignedByte());
        this.minorVersion = this.minorVersion + Integer.toHexString(movieFile.readUnsignedByte()) + Integer.toHexString(movieFile.readUnsignedByte());
        while (movieFile.getFilePointer() < this.offset + this.size) {
            String brand = BitstreamReader.readFourCC((DataInput)movieFile);
            if (brand.compareTo("\u0000\u0000\u0000\u0000") == 0) continue;
            this.compatibleBrands.add(brand);
            QuickTimeFile.Type t = BRAND_TO_FILE_TYPE_MAP.get(brand);
            if (null == t) continue;
            this.compatibleTypes.add(t);
        }
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] majorBrand=" + this.majorBrand + "; minorVersion=" + this.minorVersion + "; compatibilityBrands=" + this.compatibleBrands;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("majorBrand", this.majorBrand));
        l.add(new KeyValuePair("minorVersion", this.minorVersion));
        return l;
    }

    public boolean isCompatibleWithType(QuickTimeFile.Type type) {
        if (this.getFileType() == type) {
            return true;
        }
        return this.getCompatibleTypes().contains((Object)type);
    }

    static {
        BRAND_TO_FILE_TYPE_MAP.put("????", QuickTimeFile.Type.Unknown);
        BRAND_TO_FILE_TYPE_MAP.put("qt  ", QuickTimeFile.Type.QuickTime);
        BRAND_TO_FILE_TYPE_MAP.put("mp41", QuickTimeFile.Type.MPEG4);
        BRAND_TO_FILE_TYPE_MAP.put("mp42", QuickTimeFile.Type.MPEG4);
        BRAND_TO_FILE_TYPE_MAP.put("isom", QuickTimeFile.Type.MPEG4);
        BRAND_TO_FILE_TYPE_MAP.put("M4VP", QuickTimeFile.Type.MPEG4);
        BRAND_TO_FILE_TYPE_MAP.put("M4V ", QuickTimeFile.Type.MPEG4);
        BRAND_TO_FILE_TYPE_MAP.put("M4A ", QuickTimeFile.Type.MPEG4Audio);
    }
}

