/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class EditListAtom
extends QTAtom {
    List<TableEntry> table = Collections.emptyList();

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        int numberOfEntries = (int)BitstreamReader.readU32((DataInput)movieFile);
        this.table = new ArrayList<TableEntry>(numberOfEntries);
        for (int i = 0; i < numberOfEntries; ++i) {
            TableEntry entry = new TableEntry();
            entry.parse(quickTimeParser, movieFile);
            this.table.add(entry);
        }
    }

    public boolean isEditListContinuous() {
        if (this.getTable().size() == 0) {
            return true;
        }
        long mediaTime = this.getTable().get(0).getMediaTime();
        for (TableEntry entry : this.getTable()) {
            if (entry.getMediaTime() > mediaTime) {
                return false;
            }
            mediaTime = entry.getMediaTime();
        }
        return true;
    }

    public int numberOfEmpties() {
        int emptiesCount = 0;
        for (TableEntry tableEntry : this.table) {
            if (tableEntry.getMediaTime() >= 0L) continue;
            ++emptiesCount;
        }
        return emptiesCount;
    }

    public boolean isNormalRate() {
        boolean isNormal = true;
        for (TableEntry tableEntry : this.table) {
            if (tableEntry.getMediaRate() == 1.0f) continue;
            isNormal = false;
        }
        return isNormal;
    }

    public List<TableEntry> getTable() {
        return this.table;
    }

    public String toDetailedString() {
        return this.toString() + this.getTable();
    }

    @Override
    public String toString() {
        return super.toString() + this.table.toString();
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> props = super.getProperties();
        props.add(new KeyValuePair("numberOfEntries", this.getTable().size()));
        return props;
    }

    public class TableEntry {
        private float mediaRate;
        private long mediaTime;
        private long trackDuration;

        public void parse(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
            this.trackDuration = BitstreamReader.readU32((DataInput)movieFile);
            this.mediaTime = BitstreamReader.read32(movieFile);
            this.mediaRate = BitstreamReader.readFixedU32(movieFile);
        }

        public float getMediaRate() {
            return this.mediaRate;
        }

        public long getMediaTime() {
            return this.mediaTime;
        }

        public long getTrackDuration() {
            return this.trackDuration;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("mediaRate", this.getMediaRate()).append("mediaTime", this.getMediaTime()).append("trackDuration", this.getTrackDuration()).toString();
        }
    }
}

