/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.Dumpsterable;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.collect.Iterables;
import java.io.DataInput;
import java.io.IOException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public class DataReferenceAtom
extends QTAtom
implements Container {
    long numberOfEntries;
    List<DataReference> dataReferences;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
        this.dataReferences = new LinkedList<DataReference>();
        int i = 0;
        while ((long)i < this.numberOfEntries) {
            DataReference ref;
            long startFilePointer = movieFile.getFilePointer();
            long refSize = BitstreamReader.readU32((DataInput)movieFile);
            String refType = BitstreamReader.readFourCC((DataInput)movieFile);
            if (refType.equals("alis")) {
                ref = new FileSystemAliasDataReference();
                ref.size = refSize;
                ref.type = refType;
            } else if (refType.equals("url ")) {
                ref = new UrlDataReference();
                ref.size = refSize;
                ref.type = refType;
            } else {
                ref = new DataReference();
                ref.size = refSize;
                ref.type = refType;
            }
            ref.parseDataReference(ctx, quickTimeParser, movieFile);
            this.dataReferences.add(ref);
            movieFile.seek(startFilePointer + refSize);
            ++i;
        }
    }

    @Override
    public <T> List<T> findChildrenOfType(@Nonnull Class<T> clazz, boolean recurse) {
        return Container.Searcher.findChildrenOfType(clazz, recurse, this);
    }

    @Override
    public <T> T findSingleChildOfType(@Nonnull Class<T> clazz, boolean recurse, boolean failOnZero) {
        return Container.Searcher.findSingleChildOfType(clazz, recurse, failOnZero, true, this);
    }

    public List<? extends DataReference> getChildren() {
        return this.dataReferences;
    }

    @Override
    public <T> Iterable<T> getChildren(@Nonnull Class<T> ofType) {
        assert (null != ofType) : "Child type is a required parameter";
        return Iterables.filter(this.getChildren(), ofType);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("numberOfEntries", this.numberOfEntries + ""));
        return l;
    }

    public class UrlDataReference
    extends DataReference {
        String url;

        @Override
        public void parseDataReference(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
            super.parseDataReference(ctx, quickTimeParser, movieFile);
            if (this.selfReference) {
                return;
            }
            this.url = quickTimeParser.readCString(movieFile);
        }

        public String getUrl() {
            return this.url;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            l.add(new KeyValuePair("url", this.url + ""));
            return l;
        }
    }

    public class FileSystemAliasDataReference
    extends DataReference {
        long userType;
        int aliasSize;
        int aliasVersion;
        int aliasKind;
        String volumeName;
        Date unknownDate;
        int volumeSignature;
        long numberOfDirectories;
        String fileName;

        @Override
        public void parseDataReference(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
            super.parseDataReference(ctx, quickTimeParser, movieFile);
            if (this.selfReference) {
                return;
            }
            this.userType = BitstreamReader.readU32((DataInput)movieFile);
            this.aliasSize = BitstreamReader.readU16(movieFile);
            this.aliasVersion = BitstreamReader.readU16(movieFile);
            this.aliasKind = BitstreamReader.readU16(movieFile);
            this.volumeName = quickTimeParser.readString(movieFile, 31);
            this.volumeSignature = BitstreamReader.readU16(movieFile);
            long volumeType = BitstreamReader.readU16(movieFile);
            movieFile.seek(movieFile.getFilePointer() + 4L);
            this.fileName = quickTimeParser.readString(movieFile, 31);
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            List<KeyValuePair> l = super.getProperties();
            if (!this.selfReference) {
                l.add(new KeyValuePair("userType", this.userType + ""));
                l.add(new KeyValuePair("aliasSize", this.aliasSize + ""));
                l.add(new KeyValuePair("aliasVersion", this.aliasVersion + ""));
                l.add(new KeyValuePair("aliasKind", this.aliasKind + ""));
                l.add(new KeyValuePair("volumeName", this.volumeName));
                l.add(new KeyValuePair("unknownDate", String.valueOf(this.unknownDate)));
                l.add(new KeyValuePair("volumeSignature", this.volumeSignature + ""));
                l.add(new KeyValuePair("fileName", this.fileName));
            }
            return l;
        }
    }

    public class DataReference
    implements Dumpsterable {
        long size;
        String type;
        int version;
        byte[] flags;
        boolean selfReference;

        public void parseDataReference(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
            long offset = movieFile.getFilePointer();
            this.version = BitstreamReader.readU8(movieFile);
            this.flags = new byte[3];
            movieFile.readFully(this.flags);
            if (this.flags[2] == 1) {
                this.selfReference = true;
            } else if (this.flags[2] != 0) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found alis reference where flags were not 0x000000 or 0x000001", offset).put("flags", Long.toHexString(this.flags[2]));
            }
        }

        public boolean isSelfReference() {
            return this.selfReference;
        }

        public String toString() {
            return "[" + this.type + "] " + this.getProperties().toString();
        }

        public String getType() {
            return this.type;
        }

        @Override
        public List<KeyValuePair> getProperties() {
            LinkedList<KeyValuePair> l = new LinkedList<KeyValuePair>();
            l.add(new KeyValuePair("size", this.size + ""));
            l.add(new KeyValuePair("type", this.type));
            l.add(new KeyValuePair("version", this.version + ""));
            l.add(new KeyValuePair("flags", Atom.bytesAsHex(this.flags)));
            l.add(new KeyValuePair("selfReference", this.selfReference + ""));
            return l;
        }
    }
}

