/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class DataCompressionAtom
extends Atom {
    private static Logger logger = Logger.getLogger(DataCompressionAtom.class);
    public static final String ZLIB = "zlib";
    private String compressionType;

    public String getCompressionType() {
        return this.compressionType;
    }

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.compressionType = BitstreamReader.readFourCC((DataInput)movieFile);
        if (!ZLIB.equals(this.compressionType)) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Compressed metadata must use 'zlib' and not " + this.compressionType, movieFile.getFilePointer() - 4L);
        }
        logger.debug((Object)("comp type: " + this.compressionType));
    }
}

