/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.log4j.Logger;

public class CompressedMovieDataAtom
extends Atom {
    private static Logger logger = Logger.getLogger(CompressedMovieDataAtom.class);
    private long uncompressedSize;
    private byte[] compressedData;
    private byte[] uncompressedData;

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public byte[] getCompressedData() {
        return this.compressedData;
    }

    public byte[] getUncompressedData() {
        return this.uncompressedData;
    }

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser parser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        long offset = movieFile.getFilePointer();
        this.uncompressedSize = BitstreamReader.readU32((DataInput)movieFile);
        long compressedSize = this.size - 12L;
        this.compressedData = new byte[(int)compressedSize];
        movieFile.readFully(this.compressedData);
        this.uncompressedData = new byte[(int)this.uncompressedSize];
        Inflater inflater = new Inflater();
        inflater.setInput(this.compressedData);
        int bytesInflated = 0;
        try {
            bytesInflated = inflater.inflate(this.uncompressedData);
        }
        catch (DataFormatException dfe) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Error decompressing cmov data", offset).put("errorMessage", dfe.getMessage());
        }
        logger.debug((Object)("comp/uncomp/inflate: " + compressedSize + "/" + this.uncompressedSize + "/" + bytesInflated));
    }
}

