/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public class CompositionShiftLeastGreatestAtom
extends QTAtom {
    private long compositionOffsetToDisplayOffsetShift = 0L;
    private long leastDisplayOffset = 0L;
    private long greatestDisplayOffset = 0L;
    private long displayStartTime = 0L;
    private long displayEndTime = 0L;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.compositionOffsetToDisplayOffsetShift = BitstreamReader.read32(movieFile);
        this.leastDisplayOffset = BitstreamReader.read32(movieFile);
        this.greatestDisplayOffset = BitstreamReader.read32(movieFile);
        this.displayStartTime = BitstreamReader.read32(movieFile);
        this.displayEndTime = BitstreamReader.read32(movieFile);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("compositionOffsetToDisplayOffsetShift", this.compositionOffsetToDisplayOffsetShift));
        l.add(new KeyValuePair("leastDisplayOffset", this.leastDisplayOffset));
        l.add(new KeyValuePair("greatestDisplayOffset", this.greatestDisplayOffset));
        l.add(new KeyValuePair("displayStartTime", this.displayStartTime));
        l.add(new KeyValuePair("displayEndTime", this.displayEndTime));
        return l;
    }

    public long getCompositionOffsetToDisplayOffsetShift() {
        return this.compositionOffsetToDisplayOffsetShift;
    }

    public long getLeastDisplayOffset() {
        return this.leastDisplayOffset;
    }

    public long getGreatestDisplayOffset() {
        return this.greatestDisplayOffset;
    }

    public long getDisplayStartTime() {
        return this.displayStartTime;
    }

    public long getDisplayEndTime() {
        return this.displayEndTime;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] ";
    }
}

