/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class CompositionOffsetTableAtom
extends QTAtom {
    protected long numberOfEntries = 0L;
    protected long lastSampleIndex = Long.MIN_VALUE;
    List<OffsetTableEntry> countToOffsetTable;

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
        this.countToOffsetTable = new ArrayList<OffsetTableEntry>();
        long currentIndex = 0L;
        int i = 0;
        while ((long)i < this.numberOfEntries) {
            long sampleCount = BitstreamReader.readU32((DataInput)movieFile);
            long sampleOffset = BitstreamReader.read32(movieFile);
            OffsetTableEntry te = new OffsetTableEntry(i, currentIndex, sampleCount, sampleOffset);
            this.countToOffsetTable.add(te);
            currentIndex += te.sampleCount;
            ++i;
        }
        this.lastSampleIndex = currentIndex;
    }

    public Map<OffsetTableEntry, Overlap> getOverlappingSamples(@Nonnull SampleToTimeAtom sttsAtom, int maxOverlaps) {
        int cttsEntryIndex = 0;
        int sttsEntryIndex = 0;
        long cttsSampleIndex = Long.MIN_VALUE;
        long sttsSampleIndex = Long.MIN_VALUE;
        HashMap<Long, Long> displayTimeMap = new HashMap<Long, Long>();
        HashMap<OffsetTableEntry, Overlap> overlaps = new HashMap<OffsetTableEntry, Overlap>();
        while ((long)cttsEntryIndex < this.numberOfEntries || (long)sttsEntryIndex < sttsAtom.getNumberOfEntries()) {
            OffsetTableEntry te = this.countToOffsetTable.get(cttsEntryIndex);
            SampleToTimeAtom.TableEntry sttsTableEntry = sttsAtom.getCountToTimeTable().get(sttsEntryIndex);
            if (cttsSampleIndex == Long.MIN_VALUE) {
                cttsSampleIndex = te.startSampleIndex;
            }
            if (sttsSampleIndex == Long.MIN_VALUE) {
                sttsSampleIndex = sttsTableEntry.firstSampleNumber;
            }
            while (cttsSampleIndex <= te.startSampleIndex + te.sampleCount && sttsSampleIndex <= sttsTableEntry.firstSampleNumber + sttsTableEntry.getSampleCount()) {
                long sampleIndex = Math.min(cttsSampleIndex, sttsSampleIndex);
                long encodeTimeAtSampleIndex = sttsTableEntry.firstSampleStartTime + (sampleIndex - sttsTableEntry.firstSampleNumber) * sttsTableEntry.sampleDuration;
                long displayTimeAtSampleIndex = encodeTimeAtSampleIndex + te.sampleOffset;
                if (null != displayTimeMap.get(displayTimeAtSampleIndex)) {
                    overlaps.put(te, new Overlap((Long)displayTimeMap.get(displayTimeAtSampleIndex), sampleIndex, displayTimeAtSampleIndex));
                    if (overlaps.size() >= maxOverlaps) {
                        return overlaps;
                    }
                }
                displayTimeMap.put(displayTimeAtSampleIndex, sampleIndex);
                if (sampleIndex == cttsSampleIndex) {
                    ++cttsSampleIndex;
                }
                if (sampleIndex != sttsSampleIndex) continue;
                ++sttsSampleIndex;
            }
            if (cttsSampleIndex > te.startSampleIndex + te.sampleCount) {
                ++cttsEntryIndex;
            }
            if (sttsSampleIndex <= sttsTableEntry.firstSampleNumber + sttsTableEntry.getSampleCount()) continue;
            ++sttsEntryIndex;
        }
        return overlaps;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("numberOfEntries", this.numberOfEntries + ""));
        boolean firstChunk = true;
        for (OffsetTableEntry offsetTableEntry : this.countToOffsetTable) {
            if (firstChunk) {
                l.add(new KeyValuePair("compositionOffsetTable", ""));
                firstChunk = false;
            }
            l.add(new KeyValuePair(Long.toString(offsetTableEntry.sampleCount), Long.toString(offsetTableEntry.sampleOffset)));
        }
        return l;
    }

    @Override
    public String toString() {
        return super.toString() + "; numberOfEntries=" + this.numberOfEntries;
    }

    public static class Overlap {
        long firstSampleIndex;
        long secondSampleIndex;
        long displayTime;

        public Overlap(long firstIndex, long secondIndex, long displayTime) {
            this.firstSampleIndex = firstIndex;
            this.secondSampleIndex = secondIndex;
            this.displayTime = displayTime;
        }
    }

    public static class OffsetTableEntry
    implements Comparable<OffsetTableEntry> {
        long entryIndex;
        long startSampleIndex;
        long sampleCount;
        long sampleOffset;

        public OffsetTableEntry(long entryIndex, long startSampleIndex, long sampleCount, long sampleOffset) {
            this.entryIndex = entryIndex;
            this.startSampleIndex = startSampleIndex;
            this.sampleCount = sampleCount;
            this.sampleOffset = sampleOffset;
        }

        @Override
        public int compareTo(@Nonnull OffsetTableEntry otherTableEntry) {
            long te_min = this.startSampleIndex + this.sampleOffset;
            long te_max = this.startSampleIndex + this.sampleCount - 1L + this.sampleOffset;
            long other_te_min = otherTableEntry.startSampleIndex + otherTableEntry.sampleOffset;
            long other_te_max = otherTableEntry.startSampleIndex + otherTableEntry.sampleCount - 1L + otherTableEntry.sampleOffset;
            if (te_min < other_te_min && te_max < other_te_min) {
                return -1;
            }
            if (te_min > other_te_max && te_max > other_te_max) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return "entryIndex: " + this.entryIndex + ": index: " + this.startSampleIndex + ": sampleCount " + this.sampleCount + ", sampleOffset " + this.sampleOffset;
        }
    }
}

