/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime.atoms;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.atoms.DataInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.DataReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToChunk;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ChunkOffsetAtom
extends QTAtom {
    protected long numberOfEntries = 0L;
    protected List<Long> chunkOffsetTable;

    @Override
    public boolean validate(@Nonnull LeghornValidationContext ctx, SeekableDataInput movieFile) throws IOException {
        boolean s = super.validate(ctx, movieFile);
        long length = movieFile.length();
        Container parentContainer = (Container)((Object)this.getParent());
        SampleDescriptionsAtom sds = parentContainer.findSingleChildOfType(SampleDescriptionsAtom.class, false, true);
        SampleToChunk stsc = parentContainer.findSingleChildOfType(SampleToChunk.class, false, true);
        DataInformationAtom dinf = ((Container)((Object)this.getParent().getParent())).findSingleChildOfType(DataInformationAtom.class, false, true);
        DataReferenceAtom dref = dinf.findSingleChildOfType(DataReferenceAtom.class, false, true);
        SampleSizeAtom stsz = parentContainer.findSingleChildOfType(SampleSizeAtom.class, false, true);
        SampleToChunkIterator iter = new SampleToChunkIterator(stsc);
        for (int c = 0; c < this.chunkOffsetTable.size(); ++c) {
            DataReferenceAtom.DataReference dr;
            SampleToChunk.TableEntry stscTE = iter.getSampleToChunkEntry(c);
            long sdId = stscTE.sampleDescriptionId;
            SampleDescription sd = sds.get((int)sdId);
            int dataRefId = sd.getDataReference();
            if (dataRefId == 0) {
                dataRefId = 1;
            }
            if (!(dr = dref.getChildren().get(dataRefId - 1)).isSelfReference()) continue;
            long[] samplesIdx = stsc.getSamplesInChunk(c + 1);
            long sizeOfSamplesInChunk = 0L;
            for (long i : samplesIdx) {
                sizeOfSamplesInChunk += stsz.getSampleSize(i);
            }
            long endOfChunck = this.chunkOffsetTable.get(c) + sizeOfSamplesInChunk;
            if (endOfChunck > length) {
                ctx.addCheckAlert(this.offset, MediaValidationCode.FILE_APPEARS_CORRUPT, MediaUtil.dictionary.add("message", this + " Chunk offset \"" + this.offset + "\" (chunk #" + c + ") is invalid because it extends past the end of the file " + length));
            }
            s = false;
        }
        return s;
    }

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        super.parseAtom(ctx, quickTimeParser, movieFile);
        this.numberOfEntries = BitstreamReader.readU32((DataInput)movieFile);
        this.chunkOffsetTable = new ArrayList<Long>((int)this.numberOfEntries);
        this.readChunkOffsetTable(quickTimeParser, movieFile);
    }

    protected void readChunkOffsetTable(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        int i = 0;
        while ((long)i < this.numberOfEntries) {
            this.chunkOffsetTable.add(BitstreamReader.readU32((DataInput)movieFile));
            ++i;
        }
    }

    public long getChunkOffset(long chunkNumber) {
        if (chunkNumber > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("This movie has too many chunk offset entries for Leghorn");
        }
        return this.chunkOffsetTable.get((int)chunkNumber - 1);
    }

    public long getNumberOfChunks() {
        assert ((long)this.chunkOffsetTable.size() == this.numberOfEntries);
        return this.chunkOffsetTable.size();
    }

    @Override
    public String toString() {
        return super.toString() + "; numberOfEntries=" + this.numberOfEntries;
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("numberOfEntries", this.numberOfEntries + ""));
        boolean firstChunk = true;
        for (Long chunkOffset : this.chunkOffsetTable) {
            if (firstChunk) {
                l.add(new KeyValuePair("chunkOffsetTable", chunkOffset.toString()));
                firstChunk = false;
                continue;
            }
            l.add(new KeyValuePair("", chunkOffset.toString()));
        }
        return l;
    }

    private class SampleToChunkIterator {
        SampleToChunk stsc;
        int currentIdx = 0;
        SampleToChunk.TableEntry current;
        SampleToChunk.TableEntry next;

        SampleToChunkIterator(SampleToChunk stsc) {
            this.stsc = stsc;
            this.current = stsc.getSampleToChunk(this.currentIdx);
            if (stsc.getNumberOfEntries() > 1L) {
                this.next = stsc.getSampleToChunk(this.currentIdx + 1);
            }
        }

        SampleToChunk.TableEntry getSampleToChunkEntry(int chunkNumber) {
            SampleToChunk.TableEntry result = this.current;
            if (this.next != null && (long)chunkNumber >= this.next.firstChunk) {
                result = this.next;
                this.current = this.next;
                this.next = null;
                ++this.currentIdx;
                if (this.stsc.getNumberOfEntries() > (long)(this.currentIdx + 1)) {
                    this.next = this.stsc.getSampleToChunk(this.currentIdx + 1);
                }
            }
            return result;
        }
    }
}

