/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import noNamespace.DurationStatistics;
import noNamespace.Track;
import org.apache.commons.math.stat.Frequency;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;

public class SampleTimeStats {
    private SummaryStatistics summaryStats = new SummaryStatistics();
    private Frequency frequency = new Frequency();
    private long firstDuration;
    private long lastDuration;
    private SampleToTimeAtom stts;

    public SampleTimeStats(SampleToTimeAtom stts) {
        this.stts = stts;
        boolean first = true;
        List<SampleToTimeAtom.TableEntry> durationTable = stts.getCountToTimeTable();
        int tableSize = durationTable.size();
        long middleDurations = 0L;
        for (int i = 0; i < tableSize; ++i) {
            SampleToTimeAtom.TableEntry te = durationTable.get(i);
            long cnt = te.getSampleCount();
            long dur = te.getSampleDuration();
            for (long n = 0L; n < cnt; ++n) {
                boolean skip = false;
                if (first) {
                    this.firstDuration = dur;
                    first = false;
                    skip = true;
                }
                if (n + 1L == cnt && i + 1 == tableSize) {
                    this.lastDuration = dur;
                    skip = true;
                }
                if (skip) continue;
                this.summaryStats.addValue((double)dur);
                this.frequency.addValue(dur);
                ++middleDurations;
            }
        }
        if (middleDurations < 1L) {
            this.summaryStats.addValue(0.0);
            this.frequency.addValue(0);
        }
    }

    public long getFirstDuration() {
        return this.firstDuration;
    }

    public long getLastDuration() {
        return this.lastDuration;
    }

    public long getMin() {
        return (long)this.summaryStats.getMin();
    }

    public long getMax() {
        return (long)this.summaryStats.getMax();
    }

    public double getMean() {
        return this.summaryStats.getMean();
    }

    public double getStdDev() {
        return this.summaryStats.getStandardDeviation();
    }

    public long getMode() {
        Iterator iter = this.frequency.valuesIterator();
        double maxPct = -1.0;
        long maxValue = -1L;
        while (iter.hasNext()) {
            Long v = (Long)iter.next();
            double pct = this.frequency.getPct((Comparable)v);
            if (!(pct > maxPct)) continue;
            maxPct = pct;
            maxValue = v;
        }
        return maxValue;
    }

    public long getTotal() {
        return (long)this.summaryStats.getSum() + this.firstDuration + this.lastDuration;
    }

    public boolean getUniform() {
        return this.firstDuration == this.lastDuration && (this.summaryStats.getN() == 0L || this.getMax() == this.getMin() && this.firstDuration == this.getMax());
    }

    public static DurationStatistics addToTrack(Track track, SampleToTimeAtom stts, MediaHeaderAtom mdhdAtom) {
        DurationStatistics durStats = track.addNewDurationStatistics();
        if (stts != null && mdhdAtom != null) {
            SampleTimeStats sts = new SampleTimeStats(stts);
            durStats.setMeanDuration(sts.getMean());
            durStats.setUniform(sts.getUniform());
            durStats.setTotalDuration(BigInteger.valueOf(sts.getTotal()));
            durStats.setTimeScale(BigInteger.valueOf(mdhdAtom.getTimeScale()));
            if (!sts.getUniform()) {
                durStats.setMean(sts.getMean());
                durStats.setMode(BigInteger.valueOf(sts.getMode()));
                durStats.setStddev(sts.getStdDev());
                durStats.setFirst(BigInteger.valueOf(sts.getFirstDuration()));
                durStats.setLast(BigInteger.valueOf(sts.getLastDuration()));
                durStats.setMin(BigInteger.valueOf(sts.getMin()));
                durStats.setMax(BigInteger.valueOf(sts.getMax()));
            }
        }
        return durStats;
    }

    public String toString() {
        return "summaryStats " + this.summaryStats + ", frequency " + this.frequency + ", firstDuration " + this.firstDuration + ", lastDuration " + this.lastDuration;
    }
}

