/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.samples.CaptioningSample;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import org.apache.log4j.Logger;

public class SCCTrackExporter {
    private TrackAtom trackAtom;
    private SampleTableAtom sampleTableAtom;
    private SampleSizeAtom sampleSizeAtom;
    private SampleTableAtom.SampleCursor sampleCursor;
    private SeekableDataInput seekableDataInput;
    private BaseParser parser;
    private MediaHeaderAtom mediaHeaderAtom;
    private long timeScale;
    private EditListAtom editListAtom;
    private static final Logger LOG = Logger.getLogger(SCCTrackExporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        URI uri;
        QuickTimeValidationContext ctx;
        String fileArgument = args[0];
        BaseParser parser = BaseParser.determineParserToUseBasedOnFilename(fileArgument);
        QuickTimeFile file = parser.parseFile((LeghornValidationContext)(ctx = new QuickTimeValidationContext(fileArgument)), uri = ContainerContainerDescriberRunner.uriForString(fileArgument));
        List<MovieAtom> possibleMoovAtoms = file.findChildrenOfType(MovieAtom.class, false);
        if (possibleMoovAtoms.size() < 1) {
            throw new RuntimeException("Found zero \"moov\" atoms in " + file);
        }
        MovieAtom firstMovieAtom = possibleMoovAtoms.get(0);
        List<TrackAtom> tracks = firstMovieAtom.findChildrenOfType(TrackAtom.class, false);
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)uri);){
            for (TrackAtom track : tracks) {
                TrackAtom.Cursor trackAtomCursor = new TrackAtom.Cursor(track);
                if (!new MediaAtom.Cursor(trackAtomCursor.getMediaAtom()).getHandlerReferenceAtom().getSubtype().equals("clcp")) continue;
                SCCTrackExporter exporter = new SCCTrackExporter(parser, sdi, track);
                exporter.export(System.out);
            }
        }
    }

    public SCCTrackExporter(BaseParser parser, SeekableDataInput seekableDataInput, TrackAtom trackAtom) {
        this.trackAtom = trackAtom;
        this.parser = parser;
        this.seekableDataInput = seekableDataInput;
        TrackAtom.Cursor trackAtomCursor = new TrackAtom.Cursor(this.trackAtom);
        MediaAtom mediaAtom = trackAtomCursor.getMediaAtom();
        MediaAtom.Cursor mediaAtomCursor = new MediaAtom.Cursor(mediaAtom);
        this.mediaHeaderAtom = mediaAtomCursor.getMediaHeaderAtom();
        this.editListAtom = trackAtomCursor.getEditListAtom();
        if (!this.editListAtom.isEditListContinuous()) {
            LOG.warn((Object)("captions track with a non-continuous edit list " + this.editListAtom.toDetailedString()));
        }
        MediaInformationAtom mediaInformationAtom = mediaAtomCursor.getMediaInformationAtom();
        MediaInformationAtom.Cursor mediaHeaderAtomCursor = new MediaInformationAtom.Cursor(mediaInformationAtom);
        this.sampleTableAtom = mediaHeaderAtomCursor.getSampleTableAtom();
        this.sampleSizeAtom = mediaHeaderAtomCursor.getSampleSizeAtom();
        this.sampleCursor = new SampleTableAtom.SampleCursor(this.sampleTableAtom);
        this.timeScale = this.mediaHeaderAtom.getTimeScale();
    }

    public void export(OutputStream out) throws IOException {
        PrintWriter pw = new PrintWriter(out);
        pw.println("Scenarist_SCC V1.0");
        pw.println();
        while (this.sampleCursor.nextSample()) {
            CaptioningSample sample = new CaptioningSample();
            sample.parseSample(this.parser, this.seekableDataInput, this.sampleCursor);
            if (sample.verifySample(this.sampleCursor, this.mediaHeaderAtom)) {
                this.writeSample(pw, sample);
                continue;
            }
            pw.print("FAIL: ");
            this.writeSample(pw, sample);
        }
        pw.flush();
        pw.close();
    }

    protected void writeSample(PrintWriter pw, CaptioningSample sample) throws IOException {
        SMPTETimeCode timeCode = new SMPTETimeCode(new MediaTime(this.sampleCursor.getSampleTime(), this.timeScale).timeByScalingSampleRate(SMPTETimeCode.ntsc2997), SMPTETimeCode.Mode.nonDrop);
        pw.print(timeCode.toSMPTEString());
        pw.print('\t');
        byte[] clcpBytes = sample.getBytes();
        for (int i = 0; i < clcpBytes.length; ++i) {
            pw.print(this.pad(Integer.toHexString(clcpBytes[i] & 0xFF)));
            if (i % 2 != 1 || i >= clcpBytes.length - 1) continue;
            pw.print(' ');
        }
        pw.print('\n');
        pw.print('\n');
    }

    private String pad(String s) {
        return s.length() == 2 ? s : "0" + s;
    }
}

