/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class QuickTimeParser
extends BaseParser {
    @Override
    public QuickTimeFile.Type getQuickTimeFileType() {
        return QuickTimeFile.Type.QuickTime;
    }

    @Override
    public String readString(SeekableDataInput movieFile, int minsize) throws IOException {
        return this.readPString(movieFile, minsize);
    }

    public QuickTimeParser() {
    }

    public QuickTimeParser(QuickTimeFile.Type expectedType) {
        super(expectedType);
    }

    public String readPString(SeekableDataInput movieFile, int minLength) throws IOException {
        int length = movieFile.readUnsignedByte();
        byte[] pstringBytes = new byte[Math.max(length, minLength)];
        movieFile.readFully(pstringBytes);
        return new String(pstringBytes, 0, length, "ASCII");
    }

    public String readPString(SeekableDataInput movieFile) throws IOException {
        int length = movieFile.readUnsignedByte();
        byte[] pstringBytes = new byte[length];
        movieFile.readFully(pstringBytes);
        return new String(pstringBytes, 0, length, "ASCII");
    }

    @Override
    public String readCString(SeekableDataInput movieFile) throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        byte c = 0;
        while ((c = movieFile.readByte()) != 0) {
            strBuilder.append((char)c);
        }
        return strBuilder.toString();
    }
}

