/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.AtomInputStream;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.VideoSampleDescription;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QuickTimeImageOutputStream {
    private OutputStream os;

    public QuickTimeImageOutputStream(OutputStream os) {
        this.os = os;
    }

    public void writeImage(SampleTableAtom.SampleCursor sample) throws IOException {
        VideoSampleDescription sampleDescription = (VideoSampleDescription)sample.getSampleDescription();
        DataOutputStream dos = new DataOutputStream(this.os);
        dos.writeInt((int)(sample.getSampleLength() + 8L));
        dos.writeBytes("idat");
        AtomInputStream sis = new AtomInputStream(sample.getSeekableDataInput(), sample);
        int read = 0;
        byte[] buffer = new byte[16384];
        while (read != -1) {
            read = sis.read(buffer);
            if (read == -1) continue;
            dos.write(buffer, 0, read);
        }
        long length = sampleDescription.getAtomSize() + 8L;
        dos.writeInt((int)(length + 8L));
        dos.writeBytes("idsc");
        dos.writeInt((int)length);
        AtomInputStream sds = new AtomInputStream(sample.getSeekableDataInput(), sampleDescription);
        read = 0;
        while (read != -1) {
            read = sds.read(buffer);
            if (read == -1) continue;
            dos.write(buffer, 0, read);
        }
    }
}

