/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.MediaDescriptionGenerator;
import com.apple.jingle.leghorn.quicktime.atoms.FileTypeCompatabilityAtom;
import com.apple.jingle.leghorn.quicktime.atoms.HandlerReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.collect.Iterables;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class QuickTimeFile
implements Container {
    protected List<Atom> atoms = new LinkedList<Atom>();
    private long length;
    protected long totalNumberOfAtoms = 0L;
    private SeekableDataInput sdi;
    private Map<BigInteger, MediaDescriptionGenerator.TrackAtoms> trackAtomMap;
    private BaseParser parser;

    public QuickTimeFile(BaseParser parser, SeekableDataInput sdi, long length) {
        this.parser = parser;
        this.length = length;
        this.sdi = sdi;
    }

    public SeekableDataInput getSdi() {
        return this.sdi;
    }

    public List<? extends Atom> getChildren() {
        return this.atoms;
    }

    @Override
    public <T> Iterable<T> getChildren(@Nonnull Class<T> ofType) {
        assert (null != ofType) : "Child type is a required parameter";
        return Iterables.filter(this.getChildren(), ofType);
    }

    @Override
    public <T> List<T> findChildrenOfType(@Nonnull Class<T> clazz, boolean recurse) {
        return Container.Searcher.findChildrenOfType(clazz, recurse, this);
    }

    @Override
    public <T> T findSingleChildOfType(@Nonnull Class<T> clazz, boolean recurse, boolean failOnZero) {
        return Container.Searcher.findSingleChildOfType(clazz, recurse, failOnZero, true, this);
    }

    public MovieAtom findMovieAtom() {
        List<MovieAtom> possibleMoovAtoms = this.findChildrenOfType(MovieAtom.class, false);
        if (possibleMoovAtoms.size() < 1) {
            throw new RuntimeException("Found zero \"moov\" atoms in input");
        }
        return possibleMoovAtoms.get(0);
    }

    public List<TrackAtom> getVideoTracks() {
        List<TrackAtom> tracks = this.findMovieAtom().findChildrenOfType(TrackAtom.class, false);
        ArrayList<TrackAtom> ret = new ArrayList<TrackAtom>();
        for (TrackAtom t : tracks) {
            HandlerReferenceAtom href = t.getMediaAtom().getHandlerReferenceAtom();
            if (!href.getSubtype().equals("vide")) continue;
            ret.add(t);
        }
        return ret;
    }

    public long getLength() {
        return this.length;
    }

    public Type getType() {
        FileTypeCompatabilityAtom ftyp = this.findSingleChildOfType(FileTypeCompatabilityAtom.class, true, false);
        if (null == ftyp) {
            return Type.Unknown;
        }
        return ftyp.getFileType();
    }

    public String toString() {
        FileTypeCompatabilityAtom ftyp = this.findSingleChildOfType(FileTypeCompatabilityAtom.class, true, false);
        if (null == ftyp) {
            return "[qtfile] with no ftyp.";
        }
        return ftyp.toString();
    }

    public BaseParser getParser() {
        return this.parser;
    }

    public Map<BigInteger, MediaDescriptionGenerator.TrackAtoms> getTrackAtomMap() {
        return this.trackAtomMap;
    }

    public void setTrackAtomMap(Map<BigInteger, MediaDescriptionGenerator.TrackAtoms> trackAtomMap) {
        this.trackAtomMap = trackAtomMap;
    }

    public static enum Type {
        Unknown("binary/octect"),
        QuickTime("video/quicktime"),
        MPEG4("video/m4v"),
        MPEG4Audio("audio/m4a");

        private String mimeType;

        private Type(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public static Type typeForMimeType(String mimeType) {
            for (Type aType : Type.values()) {
                if (!aType.getMimeType().equalsIgnoreCase(mimeType)) continue;
                return aType;
            }
            return Unknown;
        }
    }
}

