/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.validator.SimpleDictionary;

public class QtFileCorruptException
extends Exception {
    private static final long serialVersionUID = -5836453876055085530L;
    private final MediaValidationCode validationCode;
    private final Long offset;
    private SimpleDictionary dictionary;

    public QtFileCorruptException(MediaValidationCode validationCode, String message) {
        super(message);
        this.validationCode = validationCode;
        this.dictionary = MediaUtil.dictionary.add("errorMessage", message);
        this.offset = null;
    }

    public QtFileCorruptException(MediaValidationCode validationCode, String message, Long offset) {
        super(message);
        this.validationCode = validationCode;
        this.dictionary = MediaUtil.dictionary.add("errorMessage", message);
        this.offset = offset;
    }

    public QtFileCorruptException put(String key, String value) {
        this.dictionary = this.dictionary.add(key, value);
        return this;
    }

    public void addCheckAlert(LeghornValidationContext ctx) {
        if (null != this.offset) {
            ctx.addCheckAlert(this.offset, this.validationCode, this.dictionary);
        } else {
            ctx.addCheckAlert(this.validationCode, this.dictionary);
        }
    }
}

