/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.util.KeyValuePair;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.List;

public abstract class QTAtom
extends Atom {
    int version = -1;
    byte[] flags = new byte[3];

    @Override
    public void parseAtom(LeghornValidationContext ctx, BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException, QtFileCorruptException {
        this.version = BitstreamReader.readU8(movieFile);
        movieFile.readFully(this.flags);
    }

    @Override
    public List<KeyValuePair> getProperties() {
        List<KeyValuePair> l = super.getProperties();
        l.add(new KeyValuePair("version", this.version + ""));
        l.add(new KeyValuePair("flags", QTAtom.bytesAsHex(this.flags)));
        l.add(new KeyValuePair("size", this.size));
        return l;
    }

    @Override
    public String toString() {
        return "[" + this.atomType + "] ";
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getFlags() {
        return this.flags;
    }
}

