/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.avc.PictureParameterSet;
import com.apple.jingle.leghorn.fileformat.exceptions.DescriptionException;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.media.beans.DescriberInformation;
import com.apple.jingle.leghorn.media.validator.ValidationLevel;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.CoreAudioTypes;
import com.apple.jingle.leghorn.quicktime.DataRateStats;
import com.apple.jingle.leghorn.quicktime.GraphicsModeHelper;
import com.apple.jingle.leghorn.quicktime.Matrix;
import com.apple.jingle.leghorn.quicktime.QTAtom;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.SampleTimeStats;
import com.apple.jingle.leghorn.quicktime.atoms.DataReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.ExtendedLanguageAtom;
import com.apple.jingle.leghorn.quicktime.atoms.HandlerReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MDatAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MetaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackGroupAssignmentAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackLoadSettingsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackReferenceInstanceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.VideoMediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.DataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.HdlrAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.IlstAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.KeysAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.MdtaItemKey;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.MetadataItemAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.ValueAtom;
import com.apple.jingle.leghorn.quicktime.atoms.metatypeatoms.WellKnownTypes;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataInternationalText;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListAllFAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListInternationalTextContainer;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListItunesMetaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListSelOAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataListWLOCAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.UserDataTagCAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesIlistDataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.udtatypeatoms.itunesmetadata.ItunesIlistMetadataItem;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.AvccSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SoundSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.SubtitleSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.VTTSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.VideoSampleDescription;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.chanSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dac3SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dec3SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.dmixSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.esdsSampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.udc2SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.sampledescriptions.udi2SampleDescriptionExtension;
import com.apple.jingle.leghorn.quicktime.samples.TimecodeSample;
import com.apple.jingle.leghorn.timecode.MediaTime;
import com.apple.jingle.leghorn.timecode.SMPTETimeCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import noNamespace.AvcC;
import noNamespace.Channel;
import noNamespace.ChannelLayout;
import noNamespace.ChapterImageTrack;
import noNamespace.ChapterTrack;
import noNamespace.Clap;
import noNamespace.Clli;
import noNamespace.Clock;
import noNamespace.Codec;
import noNamespace.ColorPrimary;
import noNamespace.Colr;
import noNamespace.DataContentTrack;
import noNamespace.DataRate;
import noNamespace.DataSize;
import noNamespace.DefaultTextBox;
import noNamespace.Dimensions;
import noNamespace.DmixDrc;
import noNamespace.Duration;
import noNamespace.EditList;
import noNamespace.ExtendedLanguage;
import noNamespace.ExternalReference;
import noNamespace.ExternalReferences;
import noNamespace.Fiel;
import noNamespace.FieldDominance;
import noNamespace.FontEntry;
import noNamespace.FontStyle;
import noNamespace.ForcedSubtitle;
import noNamespace.FrameRateMode;
import noNamespace.Ftab;
import noNamespace.ItunesMetadataAtoms;
import noNamespace.Justification;
import noNamespace.Language;
import noNamespace.Mdcv;
import noNamespace.MetadataAtoms;
import noNamespace.MovieDocument;
import noNamespace.NalUnits;
import noNamespace.OnScreenDisplayTrack;
import noNamespace.Pasp;
import noNamespace.PicParameterSet;
import noNamespace.PictureParameterSets;
import noNamespace.Rqdf;
import noNamespace.SampleRate;
import noNamespace.SoundTrack;
import noNamespace.SubtitleTrack;
import noNamespace.TaggedCharacteristics;
import noNamespace.TimecodeInfo;
import noNamespace.TimecodeTrack;
import noNamespace.Track;
import noNamespace.TrackLoadSettings;
import noNamespace.TrackReference;
import noNamespace.UserDataAtoms;
import noNamespace.VideoTrack;
import noNamespace.VttR;
import noNamespace.VttResource;
import noNamespace.VttTrack;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlOptions;

public class MediaDescriptionGenerator {
    private static Logger lager = Logger.getLogger(MediaDescriptionGenerator.class);
    private static final Collection<String> BLACKLISTED_METADATA_TYPES = Collections.singleton("info.ixml.xml");
    private static Map<String, String> videoCodecDisplayNames;
    private static Map<String, String> audioCodecDisplayNames;
    private static Map<String, String> audioFourCCDisplayNames;
    private static Map<String, String> audioFourCCRFC6381Names;

    public static void main(String[] args) {
        try {
            Logger.getRootLogger().setLevel(Level.ERROR);
            BasicConfigurator.configure();
            String fileArgument = args[0];
            BaseParser parser = BaseParser.determineParserToUseBasedOnFilename(fileArgument);
            URI uri = ContainerContainerDescriberRunner.uriForString(fileArgument);
            QuickTimeValidationContext ctx = new QuickTimeValidationContext(fileArgument);
            QuickTimeFile file = parser.parseFile((LeghornValidationContext)ctx, uri);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            MediaDescriptionGenerator.generateDescription(ctx, file, baos);
            System.out.println(baos.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void generateDescription(LeghornValidationContext ctx, QuickTimeFile file, OutputStream os) throws IOException, DescriptionException {
        MovieDocument doc = MediaDescriptionGenerator.generateDescription(ctx, file);
        XmlOptions options = new XmlOptions();
        options.setSavePrettyPrint();
        doc.save(os, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MovieDocument generateDescription(LeghornValidationContext ctx, QuickTimeFile file) throws IOException {
        List<MovieAtom> possibleMoovAtoms;
        SeekableDataInput sdi = file.getSdi();
        ctx.addCheckAlert(MediaValidationCode.DATA_INFO, ctx.dataDump().appendTo(MediaUtil.dictionary));
        MovieDocument doc = MovieDocument.Factory.newInstance();
        MovieDocument.Movie movie = doc.addNewMovie();
        XmlCursor cursor = movie.newCursor();
        cursor.insertComment("Generated by the FoghornLeghorn Quicktime MediaDescriptionGenerator, version " + Configuration.getVersion());
        cursor.insertComment("File URL: \"\"");
        DescriberInformation describerInformation = movie.addNewDescriber();
        describerInformation.newCursor().insertNamespace("ma", "http://beans.media.leghorn.jingle.apple.com");
        describerInformation.setName(ctx.getDescriptionToolName());
        describerInformation.setVersion(ctx.getDescriptionToolVersion());
        movie.setType(file.getType().toString().toLowerCase());
        if (file.findChildrenOfType(MDatAtom.class, false).size() < 1 && !ctx.hasValidations(ValidationLevel.ERROR)) {
            ctx.addCheckAlert(MediaValidationCode.MOV_CONTAINER_NO_MDAT, MediaUtil.dictionary.add("message", "Found zero \"mdat\" atoms in " + (file.getSdi() != null ? file.getSdi().getFileName() : "[unk file]") + ". Expected one or more"));
        }
        if ((possibleMoovAtoms = file.findChildrenOfType(MovieAtom.class, false)).size() < 1) {
            if (!ctx.hasValidations(ValidationLevel.ERROR)) {
                ctx.addCheckAlert(MediaValidationCode.MOV_CONTAINER_NO_MOOVS, MediaUtil.dictionary.add("message", "Found zero \"moov\" atoms in " + file + ". Expected exactly one."));
            }
        } else {
            try {
                if (possibleMoovAtoms.size() > 1) {
                    lager.info((Object)("Expected 1 moov atom but found " + possibleMoovAtoms.size() + ", continuing but using only the first moov atom in " + file));
                }
                MovieAtom firstMovieAtom = possibleMoovAtoms.get(0);
                TrackIterationContext tic = new TrackIterationContext(movie.addNewTracks(), file, firstMovieAtom);
                MovieHeaderAtom mhdrAtom = firstMovieAtom.findChild(MovieHeaderAtom.class, new Container.Searcher.Option[0]);
                if (null == mhdrAtom) {
                    ctx.addCheckAlert(MediaValidationCode.MOV_CONTAINER_NO_MVHD, MediaUtil.dictionary);
                } else {
                    noNamespace.Matrix movieMatrix = movie.addNewMatrix();
                    Matrix matrix = mhdrAtom.getMatrix();
                    movieMatrix.setIdentity(matrix.isIdentity());
                    if (!matrix.isIdentity()) {
                        movieMatrix.setA(matrix.getA());
                        movieMatrix.setB(matrix.getB());
                        movieMatrix.setU(matrix.getU());
                        movieMatrix.setC(matrix.getC());
                        movieMatrix.setD(matrix.getD());
                        movieMatrix.setV(matrix.getV());
                        movieMatrix.setTx(matrix.getTx());
                        movieMatrix.setTy(matrix.getTy());
                        movieMatrix.setW(matrix.getW());
                    }
                    Clock clock = movie.addNewClock();
                    clock.setPosterTime(mhdrAtom.getPosterTime());
                    clock.setPreviewDuration(mhdrAtom.getPreviewDuration());
                    clock.setPreviewTime(mhdrAtom.getPreviewTime());
                    clock.setTotalDuration(mhdrAtom.getDuration());
                    clock.setTimeScale(mhdrAtom.getTimeScale());
                }
                for (TrackAtom trackAtom : firstMovieAtom.findChildren(TrackAtom.class, new Container.Searcher.Option[0])) {
                    List<TrackReferenceInstanceAtom> trefInstances = trackAtom.findChildren(TrackReferenceInstanceAtom.class, Container.Searcher.Option.RECURSE);
                    for (TrackReferenceInstanceAtom trackReferenceInstanceAtom : trefInstances) {
                        if (!trackReferenceInstanceAtom.getAtomType().equals("chap")) continue;
                        for (Long trackId : trackReferenceInstanceAtom.getTrackReferences()) {
                            tic.knownChaptersTracks.add(trackId);
                        }
                    }
                }
                List<UserDataAtom> userDataAtoms = firstMovieAtom.findChildrenOfType(UserDataAtom.class, false);
                UserDataAtoms udta = null;
                ItunesMetadataAtoms imeta = null;
                for (QTContainerAtom qTContainerAtom : userDataAtoms) {
                    for (QTContainerAtom atomFromList : qTContainerAtom.getChildren(QTContainerAtom.class)) {
                        UserDataAtoms.UserData u;
                        UserDataListAtom atom;
                        if (atomFromList instanceof UserDataListInternationalTextContainer) {
                            for (UserDataInternationalText itAtom : ((UserDataListInternationalTextContainer)atomFromList).getInternationlTextAtomList()) {
                                if (udta == null) {
                                    udta = movie.addNewUserDataAtoms();
                                }
                                UserDataAtoms.UserData u2 = udta.addNewUserData();
                                u2.setType(atomFromList.getAtomType());
                                u2.setLanguage(itAtom.getAtomType());
                                u2.setStringValue(itAtom.getValue());
                            }
                            continue;
                        }
                        if (atomFromList instanceof UserDataListWLOCAtom) {
                            atom = (UserDataListWLOCAtom)atomFromList;
                            if (udta == null) {
                                udta = movie.addNewUserDataAtoms();
                            }
                            u = udta.addNewUserData();
                            u.setType(atom.getAtomType());
                            u.setX(BigInteger.valueOf(((UserDataListWLOCAtom)atom).getX()));
                            u.setY(BigInteger.valueOf(((UserDataListWLOCAtom)atom).getY()));
                            continue;
                        }
                        if (atomFromList instanceof UserDataListSelOAtom) {
                            if (udta == null) {
                                udta = movie.addNewUserDataAtoms();
                            }
                            atom = (UserDataListSelOAtom)atomFromList;
                            u = udta.addNewUserData();
                            u.setType(atom.getAtomType());
                            u.setStringValue(String.valueOf(((UserDataListSelOAtom)atom).getSelOValue()));
                            continue;
                        }
                        if (atomFromList instanceof UserDataListAllFAtom) {
                            if (udta == null) {
                                udta = movie.addNewUserDataAtoms();
                            }
                            atom = (UserDataListAllFAtom)atomFromList;
                            u = udta.addNewUserData();
                            u.setType(atom.getAtomType());
                            u.setStringValue(String.valueOf(((UserDataListAllFAtom)atom).getPlayAllFrames()));
                            continue;
                        }
                        if (!(atomFromList instanceof UserDataListItunesMetaAtom)) continue;
                        for (QTContainerAtom metaAtom : atomFromList.getChildren(QTContainerAtom.class)) {
                            for (ItunesIlistMetadataItem iList : metaAtom.getChildren(ItunesIlistMetadataItem.class)) {
                                if (!iList.shouldReport()) continue;
                                if (imeta == null) {
                                    imeta = movie.addNewItunesMetadataAtoms();
                                }
                                for (ItunesIlistDataAtom data : iList.getDatas()) {
                                    if (data.getLocale() != 0) continue;
                                    ItunesMetadataAtoms.ItunesMetadata m = imeta.addNewItunesMetadata();
                                    m.setType(iList.getMeaning());
                                    m.setFormat(data.getFormat());
                                    m.setStringValue(data.getValue());
                                }
                            }
                        }
                    }
                }
                MediaDescriptionGenerator.lookForQuicktimeMetadataAtom(firstMovieAtom, movie);
                MediaDescriptionGenerator.recurseLookingForTracks(ctx, file, sdi, firstMovieAtom, tic);
                StringBuilder codecStringBuilder = new StringBuilder();
                for (String label : tic.codecs) {
                    codecStringBuilder.append(label).append(", ");
                }
                if (2 < codecStringBuilder.length()) {
                    codecStringBuilder.setLength(codecStringBuilder.length() - 2);
                }
                movie.setCodecs(codecStringBuilder.toString());
                file.setTrackAtomMap(tic.trackAtomMap);
            }
            catch (QtFileCorruptException e) {
                e.addCheckAlert(ctx);
            }
        }
        if (ctx.hasValidations(ValidationLevel.DEBUG)) {
            ctx.populateAlertList(movie.addNewNotifications(), ValidationLevel.DEBUG);
        }
        XmlOptions xmlOptions = new XmlOptions();
        LinkedList errors = new LinkedList();
        xmlOptions.setErrorListener(errors);
        if (!doc.validate(xmlOptions)) {
            throw new RuntimeException("Generated description does not validate: " + errors + "\n" + doc.toString());
        }
        MovieDocument movieDocument = doc;
        return movieDocument;
    }

    private static void lookForQuicktimeMetadataAtom(MovieAtom firstMovieAtom, MovieDocument.Movie movie) {
        List<MetaAtom> metaAtoms = firstMovieAtom.findChildren(MetaAtom.class, new Container.Searcher.Option[0]);
        QTContainerAtom keys = null;
        HdlrAtom hdlr = null;
        QTContainerAtom ilst = null;
        for (QTContainerAtom qTContainerAtom : metaAtoms) {
            for (QTAtom atomFromList : qTContainerAtom.getChildren(QTAtom.class)) {
                if (atomFromList.getAtomType().equals("keys")) {
                    keys = (KeysAtom)atomFromList;
                    continue;
                }
                if (atomFromList.getAtomType().equals("hdlr")) {
                    hdlr = (HdlrAtom)atomFromList;
                    continue;
                }
                if (!atomFromList.getAtomType().equals("ilst")) continue;
                ilst = (IlstAtom)atomFromList;
            }
        }
        if (hdlr != null && hdlr.getHandlerType().equals("mdta")) {
            MetadataAtoms metaAtom = null;
            for (MdtaItemKey itemKey : keys.getChildren(MdtaItemKey.class)) {
                for (MetadataItemAtom atom : ilst.getChildren(MetadataItemAtom.class)) {
                    for (DataAtom dataAtom : atom.getChildren(DataAtom.class)) {
                        for (ValueAtom valueAtom : dataAtom.getChildren(ValueAtom.class)) {
                            if (atom.getKeyNumber() != itemKey.getKeyNumber()) continue;
                            if (valueAtom.getSetOfTypes() == 28) {
                                MediaDescriptionGenerator.lookForQuicktimeMetadataAtom(firstMovieAtom, movie);
                                continue;
                            }
                            for (String s : valueAtom.getLocales()) {
                                if (metaAtom == null) {
                                    metaAtom = movie.addNewMetadataAtoms();
                                }
                                MetadataAtoms.Metadata m = metaAtom.addNewMetadata();
                                m.setType(itemKey.getKeyValueString());
                                m.setFormat(WellKnownTypes.WELL_KNOWN_TYPE_MAP.get(valueAtom.getTypeAsInt()));
                                m.setLocale(s);
                                try {
                                    if (BLACKLISTED_METADATA_TYPES.contains(itemKey.getKeyValueString())) {
                                        m.setOmitted("true");
                                        continue;
                                    }
                                    m.setStringValue(valueAtom.getValue());
                                }
                                catch (UnsupportedEncodingException e) {
                                    m.setOmitted("true");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void lookForQuicktimeMetadataAtom(TrackAtom trackAtom, Track track) {
        List<MetaAtom> metaAtoms = trackAtom.findChildrenOfType(MetaAtom.class, false);
        QTContainerAtom keys = null;
        HdlrAtom hdlr = null;
        QTContainerAtom ilst = null;
        for (QTContainerAtom qTContainerAtom : metaAtoms) {
            for (QTAtom atomFromList : qTContainerAtom.getChildren(QTAtom.class)) {
                if (atomFromList.getAtomType().equals("keys")) {
                    keys = (KeysAtom)atomFromList;
                    continue;
                }
                if (atomFromList.getAtomType().equals("hdlr")) {
                    hdlr = (HdlrAtom)atomFromList;
                    continue;
                }
                if (!atomFromList.getAtomType().equals("ilst")) continue;
                ilst = (IlstAtom)atomFromList;
            }
        }
        if (hdlr != null && hdlr.getHandlerType().equals("mdta")) {
            MetadataAtoms metaAtom = null;
            for (MdtaItemKey itemKey : keys.getChildren(MdtaItemKey.class)) {
                for (MetadataItemAtom atom : ilst.getChildren(MetadataItemAtom.class)) {
                    for (DataAtom dataAtom : atom.getChildren(DataAtom.class)) {
                        for (ValueAtom valueAtom : dataAtom.getChildren(ValueAtom.class)) {
                            if (atom.getKeyNumber() != itemKey.getKeyNumber()) continue;
                            if (valueAtom.getSetOfTypes() == 28) {
                                MediaDescriptionGenerator.lookForQuicktimeMetadataAtom(trackAtom, track);
                                continue;
                            }
                            for (String s : valueAtom.getLocales()) {
                                if (metaAtom == null) {
                                    metaAtom = track.addNewMetadataAtoms();
                                }
                                MetadataAtoms.Metadata m = metaAtom.addNewMetadata();
                                m.setType(new String(itemKey.getKeyValue()));
                                m.setFormat(WellKnownTypes.WELL_KNOWN_TYPE_MAP.get(valueAtom.getTypeAsInt()));
                                m.setLocale(s);
                                try {
                                    if (BLACKLISTED_METADATA_TYPES.contains(itemKey.getKeyValueString())) {
                                        m.setOmitted("true");
                                        continue;
                                    }
                                    m.setStringValue(valueAtom.getValue());
                                }
                                catch (UnsupportedEncodingException e) {
                                    m.setOmitted("true");
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private static void recurseLookingForTracks(LeghornValidationContext ctx, QuickTimeFile file, SeekableDataInput sdi, Atom atom, TrackIterationContext tic) throws IOException, QtFileCorruptException {
        if (atom instanceof TrackAtom) {
            TrackAtom trakAtom = (TrackAtom)atom;
            TrackHeaderAtom tkhdAtom = trakAtom.findChild(TrackHeaderAtom.class, new Container.Searcher.Option[0]);
            if (null == tkhdAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a track header atom");
            }
            MediaAtom mAtom = trakAtom.findChild(MediaAtom.class, Container.Searcher.Option.RECURSE);
            if (null == mAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a media atom");
            }
            MediaHeaderAtom mdhdAtom = mAtom.findChild(MediaHeaderAtom.class, new Container.Searcher.Option[0]);
            if (null == mdhdAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a media head atom");
            }
            HandlerReferenceAtom hdlrAtom = mAtom.findChild(HandlerReferenceAtom.class, new Container.Searcher.Option[0]);
            if (null == hdlrAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a handler reference atom");
            }
            MediaInformationAtom minfAtom = mAtom.findChild(MediaInformationAtom.class, new Container.Searcher.Option[0]);
            if (null == minfAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a media information atom");
            }
            SampleTableAtom stblAtom = minfAtom.findChild(SampleTableAtom.class, new Container.Searcher.Option[0]);
            if (null == stblAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found track without a sample table atom");
            }
            SampleSizeAtom stszAtom = stblAtom.findChild(SampleSizeAtom.class, new Container.Searcher.Option[0]);
            if (hdlrAtom.getSubtype().equals("vide")) {
                if (tic.knownChaptersTracks.contains(tkhdAtom.getTrackId())) {
                    ChapterImageTrack track = tic.tracks.addNewChapterImage();
                    MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                    MediaDescriptionGenerator.processChapterImageTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom);
                } else {
                    if (stszAtom == null) {
                        throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Can't make sense of a video track with no STSZ atom!");
                    }
                    VideoTrack track = tic.tracks.addNewVideo();
                    MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                    MediaDescriptionGenerator.processVideoTrack(ctx, track, trakAtom, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic);
                }
            } else if (hdlrAtom.getSubtype().equals("soun")) {
                if (stszAtom == null) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Can't make sense of a sound track with no STSZ atom!");
                }
                SoundTrack track = tic.tracks.addNewSound();
                MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                MediaDescriptionGenerator.processSoundTrack(track, trakAtom, mdhdAtom, minfAtom, stblAtom, tic, tkhdAtom);
            } else if (hdlrAtom.getSubtype().equals("tmcd") || hdlrAtom.getSubtype().equals("tc64")) {
                TimecodeTrack track = tic.tracks.addNewTimecode();
                MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                MediaDescriptionGenerator.processTimecodeTrack(file, sdi, track, trakAtom, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic);
            } else if (hdlrAtom.getSubtype().equals("text")) {
                if (tic.knownChaptersTracks.contains(tkhdAtom.getTrackId())) {
                    if (stszAtom == null) {
                        throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Can't make sense of a text track with no STSZ atom!");
                    }
                    ChapterTrack track = tic.tracks.addNewChapter();
                    MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                    MediaDescriptionGenerator.processChapterTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom);
                } else if (MediaDescriptionGenerator.isVTTTrack(mAtom)) {
                    VttTrack track = tic.tracks.addNewWebvttSubtitle();
                    MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                    MediaDescriptionGenerator.processWebVTTTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom);
                } else {
                    MediaDescriptionGenerator.processTrack(tic.tracks.addNewUnknown(), tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                }
            } else if (hdlrAtom.getSubtype().equals("sbtl")) {
                SubtitleTrack track = tic.tracks.addNewSubtitle();
                MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                MediaDescriptionGenerator.processSubtitleTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom);
            } else if (hdlrAtom.getSubtype().equals("clcp")) {
                OnScreenDisplayTrack track = tic.tracks.addNewCaption();
                MediaDescriptionGenerator.processTrack((Track)track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
                MediaDescriptionGenerator.processCaptionTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom);
            } else {
                Track track = tic.tracks.addNewUnknown();
                MediaDescriptionGenerator.processTrack(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, tic, trakAtom, hdlrAtom);
            }
        } else if (atom instanceof QTContainerAtom) {
            QTContainerAtom qtcAtom = (QTContainerAtom)atom;
            MediaDescriptionGenerator.recurseLookingForTracks(ctx, file, sdi, qtcAtom.getChildren(), tic);
        }
    }

    private static boolean isVTTTrack(MediaAtom mediaAtom) {
        SampleDescriptionsAtom stsdAtom = mediaAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (stsdAtom == null) {
            return false;
        }
        List<SampleDescription> sampleDescriptions = stsdAtom.findChildren(SampleDescription.class, new Container.Searcher.Option[0]);
        if (sampleDescriptions.isEmpty()) {
            return false;
        }
        return "wvtt".equals(sampleDescriptions.get(0).getDataFormat()) || "svtt".equals(sampleDescriptions.get(0).getDataFormat());
    }

    private static void processWebVTTTrack(VttTrack track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom) throws QtFileCorruptException {
        VTTSampleDescription.vttRSampleDescriptionExtension resourcesExtension;
        VTTSampleDescription.rqdfSampleDescriptionExtension featuresExtension;
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        SampleDescriptionsAtom stsdAtom = mAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (null == stsdAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a webVTT track without a sample descriptions atom");
        }
        List<VTTSampleDescription> vttSampleDescriptions = stsdAtom.findChildren(VTTSampleDescription.class, Container.Searcher.Option.RECURSE);
        if (vttSampleDescriptions.size() < 1) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found webVTT track with zero video sample descriptions");
        }
        VTTSampleDescription vttSampleDescription = vttSampleDescriptions.get(0);
        noNamespace.SampleDescription sampleDescription = track.addNewSampleDescription();
        VTTSampleDescription.vttCSampleDescriptionExtension configurationExtension = vttSampleDescription.findSingleChildOfType(VTTSampleDescription.vttCSampleDescriptionExtension.class, false, true);
        sampleDescription.setVttConfiguration(configurationExtension.config());
        VTTSampleDescription.vlabSampleDescriptionExtension labelExtension = vttSampleDescription.findSingleChildOfType(VTTSampleDescription.vlabSampleDescriptionExtension.class, false, false);
        if (labelExtension != null) {
            sampleDescription.setVttLabel(labelExtension.label());
        }
        if ((featuresExtension = vttSampleDescription.findSingleChildOfType(VTTSampleDescription.rqdfSampleDescriptionExtension.class, false, false)) != null && featuresExtension.features().size() > 0) {
            Rqdf requiredFeatures = sampleDescription.addNewVttFeatures();
            for (String ss : featuresExtension.features()) {
                requiredFeatures.addFeature(ss);
            }
        }
        if ((resourcesExtension = vttSampleDescription.findSingleChildOfType(VTTSampleDescription.vttRSampleDescriptionExtension.class, false, false)) != null && resourcesExtension.payloads().size() > 0) {
            VttR requiredFeatures = sampleDescription.addNewVttResources();
            for (VTTSampleDescription.vttResourcePayload payload : resourcesExtension.payloads()) {
                int totalPayloadSize = 0;
                for (String ss : payload.payloads()) {
                    totalPayloadSize += ss.length();
                }
                VttResource vttResource = requiredFeatures.addNewResource();
                vttResource.setRole(payload.role());
                vttResource.setMimeFormat(payload.mimeFormat());
                vttResource.setMimeFormatURI(payload.mimeFormatURI());
                vttResource.setPayloadCount(BigInteger.valueOf(payload.payloads().size()));
                vttResource.setTotalPayloadSize(BigInteger.valueOf(totalPayloadSize));
            }
        }
    }

    private static void processChapterTrack(ChapterTrack track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom) throws QtFileCorruptException {
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        if (stszAtom != null) {
            dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        } else {
            dataSize.setBigIntegerValue(BigInteger.valueOf(0L));
        }
        track.setNumberOfChapters(BigInteger.valueOf(MediaDescriptionGenerator.getNumberOfChapters(mAtom)));
        SampleToTimeAtom sttsAtom = stblAtom.findChild(SampleToTimeAtom.class, new Container.Searcher.Option[0]);
        if (null == sttsAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Expecting a SampleToTimeAtom");
        }
        SampleTimeStats.addToTrack((Track)track, sttsAtom, mdhdAtom);
        track.setColocatedSamples(MediaDescriptionGenerator.hasColocatedSamples(stblAtom, (Track)track));
    }

    private static void processChapterImageTrack(ChapterImageTrack track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom) {
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        if (stszAtom != null) {
            dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        } else {
            dataSize.setBigIntegerValue(BigInteger.valueOf(0L));
        }
        track.setNumberOfChapters(BigInteger.valueOf(MediaDescriptionGenerator.getNumberOfChapters(mAtom)));
        track.setColocatedSamples(MediaDescriptionGenerator.hasColocatedSamples(stblAtom, (Track)track));
    }

    private static long getNumberOfChapters(MediaAtom mAtom) {
        long numberOfSamples = 0L;
        SampleToTimeAtom sttsAtom = mAtom.findChild(SampleToTimeAtom.class, Container.Searcher.Option.RECURSE);
        if (null != sttsAtom) {
            for (SampleToTimeAtom.TableEntry tableEntry : sttsAtom.getCountToTimeTable()) {
                numberOfSamples += tableEntry.getSampleCount();
            }
        }
        return numberOfSamples;
    }

    private static void processCaptionTrack(OnScreenDisplayTrack track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom) {
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        if (stszAtom != null) {
            dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        } else {
            dataSize.setBigIntegerValue(BigInteger.valueOf(0L));
        }
        track.setColocatedSamples(MediaDescriptionGenerator.hasColocatedSamples(stblAtom, (Track)track));
    }

    private static void processSubtitleTrack(SubtitleTrack track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom) throws QtFileCorruptException {
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        if (stszAtom != null) {
            dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        } else {
            dataSize.setBigIntegerValue(BigInteger.valueOf(0L));
        }
        SampleDescriptionsAtom stsdAtom = mAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (null == stsdAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a subtitle track without a sample descriptions atom");
        }
        List<SubtitleSampleDescription> subtitleSampleDescriptions = stsdAtom.findChildren(SubtitleSampleDescription.class, new Container.Searcher.Option[0]);
        for (SubtitleSampleDescription sbtlSD : subtitleSampleDescriptions) {
            noNamespace.SampleDescription sampleDescription = track.addNewSampleDescription();
            long dispFlags = sbtlSD.getDisplayFlags();
            sampleDescription.setDisplayFlags(SubtitleSampleDescription.toHex(dispFlags, 8));
            long ALL_MASK = 0xC0000000L;
            long SOME_MASK = 0x40000000L;
            if ((dispFlags & ALL_MASK) == ALL_MASK) {
                sampleDescription.setForcedSubtitle(ForcedSubtitle.ALL);
            } else if ((dispFlags & SOME_MASK) == SOME_MASK) {
                sampleDescription.setForcedSubtitle(ForcedSubtitle.SOME);
            } else {
                sampleDescription.setForcedSubtitle(ForcedSubtitle.NONE);
            }
            SubtitleSampleDescription.Rect rect = sbtlSD.getDefaultTextBox();
            DefaultTextBox defTB = sampleDescription.addNewDefaultTextBox();
            defTB.setTop(BigInteger.valueOf(rect.getTop()));
            defTB.setBottom(BigInteger.valueOf(rect.getBottom()));
            defTB.setLeft(BigInteger.valueOf(rect.getLeft()));
            defTB.setRight(BigInteger.valueOf(rect.getRight()));
            Justification just = sampleDescription.addNewJustification();
            just.setHorizontal(BigInteger.valueOf(sbtlSD.getHorizontalJustification()));
            just.setVertical(BigInteger.valueOf(sbtlSD.getVerticalJustification()));
            SubtitleSampleDescription.Tx3gRBGAColor bgcolor = sbtlSD.getBackgroundColor();
            sampleDescription.setBackgroundColor(bgcolor.getHexString());
            FontStyle style = sampleDescription.addNewDefaultStyle();
            style.setFontId(BigInteger.valueOf(sbtlSD.getFontID()));
            style.setFontFace(BigInteger.valueOf(sbtlSD.getFontFace()));
            style.setFontSize(BigInteger.valueOf(sbtlSD.getFontSize()));
            style.setFontColor(sbtlSD.getFontColor().getHexString());
            SubtitleSampleDescription.ftabSampleDescriptionExtension ftabSDE = sbtlSD.findSingleChildOfType(SubtitleSampleDescription.ftabSampleDescriptionExtension.class, false, false);
            if (ftabSDE == null) continue;
            Ftab ftab = sampleDescription.addNewFtab();
            List<SubtitleSampleDescription.Tx3gFontRecord> fontEntries = ftabSDE.getFontEntries();
            for (SubtitleSampleDescription.Tx3gFontRecord fontEntry : fontEntries) {
                FontEntry fe = ftab.addNewFont();
                fe.setFontId(BigInteger.valueOf(fontEntry.getFontID()));
                fe.setName(fontEntry.getName());
            }
        }
        track.setColocatedSamples(MediaDescriptionGenerator.hasColocatedSamples(stblAtom, (Track)track));
    }

    private static void processTrack(Track track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic, TrackAtom trakAtom, HandlerReferenceAtom hdlrAtom) throws QtFileCorruptException {
        TrackLoadSettingsAtom tls;
        track.setType(hdlrAtom.getSubtype());
        track.setIndex(BigInteger.valueOf(tic.index++));
        track.setTrackId(BigInteger.valueOf(tkhdAtom.getTrackId()));
        byte[] trackHeaderFlags = tkhdAtom.getFlags();
        if ((trackHeaderFlags[2] & 1) == 1) {
            track.setEnabled(true);
        } else {
            track.setEnabled(false);
        }
        List<DataReferenceAtom.DataReference> references = trakAtom.findChildrenOfType(DataReferenceAtom.DataReference.class, true);
        boolean referencesElementSet = false;
        ExternalReferences refs = null;
        for (DataReferenceAtom.DataReference dref : references) {
            if (dref.isSelfReference()) continue;
            if (!referencesElementSet) {
                refs = track.addNewReferences();
                referencesElementSet = true;
            }
            ExternalReference ref = refs.addNewReference();
            ref.setType(dref.getType());
            if (dref instanceof DataReferenceAtom.FileSystemAliasDataReference) {
                ref.setFilename(((DataReferenceAtom.FileSystemAliasDataReference)dref).getFileName());
                continue;
            }
            if (!(dref instanceof DataReferenceAtom.UrlDataReference)) continue;
            ref.setUrl(((DataReferenceAtom.UrlDataReference)dref).getUrl());
        }
        TrackReferenceAtom trefAtom = trakAtom.findChild(TrackReferenceAtom.class, new Container.Searcher.Option[0]);
        if (trefAtom != null && trefAtom.getChildren() != null && trefAtom.getChildren().size() > 0) {
            for (TrackReferenceInstanceAtom trefInstanceAtom : trefAtom.getChildren(TrackReferenceInstanceAtom.class)) {
                for (Long trackId : trefInstanceAtom.getTrackReferences()) {
                    if (trackId == 0L) continue;
                    TrackReference tr = track.addNewTrackReference();
                    tr.setType(trefInstanceAtom.getAtomType());
                    tr.setBigIntegerValue(BigInteger.valueOf(trackId));
                }
            }
        }
        noNamespace.Matrix trackMatrix = track.addNewMatrix();
        Matrix m = tkhdAtom.getMatrix();
        trackMatrix.setIdentity(m.isIdentity());
        if (!m.isIdentity()) {
            trackMatrix.setA(m.getA());
            trackMatrix.setB(m.getB());
            trackMatrix.setU(m.getU());
            trackMatrix.setC(m.getC());
            trackMatrix.setD(m.getD());
            trackMatrix.setV(m.getV());
            trackMatrix.setTx(m.getTx());
            trackMatrix.setTy(m.getTy());
            trackMatrix.setW(m.getW());
        }
        Language language = track.addNewLanguage();
        language.setStringValue(mdhdAtom.getLanguageCode());
        language.setNumeric(BigInteger.valueOf(mdhdAtom.getLanguage()));
        ExtendedLanguageAtom elngAtom = mAtom.findChild(ExtendedLanguageAtom.class, new Container.Searcher.Option[0]);
        if (elngAtom != null) {
            ExtendedLanguage extendedLanguage = track.addNewExtendedLanguage();
            extendedLanguage.setStringValue(elngAtom.getTag());
        }
        track.setAlternateGroup(BigInteger.valueOf(tkhdAtom.getAlternateGroup()));
        TrackGroupAssignmentAtom tgas = trakAtom.findChild(TrackGroupAssignmentAtom.class, new Container.Searcher.Option[0]);
        if (tgas != null) {
            track.setToAlternateGroup(BigInteger.valueOf(tgas.toAlternateGroup()));
        }
        if ((tls = trakAtom.findChild(TrackLoadSettingsAtom.class, new Container.Searcher.Option[0])) != null) {
            TrackLoadSettings preload = track.addNewPreload();
            preload.setStartTime(BigInteger.valueOf(tls.getPreloadStartTime()));
            preload.setDuration(BigInteger.valueOf(tls.getPreloadDuration()));
            preload.setFlags(tls.getPreloadFlags());
            preload.setDefaultHints(tls.getDefaultHints());
        }
        if (track instanceof OnScreenDisplayTrack) {
            OnScreenDisplayTrack osdTrack = (OnScreenDisplayTrack)track;
            Dimensions d = osdTrack.addNewTrackDimensions();
            d.setWidth(BigInteger.valueOf((long)tkhdAtom.getWidth()));
            d.setHeight(BigInteger.valueOf((long)tkhdAtom.getHeight()));
            SampleDescriptionsAtom stsdAtom = mAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
            if (null == stsdAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a track without a sample descriptions atom");
            }
            List<VideoSampleDescription> videoSampleDescriptions = stsdAtom.findChildren(VideoSampleDescription.class, new Container.Searcher.Option[0]);
            if (!videoSampleDescriptions.isEmpty()) {
                VideoSampleDescription videSD = videoSampleDescriptions.get(videoSampleDescriptions.size() - 1);
                d = osdTrack.addNewEncodedDimensions();
                d.setWidth(BigInteger.valueOf(videSD.getWidth()));
                d.setHeight(BigInteger.valueOf(videSD.getHeight()));
                List<VideoSampleDescription.paspSampleDescriptionExtension> paspSampleDescriptionExtensions = videSD.findChildrenOfType(VideoSampleDescription.paspSampleDescriptionExtension.class, false);
                VideoSampleDescription.paspSampleDescriptionExtension paspSDE = !paspSampleDescriptionExtensions.isEmpty() ? paspSampleDescriptionExtensions.get(0) : null;
                List<VideoSampleDescription.clapSampleDescriptionExtension> clapSampleDescriptionExtensions = videSD.findChildrenOfType(VideoSampleDescription.clapSampleDescriptionExtension.class, false);
                VideoSampleDescription.clapSampleDescriptionExtension clapSDE = !clapSampleDescriptionExtensions.isEmpty() ? clapSampleDescriptionExtensions.get(0) : null;
                long tmpWidth = videSD.getWidth();
                long tmpHeight = videSD.getHeight();
                if (clapSDE != null) {
                    tmpWidth = (long)((double)clapSDE.getApertureWidth_N() / (double)clapSDE.getApertureWidth_D());
                    tmpHeight = (long)((double)clapSDE.getApertureHeight_N() / (double)clapSDE.getApertureHeight_D());
                }
                if (paspSDE != null) {
                    tmpWidth = (long)((double)tmpWidth * ((double)paspSDE.getHSpacing() / (double)paspSDE.getVSpacing()));
                }
                d = osdTrack.addNewDisplayDimensions();
                d.setWidth(BigInteger.valueOf(tmpWidth));
                d.setHeight(BigInteger.valueOf(tmpHeight));
            }
        }
        int sdCount = 0;
        SampleDescriptionsAtom stsdAtom = mAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (stsdAtom != null) {
            List<SampleDescription> sampleDescriptions = stsdAtom.findChildren(SampleDescription.class, new Container.Searcher.Option[0]);
            sdCount = sampleDescriptions.size();
        }
        track.setSampleDescriptionCount(BigInteger.valueOf(sdCount));
        tic.trackAtomMap.put(track.getTrackId(), new TrackAtoms(track, tkhdAtom, mAtom, mdhdAtom, stblAtom, stszAtom, trakAtom, hdlrAtom));
        List<UserDataAtom> userDataAtoms = trakAtom.findChildren(UserDataAtom.class, new Container.Searcher.Option[0]);
        UserDataAtoms udta = track.addNewUserDataAtoms();
        for (UserDataAtom userDataAtom : userDataAtoms) {
            for (UserDataListAtom atomFromList : userDataAtom.getChildren(UserDataListAtom.class)) {
                if (atomFromList instanceof UserDataListInternationalTextContainer) {
                    for (UserDataInternationalText itAtom : ((UserDataListInternationalTextContainer)atomFromList).getInternationlTextAtomList()) {
                        UserDataAtoms.UserData u = udta.addNewUserData();
                        u.setType(atomFromList.getAtomType());
                        u.setLanguage(itAtom.getAtomType());
                        u.setStringValue(itAtom.getValue());
                    }
                    continue;
                }
                if (atomFromList instanceof UserDataTagCAtom) {
                    UserDataTagCAtom fromList = (UserDataTagCAtom)atomFromList;
                    TaggedCharacteristics characteristics = track.getTaggedCharacteristics();
                    if (characteristics == null) {
                        characteristics = track.addNewTaggedCharacteristics();
                    }
                    characteristics.addNewCharacteristic().setStringValue(fromList.getValue());
                    continue;
                }
                UserDataAtoms.UserData u = udta.addNewUserData();
                u.setType(atomFromList.getAtomType());
                u.setStringValue(atomFromList.getValue());
            }
        }
        MediaDescriptionGenerator.lookForQuicktimeMetadataAtom(trakAtom, track);
        EditListAtom editListAtom = trakAtom.new TrackAtom.Cursor().getEditListAtom();
        if (editListAtom != null) {
            EditList editList = track.addNewEditList();
            editList.addNewCount().setStringValue(Integer.toString(editListAtom.getTable().size()));
            editList.addNewEmpties().setStringValue(Integer.toString(editListAtom.numberOfEmpties()));
            editList.addNewNormalRate().setStringValue(Boolean.toString(editListAtom.isNormalRate()));
            List<EditListAtom.TableEntry> entries = editListAtom.getTable();
            if (entries != null) {
                for (EditListAtom.TableEntry atomEntry : entries) {
                    EditList.EditListEntry entry = editList.addNewEditListEntry();
                    entry.setMediaRate(atomEntry.getMediaRate());
                    entry.setMediaTime(atomEntry.getMediaTime());
                    entry.setTrackDuration(atomEntry.getTrackDuration());
                }
            }
        }
    }

    private static boolean hasColocatedSamples(SampleTableAtom stblAtom, Track track) {
        boolean colocated = true;
        long sampleNumber = 1L;
        SampleTableAtom.SampleCursor cur = stblAtom.new SampleTableAtom.SampleCursor();
        long lastPosition = -1L;
        long lastLength = -1L;
        while (cur.gotoSample(sampleNumber)) {
            long samplePosition = cur.getSamplePosition();
            long sampleLength = cur.getSampleLength();
            if (lastPosition == -1L && lastLength == -1L) {
                lastPosition = samplePosition;
                lastLength = 0L;
            }
            if (lastPosition + lastLength != samplePosition) {
                colocated = false;
                break;
            }
            lastPosition = samplePosition;
            lastLength = sampleLength;
            ++sampleNumber;
        }
        return colocated;
    }

    private static void processTimecodeTrack(QuickTimeFile file, SeekableDataInput sdi, TimecodeTrack track, TrackAtom trakAtom, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic) throws IOException {
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        if (stszAtom != null) {
            dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        } else {
            dataSize.setBigIntegerValue(BigInteger.valueOf(0L));
        }
        long timeScale = mdhdAtom.getTimeScale();
        long totalSamples = 0L;
        long weightedSamples = 0L;
        SampleToTimeAtom sttsAtom = stblAtom.findChild(SampleToTimeAtom.class, new Container.Searcher.Option[0]);
        if (sttsAtom != null) {
            for (SampleToTimeAtom.TableEntry te : sttsAtom.getCountToTimeTable()) {
                totalSamples += te.getSampleCount();
                weightedSamples += te.getSampleCount() * te.getSampleDuration();
            }
        }
        MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        DataRate dataRate = track.addNewDataRate();
        dataRate.setFloatValue(0.0f);
        dataRate.setUnits("Kb/s");
        DataReferenceAtom.DataReference dref = trakAtom.findSingleChildOfType(DataReferenceAtom.DataReference.class, true, false);
        if (dref.isSelfReference()) {
            try {
                SMPTETimeCode firstTime = MediaDescriptionGenerator.parseTimecodeValue(file, sdi, trakAtom, stblAtom, mdhdAtom);
                TimecodeInfo times = track.addNewTimes();
                times.setFormat(firstTime.getFrameRateFormatString());
                TimecodeInfo.Time time = times.addNewTime();
                time.setAt("0");
                time.setStringValue(firstTime.toSMPTEString());
                track.setColocatedSamples(MediaDescriptionGenerator.hasColocatedSamples(stblAtom, (Track)track));
            }
            catch (RuntimeException re) {
                // empty catch block
            }
        }
    }

    private static SMPTETimeCode parseTimecodeValue(QuickTimeFile file, SeekableDataInput sdi, TrackAtom trakAtom, SampleTableAtom stblAtom, MediaHeaderAtom mdhdAtom) throws IOException {
        TrackAtom.Cursor trackCursor = trakAtom.new TrackAtom.Cursor();
        EditListAtom editListAtom = trackCursor.getEditListAtom();
        long atTime = 0L;
        if (editListAtom != null && !editListAtom.getTable().isEmpty()) {
            EditListAtom.TableEntry entry = editListAtom.getTable().get(0);
            atTime += entry.getMediaTime();
        }
        SMPTETimeCode firstTime = null;
        SampleTableAtom.SampleCursor cursor = stblAtom.new SampleTableAtom.SampleCursor();
        if (cursor.nextSample()) {
            TimecodeSample firstTimeSample = new TimecodeSample();
            firstTimeSample.parseSample(file.getParser(), sdi, cursor);
            firstTime = firstTimeSample.asSMPTETimeCode(new MediaTime(atTime, mdhdAtom.getTimeScale()));
        }
        return firstTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processSoundTrack(SoundTrack track, TrackAtom trakAtom, MediaHeaderAtom mdhdAtom, MediaInformationAtom minfAtom, SampleTableAtom stblAtom, TrackIterationContext tic, TrackHeaderAtom tkhdAtom) throws QtFileCorruptException {
        long trackSizeInBytes;
        DataSize dataSize;
        SampleDescriptionsAtom stsdAtom = minfAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (null == stsdAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found sound track with no sample description atom");
        }
        List<SoundSampleDescription> sounSDs = stsdAtom.findChildren(SoundSampleDescription.class, new Container.Searcher.Option[0]);
        if (sounSDs.size() < 1) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found sound track with zero sample descriptions");
        }
        SoundSampleDescription sounSD = sounSDs.get(0);
        Codec codec = track.addNewCodec();
        esdsSampleDescriptionExtension esdsAtom = sounSD.findSingleChildOfType(esdsSampleDescriptionExtension.class, true, false);
        if (esdsAtom != null) {
            codec.setType(esdsAtom.getRFC6381CodecLabel());
            codec.setStringValue(MediaDescriptionGenerator.displayFourCCForAudioCodecFourCC(esdsAtom.getCodecFourCC()));
            codec.setName(MediaDescriptionGenerator.displayNameForAudioCodecFourCC(esdsAtom.getCodecFourCC()));
        } else {
            codec.setType(MediaDescriptionGenerator.displayRFC6381ForAudioCodecFourCC(sounSD.getDataFormat()));
            codec.setStringValue(MediaDescriptionGenerator.displayFourCCForAudioCodecFourCC(sounSD.getDataFormat()));
            codec.setName(MediaDescriptionGenerator.displayNameForAudioCodecFourCC(sounSD.getDataFormat()));
        }
        tic.codecs.add(codec.getType());
        if (sounSD.getDataFormat().equals("drms")) {
            track.setFairplayProtected(true);
            if (sounSD.containsAc3SampleDescriptionExtension()) {
                codec.setType(MediaDescriptionGenerator.displayRFC6381ForAudioCodecFourCC("ac-3"));
                codec.setStringValue(MediaDescriptionGenerator.displayFourCCForAudioCodecFourCC("ac-3"));
                codec.setName(MediaDescriptionGenerator.displayNameForAudioCodecFourCC("ac-3"));
            }
        }
        int compressionId = sounSD.getCompressionID();
        int sampleDescriptionVersion = sounSD.getVersion();
        if (compressionId == -1 || compressionId == 0) {
            if (sampleDescriptionVersion == 0) {
                track.setBitDepth(BigInteger.valueOf(sounSD.getSampleSize()));
            } else if (sampleDescriptionVersion == 1) {
                if (sounSD.getSamplesPerPacket() == 1L) {
                    track.setBitDepth(BigInteger.valueOf(sounSD.getBytesPerPacket() * 8L));
                }
            } else {
                if (sampleDescriptionVersion != 2) throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Encountered invalid audio sample description version of " + sampleDescriptionVersion + ", must be either 0 or 1");
                BigInteger tmpBD = BigInteger.valueOf(sounSD.getSampleSize());
                if (tmpBD.longValue() != 0L) {
                    track.setBitDepth(tmpBD);
                }
            }
        } else {
            if (compressionId != -2) throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Unrecognized compressionId value of " + compressionId);
            DataRateStats dataRateStats = new DataRateStats(trakAtom);
            dataRateStats.addToTrack((DataContentTrack)track);
        }
        SampleSizeAtom stszAtom = stblAtom.findChild(SampleSizeAtom.class, new Container.Searcher.Option[0]);
        if (null == stszAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found sound track with no sample size atom");
        }
        if (stszAtom.getGlobalSampleSize() == 1L && sampleDescriptionVersion == 1) {
            dataSize = track.addNewDataSize();
            dataSize.setUnits("bytes");
            trackSizeInBytes = "fl32".equals(sounSD.getDataFormat()) ? stszAtom.getSampleSizeSum() * sounSD.getBytesPerSample() * (long)sounSD.getNumOfChannels() : stszAtom.getSampleSizeSum() * sounSD.getBytesPerFrame();
            dataSize.setBigIntegerValue(BigInteger.valueOf(trackSizeInBytes));
        } else {
            dataSize = track.addNewDataSize();
            dataSize.setUnits("bytes");
            trackSizeInBytes = stszAtom.getSampleSizeSum();
            dataSize.setBigIntegerValue(BigInteger.valueOf(trackSizeInBytes));
        }
        SampleRate sampleRate = track.addNewSampleRate();
        sampleRate.setUnits("kilohertz");
        if (esdsAtom != null && esdsAtom.isSbrAacLc()) {
            sampleRate.setFloatValue((float)esdsAtom.getFrequency().intValue() / 1000.0f);
        } else {
            sampleRate.setFloatValue(sounSD.getSampleRate() / 1000.0f);
        }
        SampleToTimeAtom sttsAtom = stblAtom.findChild(SampleToTimeAtom.class, new Container.Searcher.Option[0]);
        if (null == sttsAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found sound track with no Sample-To-Time atom");
        }
        long trackDurationInSamples = 0L;
        for (SampleToTimeAtom.TableEntry te : sttsAtom.getCountToTimeTable()) {
            trackDurationInSamples = te.getSampleCount() * te.getSampleDuration();
        }
        double durationMillis = MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        float dataRateInKilobitsPerSecond = 0.0f;
        if (durationMillis > 0.0) {
            dataRateInKilobitsPerSecond = (float)((double)trackSizeInBytes / 1024.0 * 8.0 / (durationMillis / 1000.0));
        }
        DataRate dataRate = track.addNewDataRate();
        dataRate.setUnits("Kb/s");
        dataRate.setFloatValue(dataRateInKilobitsPerSecond);
        udc2SampleDescriptionExtension udc2Atom = sounSD.findSingleChildOfType(udc2SampleDescriptionExtension.class, true, false);
        track.setUdc2(udc2Atom != null);
        udi2SampleDescriptionExtension udi2Atom = sounSD.findSingleChildOfType(udi2SampleDescriptionExtension.class, true, false);
        track.setUdi2(udi2Atom != null);
        dmixSampleDescriptionExtension dmixAtom = sounSD.findSingleChildOfType(dmixSampleDescriptionExtension.class, true, false);
        if (dmixAtom != null) {
            DmixDrc dmixDrc = track.addNewDmixDrc();
            dmixDrc.setInstructionCount(BigInteger.valueOf(dmixAtom.getInstructionCount()));
            dmixDrc.setVersion(BigInteger.valueOf(dmixAtom.getVersion()));
        }
        MediaDescriptionGenerator.processChannelLayoutForSoundSampleDescription(track, sounSD);
    }

    private static void processChannelLayoutForSoundSampleDescription(SoundTrack track, SoundSampleDescription sounSD) throws QtFileCorruptException {
        ChannelLayout channelLayout = track.addNewChannelLayout();
        chanSampleDescriptionExtension chanSDE = sounSD.findSingleChildOfType(chanSampleDescriptionExtension.class, false, false);
        if (sounSD.getDataFormat().equals("ac-3") || sounSD.getDataFormat().equals("drms") && sounSD.containsAc3SampleDescriptionExtension()) {
            dac3SampleDescriptionExtension dac3SDE = sounSD.findSingleChildOfType(dac3SampleDescriptionExtension.class, false, false);
            if (dac3SDE != null) {
                dac3SampleDescriptionExtension.AudioCodingMode acmod = dac3SDE.getAudioCodingMode();
                for (dac3SampleDescriptionExtension.Channel ac3Channel : acmod.getChannels()) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName(ac3Channel.getPrettyName());
                    channel.setStringValue(ac3Channel.getQuickTimeishName());
                }
                if (dac3SDE.isLfe()) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName("LFE Screen");
                    channel.setStringValue("LFE");
                }
                List channelQTNames = Lists.transform(Arrays.asList(channelLayout.getChannelArray()), (Function)new Function<Channel, String>(){

                    public String apply(Channel channel) {
                        return channel.getStringValue();
                    }
                });
                channelLayout.setName(dac3SampleDescriptionExtension.AudioCodingMode.getQuickTimeishRepresentation(channelQTNames, dac3SDE.isLfe()));
                return;
            }
            lager.warn((Object)"Found an AC3 track with no dac3 sample description extension.  This is probably bad.");
        }
        if (sounSD.getDataFormat().equals("ec-3") || sounSD.getDataFormat().equals("drms") && sounSD.containsEc3SampleDescriptionExtension()) {
            dec3SampleDescriptionExtension dec3SDE = sounSD.findSingleChildOfType(dec3SampleDescriptionExtension.class, false, false);
            if (dec3SDE != null) {
                dac3SampleDescriptionExtension.AudioCodingMode acmod = dec3SDE.getAudioCodingMode();
                for (dac3SampleDescriptionExtension.Channel ec3Channel : acmod.getChannels()) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName(ec3Channel.getPrettyName());
                    channel.setStringValue(ec3Channel.getQuickTimeishName());
                }
                if (null != dec3SDE.getDependentChannels()) {
                    for (dac3SampleDescriptionExtension.Channel ec3Channel : dec3SDE.getDependentChannels()) {
                        Channel channel = channelLayout.addNewChannel();
                        channel.setName(ec3Channel.getPrettyName());
                        channel.setStringValue(ec3Channel.getQuickTimeishName());
                    }
                }
                if (dec3SDE.isLfe()) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName("LFE Screen");
                    channel.setStringValue("LFE");
                }
                List channelQTNames = Lists.transform(Arrays.asList(channelLayout.getChannelArray()), (Function)new Function<Channel, String>(){

                    public String apply(Channel channel) {
                        return channel.getStringValue();
                    }
                });
                channelLayout.setName(dac3SampleDescriptionExtension.AudioCodingMode.getQuickTimeishRepresentation(channelQTNames, dec3SDE.isLfe()));
                return;
            }
            lager.warn((Object)"Found an EC3 track with no dec3 sample description extension.  This is probably bad.");
        }
        if (chanSDE == null) {
            esdsSampleDescriptionExtension esdsAtom = sounSD.findSingleChildOfType(esdsSampleDescriptionExtension.class, false, false);
            if (esdsAtom != null) {
                MediaDescriptionGenerator.setupWellKnownChannelLayout(channelLayout, esdsAtom.getChannelLayout());
            } else if (sounSD.getNumOfChannels() == 1) {
                MediaDescriptionGenerator.setupWellKnownChannelLayout(channelLayout, 6553601L);
            } else if (sounSD.getNumOfChannels() == 2) {
                MediaDescriptionGenerator.setupWellKnownChannelLayout(channelLayout, 6619138L);
            } else {
                channelLayout.setName(sounSD.getNumOfChannels() + " Channels");
                for (int i = 0; i < sounSD.getNumOfChannels(); ++i) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName("Mono");
                    channel.setStringValue("Mono");
                }
            }
        } else {
            long audioChannelLayoutTag = chanSDE.getAudioChannelLayoutTag();
            if (audioChannelLayoutTag == 0L) {
                channelLayout.setName("User-defined (enumerated list)");
                List<chanSampleDescriptionExtension.AudioChannelDescription> channelDescriptions = chanSDE.getChannelDescriptions();
                if (channelDescriptions.size() != sounSD.getNumOfChannels()) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "There are " + channelDescriptions.size() + " channels listed in channel descriptions array but sample description claims to contain " + sounSD.getNumOfChannels() + " channels for " + chanSDE);
                }
                for (chanSampleDescriptionExtension.AudioChannelDescription acd : channelDescriptions) {
                    CoreAudioTypes.ChannelLabel channelLabel = CoreAudioTypes.longToChannelLabel.get(acd.getAudioChannelLabel());
                    Channel channel = channelLayout.addNewChannel();
                    if (channelLabel != null) {
                        channel.setName(channelLabel.getLongLabel());
                        channel.setStringValue(channelLabel.getShortLabel());
                        continue;
                    }
                    channel.setStringValue("" + acd.getAudioChannelLabel());
                    channel.setName("Undefined channel ID #" + acd.getAudioChannelLabel());
                }
            } else if (audioChannelLayoutTag == 65536L) {
                channelLayout.setName("User-defined (bitmap)");
                int numChannelsInBitmap = 0;
                for (CoreAudioTypes.ChannelBitmaskToLabel bitmap : CoreAudioTypes.bitMaskToChannelLabel) {
                    if ((chanSDE.getChannelBitmap() & bitmap.getMask()) != bitmap.getMask()) continue;
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName(bitmap.getChannelLabel().getLongLabel());
                    channel.setStringValue(bitmap.getChannelLabel().getShortLabel());
                    ++numChannelsInBitmap;
                }
                if (numChannelsInBitmap != sounSD.getNumOfChannels()) {
                    throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "There are " + numChannelsInBitmap + " channels listed in channel bitmap but sample description claims to contain " + sounSD.getNumOfChannels() + " channels.");
                }
            } else if (audioChannelLayoutTag == (0x930000L | (long)sounSD.getNumOfChannels())) {
                channelLayout.setName("Discrete in order");
                for (int i = 0; i < sounSD.getNumOfChannels(); ++i) {
                    Channel channel = channelLayout.addNewChannel();
                    channel.setName("Discrete-" + i);
                    channel.setStringValue("Discrete-" + i);
                }
            } else if (CoreAudioTypes.longToChannelLayout.containsKey(audioChannelLayoutTag)) {
                MediaDescriptionGenerator.setupWellKnownChannelLayout(channelLayout, audioChannelLayoutTag);
            }
        }
    }

    private static void setupWellKnownChannelLayout(ChannelLayout channelLayout, Long audioChannelLayoutTag) {
        CoreAudioTypes.ChannelLayout caChannelLayout = CoreAudioTypes.longToChannelLayout.get(audioChannelLayoutTag);
        channelLayout.setName(caChannelLayout.getName());
        for (CoreAudioTypes.ChannelLabel channelLabel : caChannelLayout.getChannels()) {
            Channel channel = channelLayout.addNewChannel();
            channel.setName(channelLabel.getLongLabel());
            channel.setStringValue(channelLabel.getShortLabel());
        }
    }

    private static void processVideoTrack(LeghornValidationContext ctx, VideoTrack track, TrackAtom trakAtom, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackIterationContext tic) throws QtFileCorruptException {
        VideoSampleDescription.clliSampleDescriptionExtension clliDE;
        VideoSampleDescription.mdcvSampleDescriptionExtension mdcvDE;
        AvccSampleDescriptionExtension avcCSDE;
        DataSize dataSize = track.addNewDataSize();
        dataSize.setUnits("bytes");
        dataSize.setBigIntegerValue(BigInteger.valueOf(stszAtom.getSampleSizeSum()));
        Dimensions d = track.addNewTrackDimensions();
        d.setWidth(BigInteger.valueOf((long)tkhdAtom.getWidth()));
        d.setHeight(BigInteger.valueOf((long)tkhdAtom.getHeight()));
        SampleDescriptionsAtom stsdAtom = mAtom.findChild(SampleDescriptionsAtom.class, Container.Searcher.Option.RECURSE);
        if (null == stsdAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a video track without a sample descriptions atom");
        }
        List<VideoSampleDescription> videoSampleDescriptions = stsdAtom.findChildren(VideoSampleDescription.class, Container.Searcher.Option.RECURSE);
        if (videoSampleDescriptions.size() < 1) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found video track with zero video sample descriptions");
        }
        VideoSampleDescription videSD = videoSampleDescriptions.get(videoSampleDescriptions.size() - 1);
        d = track.addNewEncodedDimensions();
        d.setWidth(BigInteger.valueOf(videSD.getWidth()));
        d.setHeight(BigInteger.valueOf(videSD.getHeight()));
        long timeScale = mdhdAtom.getTimeScale();
        BigDecimal timeScaleBd = BigDecimal.valueOf(timeScale, 3);
        SampleToTimeAtom sttsAtom = stblAtom.findChild(SampleToTimeAtom.class, new Container.Searcher.Option[0]);
        if (null == sttsAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a video track without a Sample-to-Time atom");
        }
        long totalSamples = 0L;
        long weightedSamples = 0L;
        BigDecimal minFrameRate = null;
        BigDecimal maxFrameRate = null;
        for (SampleToTimeAtom.TableEntry te : sttsAtom.getCountToTimeTable()) {
            totalSamples += te.getSampleCount();
            weightedSamples += te.getSampleCount() * te.getSampleDuration();
            if (te.getSampleDuration() <= 0L) continue;
            BigDecimal instFrameRate = timeScaleBd.divide(BigDecimal.valueOf(te.getSampleDuration(), 3), 4);
            if (null == minFrameRate || minFrameRate.compareTo(instFrameRate) > 0) {
                minFrameRate = instFrameRate;
            }
            if (null != maxFrameRate && maxFrameRate.compareTo(instFrameRate) >= 0) continue;
            maxFrameRate = instFrameRate;
        }
        if (totalSamples > 0L && weightedSamples > 0L) {
            double frameRate = (double)timeScale / ((double)weightedSamples / (double)totalSamples);
            track.setFrameRate((float)frameRate);
        } else {
            ctx.addCheckAlert(MediaValidationCode.VIDEO_FRAMERATE_INVALID, MediaUtil.dictionary.add("weightedSamples", Double.toString(weightedSamples)).add("totalSamples", Long.toString(totalSamples)));
        }
        if (!maxFrameRate.equals(minFrameRate)) {
            track.setMinFrameRate(minFrameRate.floatValue());
            track.setMaxFrameRate(maxFrameRate.floatValue());
            track.setFrameRateMode(FrameRateMode.VFR);
        } else {
            track.setFrameRateMode(FrameRateMode.CFR);
        }
        SampleTimeStats.addToTrack((Track)track, sttsAtom, mdhdAtom);
        DataRateStats dataRateStats = new DataRateStats(trakAtom);
        dataRateStats.addToTrack((DataContentTrack)track);
        double durationMillis = MediaDescriptionGenerator.addTrackDuration((Track)track, tkhdAtom, tic);
        float dataRateInKilobitsPerSecond = 0.0f;
        if (durationMillis > 0.0) {
            dataRateInKilobitsPerSecond = 1000.0f * ((float)stszAtom.getSampleSizeSum() / (float)durationMillis) * 8.0f / 1024.0f;
        }
        DataRate dataRate = track.addNewDataRate();
        dataRate.setUnits("Kb/s");
        dataRate.setFloatValue(dataRateInKilobitsPerSecond);
        MediaInformationAtom minfAtom = mAtom.findChild(MediaInformationAtom.class, new Container.Searcher.Option[0]);
        if (null == minfAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a video track without a media information atom");
        }
        VideoMediaHeaderAtom vmhdAtom = minfAtom.findChild(VideoMediaHeaderAtom.class, new Container.Searcher.Option[0]);
        if (null == vmhdAtom) {
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found a video track without a video media head atom");
        }
        track.setGraphicsMode(GraphicsModeHelper.toXMLEnum(vmhdAtom.getGraphicsMode()));
        Codec codec = track.addNewCodec();
        codec.setStringValue(videSD.getDataFormat());
        codec.setName(MediaDescriptionGenerator.displayNameForVideoCodecFourCC(videSD.getDataFormat()));
        codec.setType(videSD.getDataFormat());
        noNamespace.SampleDescription sampleDescription = track.addNewSampleDescription();
        List<VideoSampleDescription.colrSampleDescriptionExtension> colrs = videSD.findChildrenOfType(VideoSampleDescription.colrSampleDescriptionExtension.class, false);
        VideoSampleDescription.colrSampleDescriptionExtension colrSDE = null;
        if (!colrs.isEmpty()) {
            colrSDE = colrs.get(0);
            Colr colr = sampleDescription.addNewColr();
            colr.setColorParameterType(colrSDE.getColorParameterType());
            colr.setMatrixIndex(colrSDE.getMatrixIndex());
            colr.setPrimariesIndex(colrSDE.getPrimariesIndex());
            colr.setTransferFunctionIndex(colrSDE.getTransferFunctionIndex());
            for (VideoSampleDescription.colrSampleDescriptionExtension c : colrs) {
                if (c.equals(colrSDE)) continue;
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found " + colrs.size() + " inconsistent instances of type " + VideoSampleDescription.colrSampleDescriptionExtension.class);
            }
        }
        List<VideoSampleDescription.fielSampleDescriptionExtension> fiels = videSD.findChildrenOfType(VideoSampleDescription.fielSampleDescriptionExtension.class, false);
        VideoSampleDescription.fielSampleDescriptionExtension fielSDE = null;
        if (!fiels.isEmpty()) {
            fielSDE = fiels.get(0);
            int fieldCount = fielSDE.getFieldCount();
            int fieldOrdering = fielSDE.getFieldOrdering();
            if (fieldCount == 1) {
                track.setFieldDominance(FieldDominance.PROGRESSIVE);
            } else if (fieldCount == 2) {
                track.setFieldDominance(FieldDominance.INTERLACED);
            } else {
                track.setFieldDominance(FieldDominance.UNKNOWN);
            }
            Fiel fiel = sampleDescription.addNewFiel();
            fiel.setFieldCount(fielSDE.getFieldCount());
            fiel.setFieldOrdering(fielSDE.getFieldOrdering());
            for (VideoSampleDescription.fielSampleDescriptionExtension f : fiels) {
                if (f.equals(fielSDE)) continue;
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found " + fiels.size() + " inconsistent instances of type " + VideoSampleDescription.fielSampleDescriptionExtension.class);
            }
        } else {
            track.setFieldDominance(FieldDominance.PROGRESSIVE);
        }
        List<VideoSampleDescription.paspSampleDescriptionExtension> pasps = videSD.findChildrenOfType(VideoSampleDescription.paspSampleDescriptionExtension.class, false);
        VideoSampleDescription.paspSampleDescriptionExtension paspSDE = null;
        if (!pasps.isEmpty()) {
            paspSDE = pasps.get(0);
            Pasp pasp = sampleDescription.addNewPasp();
            pasp.setHorizontalSpacing(BigInteger.valueOf(paspSDE.getHSpacing()));
            pasp.setVerticalSpacing(BigInteger.valueOf(paspSDE.getVSpacing()));
            for (VideoSampleDescription.paspSampleDescriptionExtension p : pasps) {
                if (p.equals(paspSDE)) continue;
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found " + pasps.size() + " inconsistent instances of type " + VideoSampleDescription.paspSampleDescriptionExtension.class);
            }
        }
        List<VideoSampleDescription.clapSampleDescriptionExtension> claps = videSD.findChildrenOfType(VideoSampleDescription.clapSampleDescriptionExtension.class, false);
        VideoSampleDescription.clapSampleDescriptionExtension clapSDE = null;
        if (!claps.isEmpty()) {
            clapSDE = claps.get(0);
            Clap clap = sampleDescription.addNewClap();
            clap.setAperatureWidth((float)clapSDE.getApertureWidth_N() / (float)clapSDE.getApertureWidth_D());
            clap.setAperatureHeight((float)clapSDE.getApertureHeight_N() / (float)clapSDE.getApertureHeight_D());
            clap.setVerticalOffset((float)clapSDE.getVertOff_N() / (float)clapSDE.getVertOff_D());
            clap.setHorizontalOffset((float)clapSDE.getHorizOff_N() / (float)clapSDE.getHorizOff_D());
            for (VideoSampleDescription.clapSampleDescriptionExtension c : claps) {
                if (c.equals(clapSDE)) continue;
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found " + claps.size() + " inconsistent instances of type " + VideoSampleDescription.clapSampleDescriptionExtension.class);
            }
        }
        List<VideoSampleDescription.gamaSampleDescriptionExtension> gamas = videSD.findChildrenOfType(VideoSampleDescription.gamaSampleDescriptionExtension.class, false);
        VideoSampleDescription.gamaSampleDescriptionExtension gamaSDE = null;
        if (!gamas.isEmpty()) {
            gamaSDE = gamas.get(0);
            sampleDescription.setGama(gamaSDE.getGama());
            for (VideoSampleDescription.gamaSampleDescriptionExtension g : gamas) {
                if (g.equals(gamaSDE)) continue;
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Found " + gamas.size() + " inconsistent instances of type " + VideoSampleDescription.gamaSampleDescriptionExtension.class);
            }
        }
        if ((avcCSDE = videSD.findSingleChildOfType(AvccSampleDescriptionExtension.class, false, false)) != null) {
            AvcC avcC = sampleDescription.addNewAvcC();
            switch (avcCSDE.getProfile()) {
                case 66: {
                    avcC.setProfile(AvcC.Profile.BASELINE);
                    break;
                }
                case 77: {
                    avcC.setProfile(AvcC.Profile.MAIN);
                    break;
                }
                case 88: {
                    avcC.setProfile(AvcC.Profile.EXTENDED);
                    break;
                }
                case 100: {
                    avcC.setProfile(AvcC.Profile.HIGH);
                    break;
                }
                default: {
                    avcC.setProfile(AvcC.Profile.UNKNOWN);
                }
            }
            avcC.setCompatability(BigInteger.valueOf(avcCSDE.getCompatability()));
            avcC.setLevel(avcCSDE.getLevel());
            NalUnits nalUnits = avcC.addNewNalUnits();
            PictureParameterSets pictureParameterSets = nalUnits.addNewPictureParameterSets();
            List<PictureParameterSet> ppsList = avcCSDE.getPPSList();
            for (PictureParameterSet pps : ppsList) {
                PicParameterSet picParameterSet = pictureParameterSets.addNewPicParameterSet();
                picParameterSet.setEntropyCodingModeFlag(pps.entropyCodingMode() ? 1 : 0);
                picParameterSet.setPicParameterSetId(pps.pspId());
                picParameterSet.setSeqParameterSetId(pps.spsId());
            }
            avcC.setRawAvcc(avcCSDE.getRawAVCC());
            Set<String> codecLabels = avcCSDE.getSPSCodecLabelList();
            tic.codecs.addAll(codecLabels);
            StringBuilder codecStringBuilder = new StringBuilder();
            for (String label : codecLabels) {
                codecStringBuilder.append(label).append(", ");
            }
            if (codecStringBuilder.length() > 2) {
                codecStringBuilder.setLength(codecStringBuilder.length() - 2);
            }
            codec.setType(codecStringBuilder.toString());
        } else {
            tic.codecs.add(videSD.getDataFormat());
        }
        VideoSampleDescription.uuidSampleDescriptionExtension uuidSDE = videSD.findSingleChildOfType(VideoSampleDescription.uuidSampleDescriptionExtension.class, false, false);
        if (uuidSDE != null) {
            sampleDescription.setUuid(uuidSDE.getUUIDAsHex());
        }
        if ((mdcvDE = videSD.findSingleChildOfType(VideoSampleDescription.mdcvSampleDescriptionExtension.class, false, false)) != null) {
            Mdcv mdcv = sampleDescription.addNewMdcv();
            ColorPrimary red = mdcv.addNewRed();
            red.setX(BigInteger.valueOf(mdcvDE.getRedPrimaryX()));
            red.setY(BigInteger.valueOf(mdcvDE.getRedPrimaryY()));
            ColorPrimary green = mdcv.addNewGreen();
            green.setX(BigInteger.valueOf(mdcvDE.getGreenPrimaryX()));
            green.setY(BigInteger.valueOf(mdcvDE.getGreenPrimaryY()));
            ColorPrimary blue = mdcv.addNewBlue();
            blue.setX(BigInteger.valueOf(mdcvDE.getBluePrimaryX()));
            blue.setY(BigInteger.valueOf(mdcvDE.getBluePrimaryY()));
            ColorPrimary whitePoint = mdcv.addNewWhitePoint();
            whitePoint.setX(BigInteger.valueOf(mdcvDE.getWhitePointX()));
            whitePoint.setY(BigInteger.valueOf(mdcvDE.getWhitePointY()));
            mdcv.setMaxDisplayLuminance(BigInteger.valueOf(mdcvDE.getMaxMasteringDisplayLuminance()));
            mdcv.setMinDisplayLuminance(BigInteger.valueOf(mdcvDE.getMinMasteringDisplayLuminance()));
        }
        if ((clliDE = videSD.findSingleChildOfType(VideoSampleDescription.clliSampleDescriptionExtension.class, false, false)) != null) {
            Clli clli = sampleDescription.addNewClli();
            clli.setMaxContentLightLevel(BigInteger.valueOf(clliDE.getMaxContentLightLevel()));
            clli.setMaxFrameAverageLightLevel(BigInteger.valueOf(clliDE.getMaxFrameAverageLightLevel()));
        }
        long tmpWidth = videSD.getWidth();
        long tmpHeight = videSD.getHeight();
        if (clapSDE != null) {
            tmpWidth = (long)((double)clapSDE.getApertureWidth_N() / (double)clapSDE.getApertureWidth_D());
            tmpHeight = (long)((double)clapSDE.getApertureHeight_N() / (double)clapSDE.getApertureHeight_D());
        }
        if (paspSDE != null) {
            tmpWidth = (long)((double)tmpWidth * ((double)paspSDE.getHSpacing() / (double)paspSDE.getVSpacing()));
        }
        d = track.addNewDisplayDimensions();
        d.setWidth(BigInteger.valueOf(tmpWidth));
        d.setHeight(BigInteger.valueOf(tmpHeight));
        track.setMaximumSampleSize(stszAtom.getMaxiumumSampleSize());
    }

    private static void recurseLookingForTracks(LeghornValidationContext ctx, QuickTimeFile file, SeekableDataInput sdi, List<?> atoms, TrackIterationContext tic) throws IOException, QtFileCorruptException {
        if (atoms == null || atoms.size() == 0) {
            return;
        }
        for (Object o : atoms) {
            if (!(o instanceof Atom)) continue;
            MediaDescriptionGenerator.recurseLookingForTracks(ctx, file, sdi, (Atom)o, tic);
        }
    }

    private static String displayNameForVideoCodecFourCC(String fourCC) {
        if (videoCodecDisplayNames.containsKey(fourCC)) {
            return videoCodecDisplayNames.get(fourCC);
        }
        return fourCC;
    }

    private static String displayNameForAudioCodecFourCC(String fourCC) {
        if (audioCodecDisplayNames.containsKey(fourCC)) {
            return audioCodecDisplayNames.get(fourCC);
        }
        return fourCC;
    }

    private static String displayFourCCForAudioCodecFourCC(String fourCC) {
        if (audioFourCCDisplayNames.containsKey(fourCC)) {
            return audioFourCCDisplayNames.get(fourCC);
        }
        return fourCC;
    }

    private static String displayRFC6381ForAudioCodecFourCC(String fourCC) {
        if (audioFourCCRFC6381Names.containsKey(fourCC)) {
            return audioFourCCRFC6381Names.get(fourCC);
        }
        return fourCC;
    }

    private static float currentVersion() {
        return Float.parseFloat(Configuration.getVersion());
    }

    private static double addTrackDuration(Track track, TrackHeaderAtom tkhdAtom, TrackIterationContext tic) {
        double durationMillis = 1000.0 * (double)tkhdAtom.getDuration() / (double)tic.movieHeaderAtom.getTimeScale();
        Duration duration = track.addNewDuration();
        duration.setUnits("milliseconds");
        duration.setStringValue(String.valueOf(Math.round(durationMillis)));
        duration.setTrackDuration(tkhdAtom.getDuration());
        duration.setMilliseconds(Math.round(durationMillis));
        return durationMillis;
    }

    static {
        audioCodecDisplayNames = new HashMap<String, String>();
        videoCodecDisplayNames = new HashMap<String, String>();
        audioFourCCDisplayNames = new HashMap<String, String>();
        audioFourCCRFC6381Names = new HashMap<String, String>();
        audioCodecDisplayNames.put("\u0000\u0000\u0000\u0000", "Uncompressed or Two's Complement (Big Endian)");
        audioFourCCDisplayNames.put("\u0000\u0000\u0000\u0000", "");
        audioCodecDisplayNames.put("NONE", "Uncompressed or Two's Complement (Big Endian)");
        audioCodecDisplayNames.put("raw", "Uncompressed 8-bit offset binary");
        audioCodecDisplayNames.put("twos", "Uncompressed Twos complement PCM (big endian)");
        audioCodecDisplayNames.put("swot", "Uncompressed Twos complement PCM (little endian)");
        audioCodecDisplayNames.put("MAC3", "MACE 3:1");
        audioCodecDisplayNames.put("MAC6", "MACE 6:1");
        audioCodecDisplayNames.put("ima4", "IMA 4:1");
        audioCodecDisplayNames.put("fl32", "32-bit floating point uncompressed PCM");
        audioCodecDisplayNames.put("fl64", "64-bit floating point uncompressed PCM");
        audioCodecDisplayNames.put("in24", "24-bit integer uncompressed PCM");
        audioCodecDisplayNames.put("in32", "32-bit integer uncompressed PCM");
        audioCodecDisplayNames.put("ulaw", "uLaw 2:1");
        audioCodecDisplayNames.put(String.valueOf(new char[]{'m', 's', '\u0000', '\u0002'}), "Microsoft ADPCM-ACM code 2");
        audioFourCCDisplayNames.put(String.valueOf(new char[]{'m', 's', '\u0000', '\u0002'}), "0x6D730002");
        audioCodecDisplayNames.put(String.valueOf(new char[]{'m', 's', '\u0000', '\u0011'}), "DVI/Intel IMAADPCM-ACM code 17");
        audioFourCCDisplayNames.put(String.valueOf(new char[]{'m', 's', '\u0000', '\u0011'}), "0x6D730011");
        audioCodecDisplayNames.put("alaw", "uLaw 2:1");
        audioCodecDisplayNames.put("dvca", "DV Audio");
        audioCodecDisplayNames.put("QDMC", "QDesign music");
        audioCodecDisplayNames.put("QDM2", "QDesign music (version 2)");
        audioCodecDisplayNames.put("Qclp", "QUALCOMM PureVoice");
        audioCodecDisplayNames.put(String.valueOf(new char[]{'m', 's', '\u0000', 'U'}), "MPEG-1 layer 3, CBR only (pre-QT4.1)");
        audioCodecDisplayNames.put(".mp3", "MPEG-1 layer 3, CBR & VBR (QT4.1 and later)");
        audioCodecDisplayNames.put("mp4a", "MPEG-4 audio");
        audioCodecDisplayNames.put("lpcm", "Uncompressed PCM");
        audioFourCCRFC6381Names.put("ac-3", "mp4a.A5");
        audioFourCCRFC6381Names.put("ec-3", "mp4a.A6");
        videoCodecDisplayNames.put("cvid", "Cinepak");
        videoCodecDisplayNames.put("jpeg", "JPEG");
        videoCodecDisplayNames.put("smc ", "Graphics");
        videoCodecDisplayNames.put("rle ", "Animation");
        videoCodecDisplayNames.put("rpza", "Apple video");
        videoCodecDisplayNames.put("kpcd", "Kodak Photo CD");
        videoCodecDisplayNames.put("png ", "Portable Network Graphics");
        videoCodecDisplayNames.put("mjpa", "Motion-JPEG (format A)");
        videoCodecDisplayNames.put("mjpb", "Motion-JPEG (format B)");
        videoCodecDisplayNames.put("SVQ1", "Sorenson video, version 1");
        videoCodecDisplayNames.put("SVQ3", "Sorenson video 3");
        videoCodecDisplayNames.put("mp4v", "MPEG-4 video");
        videoCodecDisplayNames.put("dvc ", "NTSC DV-25 video");
        videoCodecDisplayNames.put("dvcp", "PAL DV-25 video");
        videoCodecDisplayNames.put("gif ", "Compuserve Graphic Interchange Format");
        videoCodecDisplayNames.put("h263", "H.263 video");
        videoCodecDisplayNames.put("tiff", "Tagged Image File Format");
        videoCodecDisplayNames.put("raw ", "Uncompressed RGB");
        videoCodecDisplayNames.put("2vuY", "Uncompressed Y'CbCr, 8-bit-per-component 4:2:2");
        videoCodecDisplayNames.put("yuv2", "Uncompressed Y'CbCr, 8-bit-per-component 4:2:2");
        videoCodecDisplayNames.put("v308", "Uncompressed Y'CbCr, 8-bit-per-component 4:4:4");
        videoCodecDisplayNames.put("v408", "Uncompressed Y'CbCr, 8-bit-per-component 4:4:4:4");
        videoCodecDisplayNames.put("v216", "Uncompressed Y'CbCr, 10, 12, 14, or 16-bit-per-component 4:2:2");
        videoCodecDisplayNames.put("v410", "Uncompressed Y'CbCr, 10-bit-per-component 4:4:4");
        videoCodecDisplayNames.put("v210", "Uncompressed Y'CbCr, 10-bit-per-component 4:2:2");
        videoCodecDisplayNames.put("avc1", "H.264");
        videoCodecDisplayNames.put("apch", "Apple ProRes 422 HQ");
        videoCodecDisplayNames.put("ap4h", "Apple ProRes 4444");
        videoCodecDisplayNames.put("ap4x", "Apple ProRes 4444 XQ");
    }

    public static class TrackAtoms {
        public Track track;
        public TrackHeaderAtom tkhdAtom;
        public MediaAtom mAtom;
        public MediaHeaderAtom mdhdAtom;
        public SampleTableAtom stblAtom;
        public SampleSizeAtom stszAtom;
        public TrackAtom trakAtom;
        public HandlerReferenceAtom hdlrAtom;

        public TrackAtoms(Track track, TrackHeaderAtom tkhdAtom, MediaAtom mAtom, MediaHeaderAtom mdhdAtom, SampleTableAtom stblAtom, SampleSizeAtom stszAtom, TrackAtom trakAtom, HandlerReferenceAtom hdlrAtom) {
            this.track = track;
            this.tkhdAtom = tkhdAtom;
            this.mAtom = mAtom;
            this.mdhdAtom = mdhdAtom;
            this.stblAtom = stblAtom;
            this.stszAtom = stszAtom;
            this.trakAtom = trakAtom;
            this.hdlrAtom = hdlrAtom;
        }
    }

    private static class TrackIterationContext {
        Set<Long> knownChaptersTracks = new HashSet<Long>();
        Set<String> codecs = new HashSet<String>();
        long index = 0L;
        MovieDocument.Movie.Tracks tracks;
        QuickTimeFile qtFile;
        MovieAtom movieAtom;
        MovieHeaderAtom movieHeaderAtom;
        Map<BigInteger, TrackAtoms> trackAtomMap = new HashMap<BigInteger, TrackAtoms>();

        public TrackIterationContext(MovieDocument.Movie.Tracks tracks, QuickTimeFile qtFile, MovieAtom movieAtom) throws QtFileCorruptException {
            this.tracks = tracks;
            this.qtFile = qtFile;
            this.movieAtom = movieAtom;
            this.movieHeaderAtom = movieAtom.findChild(MovieHeaderAtom.class, new Container.Searcher.Option[0]);
            if (null == this.movieHeaderAtom) {
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Cannot locale a movie header atom");
            }
        }
    }
}

