/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class Matrix {
    private double a;
    private double b;
    private double u;
    private double c;
    private double d;
    private double v;
    private double tx;
    private double ty;
    private double w;

    public Matrix(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        this.a = BitstreamReader.readFixed32(movieFile);
        this.b = BitstreamReader.readFixed32(movieFile);
        this.u = Matrix.readFixed2L30R(quickTimeParser, movieFile);
        this.c = BitstreamReader.readFixed32(movieFile);
        this.d = BitstreamReader.readFixed32(movieFile);
        this.v = Matrix.readFixed2L30R(quickTimeParser, movieFile);
        this.tx = BitstreamReader.readFixed32(movieFile);
        this.ty = BitstreamReader.readFixed32(movieFile);
        this.w = Matrix.readFixed2L30R(quickTimeParser, movieFile);
    }

    public static double readFixed2L30R(BaseParser quickTimeParser, SeekableDataInput movieFile) throws IOException {
        byte[] bytes = new byte[4];
        movieFile.readFully(bytes);
        int left = bytes[0] & 0xC0;
        if (((left >>= 6) & 2) == 2) {
            left = -2 + (left & 1);
        }
        int right = bytes[0] & 0x3F;
        right <<= 8;
        right += bytes[1] & 0xFF;
        right <<= 8;
        right += bytes[2] & 0xFF;
        right <<= 8;
        return (double)left + (double)(right += bytes[3] & 0xFF) / 1.073741824E9;
    }

    public boolean isIdentity() {
        return this.a == 1.0 && this.b == 0.0 && this.u == 0.0 && this.c == 0.0 && this.d == 1.0 && this.v == 0.0 && this.tx == 0.0 && this.ty == 0.0 && this.w == 1.0;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public double getU() {
        return this.u;
    }

    public void setU(double u) {
        this.u = u;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    public double getV() {
        return this.v;
    }

    public void setV(double v) {
        this.v = v;
    }

    public double getTx() {
        return this.tx;
    }

    public void setTx(double tx) {
        this.tx = tx;
    }

    public double getTy() {
        return this.ty;
    }

    public void setTy(double ty) {
        this.ty = ty;
    }

    public double getW() {
        return this.w;
    }

    public void setW(double w) {
        this.w = w;
    }
}

