/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.BaseParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.util.Vector;

public class MPEG4Parser
extends BaseParser {
    @Override
    public QuickTimeFile.Type getQuickTimeFileType() {
        return QuickTimeFile.Type.MPEG4;
    }

    public MPEG4Parser() {
    }

    public MPEG4Parser(QuickTimeFile.Type expectedType) {
        super(expectedType);
    }

    @Override
    public String readString(SeekableDataInput movieFile, int minsize) throws IOException {
        byte b;
        Vector<Byte> bytes = new Vector<Byte>(minsize < 32 ? 32 : minsize);
        while ((b = movieFile.readByte()) != 0) {
            bytes.add(b);
        }
        byte[] byteArray = new byte[bytes.size()];
        int i = 0;
        for (Byte b1 : bytes) {
            byteArray[i++] = b1;
        }
        while (i < minsize) {
            movieFile.readByte();
            ++i;
        }
        return new String(byteArray, 0, bytes.size(), "ASCII");
    }

    @Override
    public String readCString(SeekableDataInput movieFile) throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        byte c = 0;
        while ((c = movieFile.readByte()) != 0) {
            strBuilder.append((char)c);
        }
        return strBuilder.toString();
    }
}

