/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import noNamespace.DataContentTrack;
import noNamespace.DataRateStatistics;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class DataRateStats {
    private boolean nonContinuousEditList;
    private boolean nonHomogeneousRate;
    protected List<Long> maxOccurrences;
    protected double maxPeakRate;

    public DataRateStats(TrackAtom trakAtom) {
        TrackAtom.Cursor tkhdAtomCursor = trakAtom.new TrackAtom.Cursor();
        TrackHeaderAtom tkhdAtom = tkhdAtomCursor.getTrackHeaderAtom();
        EditListAtom elstAtom = tkhdAtomCursor.getEditListAtom();
        MediaAtom mAtom = tkhdAtomCursor.getMediaAtom();
        MediaAtom.Cursor mAtomCursor = mAtom.new MediaAtom.Cursor();
        MediaHeaderAtom mdhdAtom = mAtomCursor.getMediaHeaderAtom();
        MediaInformationAtom minfAtom = mAtomCursor.getMediaInformationAtom();
        MediaInformationAtom.Cursor minfAtomCursor = minfAtom.new MediaInformationAtom.Cursor();
        SampleTableAtom stblAtom = minfAtomCursor.getSampleTableAtom();
        if (elstAtom != null && !elstAtom.isEditListContinuous()) {
            this.nonContinuousEditList = true;
        }
        if (!stblAtom.isHomogeneousRate()) {
            this.nonHomogeneousRate = true;
        }
        SampleTableAtom.Cursor stblAtomCursor = stblAtom.new SampleTableAtom.Cursor();
        SampleToTimeAtom sttsAtom = stblAtomCursor.getSampleToTimeAtom();
        long sampleDuration = 1L;
        if (!sttsAtom.getCountToTimeTable().isEmpty()) {
            sampleDuration = sttsAtom.getCountToTimeTable().get(0).getSampleDuration();
        }
        int samplesPerWindow = Math.max(1, (int)Math.floor(mdhdAtom.getTimeScale() / sampleDuration));
        this.maxOccurrences = new ArrayList<Long>(1);
        if (stblAtomCursor.getSampleSizeAtom().getGlobalSampleSize() != 0L) {
            this.maxPeakRate = stblAtomCursor.getSampleSizeAtom().getGlobalSampleSize() * (long)samplesPerWindow * 8L / 1024L;
            this.maxOccurrences.add(0L);
        } else {
            DescriptiveStatistics statistics = new DescriptiveStatistics(samplesPerWindow);
            SampleTableAtom.SampleCursor sampleCursor = stblAtom.new SampleTableAtom.SampleCursor();
            double maxSum = 0.0;
            for (long mediaTimeRemaining = mdhdAtom.getDuration(); mediaTimeRemaining > 0L && sampleCursor.hasNextSample(); mediaTimeRemaining -= sampleCursor.getSampleDuration()) {
                sampleCursor.nextSample();
                statistics.addValue((double)sampleCursor.getSampleLength());
                double currentSum = statistics.getSum();
                if (currentSum > maxSum) {
                    maxSum = currentSum;
                    this.maxOccurrences.clear();
                }
                if (currentSum != maxSum) continue;
                this.maxOccurrences.add(sampleCursor.getSampleTime());
            }
            this.maxPeakRate = maxSum * 8.0 / 1024.0;
        }
    }

    public boolean isNonContinuousEditList() {
        return this.nonContinuousEditList;
    }

    public boolean isNonHomogeneousRate() {
        return this.nonHomogeneousRate;
    }

    public List<Long> getOccurrences() {
        return this.maxOccurrences;
    }

    public double getMaxPeakRate() {
        return this.maxPeakRate;
    }

    public void addToTrack(DataContentTrack track) {
        DataRateStatistics drs = track.addNewDataRateStatistics();
        drs.setUnits("Kb/s");
        DataRateStatistics.Peak peak = drs.addNewPeak();
        peak.setBigIntegerValue(BigInteger.valueOf(Math.round(this.getMaxPeakRate())));
        List<Long> occurs = this.getOccurrences();
        if (!occurs.isEmpty()) {
            Long firstDts = occurs.get(0);
            Long lastDts = occurs.get(occurs.size() - 1);
            peak.setFirstMediaDTS(BigInteger.valueOf(firstDts));
            peak.setLastMediaDTS(BigInteger.valueOf(lastDts));
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("maxPeakRate", this.getMaxPeakRate()).append("isNonContinuousEditList", (Object)Boolean.toString(this.isNonContinuousEditList())).append("isNonHomogeneousRate", (Object)Boolean.toString(this.isNonContinuousEditList())).append("occurrences", this.getOccurrences()).toString();
    }
}

