/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public interface Container {
    public List<?> getChildren();

    public <T> Iterable<T> getChildren(@Nonnull Class<T> var1);

    public <T> List<T> findChildrenOfType(@Nonnull Class<T> var1, boolean var2);

    public <T> T findSingleChildOfType(@Nonnull Class<T> var1, boolean var2, boolean var3);

    public static class Searcher {
        public static <T> List<T> findChildrenOfType(Class<T> clazz, boolean recurse, Container container) {
            List<?> children = container.getChildren();
            ArrayList<T> tmpList = new ArrayList<T>(children.size());
            for (Object o : children) {
                if (clazz.isAssignableFrom(o.getClass())) {
                    tmpList.add(clazz.cast(o));
                }
                if (!recurse || !(o instanceof Container)) continue;
                tmpList.addAll(((Container)o).findChildrenOfType(clazz, true));
            }
            return tmpList;
        }

        public static <T> T findSingleChildOfType(Class<T> clazz, boolean recurse, boolean failOnZero, boolean failOnGreaterThanOne, Container container) {
            List<T> items = Searcher.findChildrenOfType(clazz, recurse, container);
            if (items.isEmpty()) {
                if (failOnZero) {
                    throw new RuntimeException("Found zero children of type " + clazz + ", but I expected 1");
                }
                return null;
            }
            if (failOnGreaterThanOne && items.size() > 1) {
                throw new RuntimeException("Found more than one child of type " + clazz + ", but I expected 1");
            }
            return items.get(0);
        }

        public static enum Option {
            RECURSE,
            FAIL_ON_ZERO,
            FAIL_ON_MULTIPLE;

        }
    }
}

