/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

public class BitstreamReader {
    private static final int MACOS_BASE_DATE = 2082844800;

    public static long readU64(DataInput input) throws IOException {
        byte[] bytesFor64 = new byte[8];
        input.readFully(bytesFor64);
        BigInteger u64BI = new BigInteger(1, bytesFor64);
        if (u64BI.bitLength() > 63) {
            throw new IOException("Unable to read 64-bit unsigned integer.");
        }
        return u64BI.longValue();
    }

    public static long read64(DataInput input) throws IOException {
        byte[] bytesFor64 = new byte[8];
        input.readFully(bytesFor64);
        BigInteger u64BI = new BigInteger(1, bytesFor64);
        if (u64BI.bitLength() > 64) {
            throw new IOException("Unable to read 64-bit unsigned integer.");
        }
        return u64BI.longValue();
    }

    public static long read64LE(DataInput input) throws IOException {
        byte[] bytesFor64 = new byte[8];
        input.readFully(bytesFor64);
        byte intermediate = 0;
        for (int ii = 0; ii < 4; ++ii) {
            intermediate = bytesFor64[ii];
            bytesFor64[ii] = bytesFor64[7 - ii];
            bytesFor64[7 - ii] = intermediate;
        }
        BigInteger u64BI = new BigInteger(1, bytesFor64);
        if (u64BI.bitLength() > 64) {
            throw new IOException("Unable to read 64-bit unsigned integer.");
        }
        return u64BI.longValue();
    }

    public static long readU64(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 8L);
        return BitstreamReader.readU64((DataInput)input);
    }

    public static long readU32(DataInput input) throws IOException {
        byte[] bytesFor32 = new byte[4];
        input.readFully(bytesFor32);
        BigInteger u32BI = new BigInteger(1, bytesFor32);
        return u32BI.longValue();
    }

    public static long readU32LE(DataInput input) throws IOException {
        byte[] bytesFor32 = new byte[4];
        input.readFully(bytesFor32);
        byte aa = 0;
        aa = bytesFor32[0];
        bytesFor32[0] = bytesFor32[3];
        bytesFor32[3] = aa;
        aa = bytesFor32[1];
        bytesFor32[1] = bytesFor32[2];
        bytesFor32[2] = aa;
        BigInteger u32BI = new BigInteger(1, bytesFor32);
        return u32BI.longValue();
    }

    public static long readU32(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 4L);
        return BitstreamReader.readU32((DataInput)input);
    }

    public static String readFourCC(DataInput input) throws IOException {
        byte[] bytesForFourCC = new byte[4];
        input.readFully(bytesForFourCC);
        return new String(bytesForFourCC, "ISO8859_1");
    }

    public static String readFourCC(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 4L);
        return BitstreamReader.readFourCC((DataInput)input);
    }

    public static int readU16(SeekableDataInput movieFile) throws IOException {
        return movieFile.readUnsignedShort();
    }

    public static int readU16LE(DataInput input) throws IOException {
        byte[] bytesFor16 = new byte[2];
        input.readFully(bytesFor16);
        int ret = bytesFor16[1] & 0xFF;
        ret <<= 8;
        return ret |= bytesFor16[0] & 0xFF;
    }

    public static int readU16(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 2L);
        return BitstreamReader.readU16(input);
    }

    public static int readU8(SeekableDataInput movieFile) throws IOException {
        return movieFile.readUnsignedByte();
    }

    public static int readU8(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 1L);
        return BitstreamReader.readU8(input);
    }

    public static float readFixed32(SeekableDataInput movieFile) throws IOException {
        short left = movieFile.readShort();
        float rightDecimal = movieFile.readUnsignedShort();
        return (float)left + rightDecimal / 65536.0f;
    }

    public static float readFixed32(SeekableDataInput movieFile, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(movieFile, maxOffset, 4L);
        return BitstreamReader.readFixed32(movieFile);
    }

    public static float readFixed16(SeekableDataInput movieFile) throws IOException {
        byte left = movieFile.readByte();
        float rightDecimal = movieFile.readUnsignedByte();
        return (float)left + rightDecimal / 256.0f;
    }

    public static int read16(SeekableDataInput movieFile) throws IOException {
        return movieFile.readShort();
    }

    public static Date readDate(SeekableDataInput movieFile) throws IOException {
        return new Date((BitstreamReader.readU32((DataInput)movieFile) - 2082844800L) * 1000L);
    }

    public static float readFixedU32(SeekableDataInput movieFile) throws IOException {
        int left = movieFile.readUnsignedShort();
        float rightDecimal = movieFile.readUnsignedShort();
        return (float)left + rightDecimal / 65536.0f;
    }

    public static double readFloat64(SeekableDataInput movieFile) throws IOException {
        return movieFile.readDouble();
    }

    public static float readFloat32(SeekableDataInput movieFile) throws IOException {
        return movieFile.readFloat();
    }

    public static int read32(SeekableDataInput movieFile) throws IOException {
        return movieFile.readInt();
    }

    public static int read32(SeekableDataInput input, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(input, maxOffset, 4L);
        return BitstreamReader.read32(input);
    }

    public static float readBEFloat32(SeekableDataInput movieFile) throws IOException {
        byte[] b = new byte[4];
        movieFile.readFully(b);
        int bAsInt = 0;
        for (int i = 0; i < 3; ++i) {
            bAsInt += b[i];
            bAsInt <<= 8;
        }
        return Float.intBitsToFloat(bAsInt += b[3]);
    }

    public static double readBEFloat64(SeekableDataInput movieFile) throws IOException {
        byte[] b = new byte[8];
        movieFile.readFully(b);
        long bAsInt = 0L;
        for (int i = 0; i < 7; ++i) {
            bAsInt += (long)b[i];
            bAsInt <<= 8;
        }
        return Double.longBitsToDouble(bAsInt += (long)b[7]);
    }

    public static void checkOffsetLimit(SeekableDataInput sdi, long maxOffset) throws IOException {
        BitstreamReader.checkOffsetLimit(sdi, maxOffset, 0L);
    }

    public static void checkOffsetLimit(SeekableDataInput sdi, long maxOffset, long bytesToRead) throws IOException {
        if (sdi.getFilePointer() + bytesToRead > maxOffset) {
            while (sdi.getFilePointer() != maxOffset) {
                sdi.seek(maxOffset);
            }
            throw new OffsetLimitException();
        }
    }

    public static String readCString(SeekableDataInput movieFile) throws IOException {
        StringBuilder strBuilder = new StringBuilder();
        byte c = 0;
        while ((c = movieFile.readByte()) != 0) {
            strBuilder.append((char)c);
        }
        return strBuilder.toString();
    }

    public static class OffsetLimitException
    extends IOException {
        private static final long serialVersionUID = -3277770190135191191L;
    }
}

