/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.impl.ContainerContainerDescriberRunner;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.AtomCursor;
import com.apple.jingle.leghorn.quicktime.BitstreamReader;
import com.apple.jingle.leghorn.quicktime.Container;
import com.apple.jingle.leghorn.quicktime.MPEG4Parser;
import com.apple.jingle.leghorn.quicktime.QTContainerAtom;
import com.apple.jingle.leghorn.quicktime.QtFileCorruptException;
import com.apple.jingle.leghorn.quicktime.QuickTimeFile;
import com.apple.jingle.leghorn.quicktime.QuickTimeParser;
import com.apple.jingle.leghorn.quicktime.QuickTimeValidationContext;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffset64Atom;
import com.apple.jingle.leghorn.quicktime.atoms.ChunkOffsetAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompositionOffsetTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompositionShiftLeastGreatestAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompressedMovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.CompressedMovieDataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.DataCompressionAtom;
import com.apple.jingle.leghorn.quicktime.atoms.DataInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.DataReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.EditAtom;
import com.apple.jingle.leghorn.quicktime.atoms.EditListAtom;
import com.apple.jingle.leghorn.quicktime.atoms.ExtendedLanguageAtom;
import com.apple.jingle.leghorn.quicktime.atoms.FileTypeCompatabilityAtom;
import com.apple.jingle.leghorn.quicktime.atoms.HandlerReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MDatAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MediaInformationAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MetaAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieAtom;
import com.apple.jingle.leghorn.quicktime.atoms.MovieHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleDescriptionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleSizeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToChunk;
import com.apple.jingle.leghorn.quicktime.atoms.SampleToTimeAtom;
import com.apple.jingle.leghorn.quicktime.atoms.SyncSampleAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAperatureDimensionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackCleanAperatureDimensionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackEncodedPixelsDimensionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackGroupAssignmentAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackHeaderAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackLoadSettingsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackProductionAperatureDimensionsAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackReferenceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.TrackReferenceInstanceAtom;
import com.apple.jingle.leghorn.quicktime.atoms.UserDataAtom;
import com.apple.jingle.leghorn.quicktime.atoms.VideoMediaHeaderAtom;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public abstract class BaseParser {
    protected static final Map<String, Class<? extends Atom>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends Atom>>();
    protected static final Logger lager = Logger.getLogger(QuickTimeParser.class);
    private static final BigInteger LONG_MAX_VALUE_BI = new BigInteger(Long.toString(Long.MAX_VALUE));
    @Nullable
    private final QuickTimeFile.Type expectedType;

    BaseParser() {
        this.expectedType = null;
    }

    BaseParser(QuickTimeFile.Type expectedType) {
        this.expectedType = expectedType;
    }

    public static void main(String[] args) throws Exception {
        String fileArgument = args[0];
        BaseParser parser = BaseParser.determineParserToUseBasedOnFilename(fileArgument);
        URI uri = ContainerContainerDescriberRunner.uriForString(fileArgument);
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(fileArgument);
        QuickTimeFile file = parser.parseFile((LeghornValidationContext)ctx, uri);
        AtomCursor.printAllAtoms(file, "");
    }

    public static BaseParser determineParserToUseBasedOnFilename(String fileArgument) {
        if (fileArgument.endsWith(".mov") || fileArgument.endsWith(".MOV")) {
            return new QuickTimeParser();
        }
        if (fileArgument.toLowerCase().endsWith(".m4v") || fileArgument.toLowerCase().endsWith(".mp4") || fileArgument.toLowerCase().endsWith(".m4a")) {
            return new MPEG4Parser();
        }
        throw new RuntimeException("Could not determine parser to use based on file extension: " + fileArgument);
    }

    public abstract QuickTimeFile.Type getQuickTimeFileType();

    public QuickTimeFile parseFile(@Nonnull LeghornValidationContext ctx, SeekableDataInput movieFile) throws IOException {
        return this.parseInput(ctx, movieFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuickTimeFile parseFile(@Nonnull LeghornValidationContext ctx, URI movieFile) throws IOException {
        try (SeekableDataInput sdi = SeekableDataInput.Factory.fromURI((URI)movieFile);){
            QuickTimeFile quickTimeFile = this.parseInput(ctx, sdi);
            return quickTimeFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuickTimeFile parseFile(@Nonnull LeghornValidationContext ctx, File movieFile) throws IOException {
        try (FileSeekableDataInput sdi = new FileSeekableDataInput(movieFile.getAbsolutePath());){
            QuickTimeFile quickTimeFile = this.parseInput(ctx, (SeekableDataInput)sdi);
            return quickTimeFile;
        }
    }

    public QuickTimeFile parseInput(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        return this.parseInputInternal(ctx, sdi);
    }

    public QuickTimeFile parseInputWithoutValidation(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        return this.parseInputInternal(ctx, sdi);
    }

    private QuickTimeFile parseInputInternal(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        QuickTimeFile qtFile = new QuickTimeFile(this, sdi, sdi.length());
        if (sdi.length() < 1L) {
            ctx.addCheckAlert(MediaValidationCode.FILE_EMPTY, MediaUtil.dictionary);
            return qtFile;
        }
        while (sdi.getFilePointer() < sdi.length()) {
            Atom atom;
            block5: {
                try {
                    atom = this.parseAtom(ctx, null, sdi, qtFile);
                    if (!(atom instanceof FileTypeCompatabilityAtom)) break block5;
                    FileTypeCompatabilityAtom ftyp = (FileTypeCompatabilityAtom)atom;
                    if (null != this.expectedType && !ftyp.isCompatibleWithType(this.expectedType)) {
                        ctx.addCheckAlert(ftyp.getAtomOffset(), MediaValidationCode.MOV_CONTAINER_INCOMPATIBLE, MediaUtil.dictionary.add("message", "Based on the [ftyp] atom, this file is not compatible with " + (Object)((Object)this.expectedType)).add("expectedFtyp", this.expectedType.name()).add("actualFtyp", ftyp.getFileType().name()));
                    }
                    break block5;
                }
                catch (QtFileCorruptException parseException) {
                    parseException.addCheckAlert(ctx);
                }
                break;
            }
            if (atom == null) continue;
            this.recurseValidateAtoms(ctx, atom, sdi);
            qtFile.atoms.add(atom);
        }
        return qtFile;
    }

    private boolean recurseValidateAtoms(@Nonnull LeghornValidationContext ctx, Atom atom, SeekableDataInput sdi) throws IOException {
        boolean result = atom.validate(ctx, sdi);
        if (atom instanceof QTContainerAtom) {
            QTContainerAtom container = (QTContainerAtom)atom;
            List<? extends Atom> children = container.getChildren();
            for (Atom atom2 : children) {
                result &= this.recurseValidateAtoms(ctx, atom2, sdi);
            }
        }
        return result;
    }

    public Atom parseAtom(@Nonnull LeghornValidationContext ctx, @Nullable Atom parent, SeekableDataInput raf, QuickTimeFile qtFile) throws IOException, QtFileCorruptException {
        long parentMaxOffset = parent == null ? raf.length() : parent.getAtomOffset() + parent.getAtomSize();
        long offset = raf.getFilePointer();
        long size = 0L;
        String type = null;
        try {
            size = BitstreamReader.readU32(raf, parentMaxOffset);
            type = BitstreamReader.readFourCC(raf, parentMaxOffset);
        }
        catch (BitstreamReader.OffsetLimitException ex) {
            ctx.addCheckAlert(MediaValidationCode.FILE_ATOM_EXTRA_BYTES, MediaUtil.dictionary.add("javaClass", "BaseParser").add("size", parent == null ? "N/A Top level atom" : Long.toString(parent.getAtomSize())).add("type", parent == null ? "N/A Top level atom" : parent.getAtomType()));
            return new Atom();
        }
        catch (EOFException ex) {
            String errMsg = "Not enough bytes to read atom header. Parent:";
            String parentAtomMsg = "null";
            if (parent != null) {
                parentAtomMsg = parent.toString();
            }
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, errMsg + parentAtomMsg, offset).put("parentAtomMsg", parentAtomMsg);
        }
        lager.debug((Object)("Atom type: " + type + " size: " + size + "  parent: " + parent));
        if (size == 1L) {
            try {
                size = BitstreamReader.readU64(raf, parentMaxOffset);
            }
            catch (BitstreamReader.OffsetLimitException ex) {
                ctx.addCheckAlert(MediaValidationCode.FILE_ATOM_EXTRA_BYTES, MediaUtil.dictionary.add("javaClass", "BaseParser").add("size", parent == null ? "N/A Top level atom" : Long.toString(parent.getAtomSize())).add("type", parent == null ? "N/A Top level atom" : parent.getAtomType()));
                return new Atom();
            }
            catch (EOFException ex) {
                String msg = "Not enough bytes to extended size of atom:" + type + " with parent";
                throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, msg, offset).put("atomType", type);
            }
        } else if (size == 0L && parent == null) {
            size = raf.length() - raf.getFilePointer() + 8L;
        }
        if (size < 8L) {
            String msg = "Atom size too small. Size " + size + " found for atom type \"" + type + "\" at offset " + offset;
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, msg, offset).put("atomType", type);
        }
        if (size > raf.length() - offset) {
            String msg = "Atom size extends beyond the end of the file.  Size " + size + " found for atom type \"" + type + "\" at offset " + offset + ". Input size: " + raf.length();
            throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, msg, offset).put("atomType", type).put("bytesRequired", Long.toString(size)).put("bytesRemaining", Long.toString(raf.length()));
        }
        if (size > parentMaxOffset - offset) {
            MediaValidationCode validationCode = type != null && type.equals("udta") ? MediaValidationCode.FILE_ATOM_EXCEEDS_PARENT_ERROR : MediaValidationCode.FILE_ATOM_EXCEEDS_PARENT;
            ctx.addCheckAlert(validationCode, MediaUtil.dictionary.add("javaClass", "BaseParser").add("type", type).add("parentSize", Long.toString(parent.getAtomSize())).add("parentType", parent.getAtomType()));
        }
        Atom atom = null;
        if (TYPE_CLASS_MAP.containsKey(type)) {
            try {
                atom = TYPE_CLASS_MAP.get(type).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                lager.debug((Object)e);
            }
        }
        if (atom == null) {
            atom = new Atom();
            lager.debug((Object)("Not in TYPE_CLASS_MAP: " + type));
        }
        ctx = ctx.child(type);
        atom.setAttributes(offset, size, type);
        atom.setParent(parent);
        try {
            atom.parseAtom(ctx, this, raf);
        }
        catch (BitstreamReader.OffsetLimitException ex) {
            MediaValidationCode validationCode = type != null && type.equals("udta") ? MediaValidationCode.FILE_ATOM_EXCEEDS_PARENT_ERROR : MediaValidationCode.FILE_ATOM_EXCEEDS_PARENT;
            ctx.addCheckAlert(validationCode, MediaUtil.dictionary.add("javaClass", "BaseParser").add("type", type).add("parentSize", Long.toString(parent.getAtomSize())).add("parentType", parent.getAtomType()));
        }
        LeghornValidationContext childCtx = ctx;
        if (atom instanceof QTContainerAtom) {
            QTContainerAtom containerAtom = (QTContainerAtom)atom;
            while (raf.getFilePointer() < offset + size) {
                Atom childAtom;
                TrackAtom track;
                TrackHeaderAtom thdr;
                if (ctx == childCtx && atom instanceof TrackAtom && null != (thdr = (track = (TrackAtom)atom).findSingleChildOfType(TrackHeaderAtom.class, false, false))) {
                    childCtx = ctx.child(Long.toString(thdr.getTrackId()));
                }
                if ((childAtom = this.parseAtom(childCtx, containerAtom, raf, qtFile)) instanceof CompressedMovieAtom) {
                    Atom actualAtom;
                    CompressedMovieAtom cmov = (CompressedMovieAtom)childAtom;
                    CompressedMovieDataAtom cmvd = cmov.findChild(CompressedMovieDataAtom.class, new Container.Searcher.Option[0]);
                    if (null == cmvd) {
                        throw new QtFileCorruptException(MediaValidationCode.FILE_APPEARS_CORRUPT, "Missing required CMVD atom");
                    }
                    ByteArraySeekableDataInput uncompressedBytes = new ByteArraySeekableDataInput(cmvd.getUncompressedData(), qtFile.getLength());
                    atom = actualAtom = this.parseAtom(ctx, null, (SeekableDataInput)uncompressedBytes, qtFile);
                    continue;
                }
                containerAtom.atoms.add(childAtom);
            }
        }
        long maxAtomLimit = Math.min(offset + size, parentMaxOffset);
        while (raf.getFilePointer() != maxAtomLimit) {
            raf.seek(maxAtomLimit);
        }
        ++qtFile.totalNumberOfAtoms;
        return atom;
    }

    public void always(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("a(" + a + ") != b(" + b + ")");
        }
    }

    public abstract String readString(SeekableDataInput var1, int var2) throws IOException;

    public abstract String readCString(SeekableDataInput var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuickTimeFile parseFileWithoutValidation(File movieFile) throws IOException {
        QuickTimeValidationContext ctx = new QuickTimeValidationContext(movieFile.getName());
        try (FileSeekableDataInput sdi = new FileSeekableDataInput(movieFile.getAbsolutePath());){
            QuickTimeFile quickTimeFile = this.parseInputWithoutValidation(ctx, (SeekableDataInput)sdi);
            return quickTimeFile;
        }
    }

    static {
        TYPE_CLASS_MAP.put("ftyp", FileTypeCompatabilityAtom.class);
        TYPE_CLASS_MAP.put("moov", MovieAtom.class);
        TYPE_CLASS_MAP.put("mvhd", MovieHeaderAtom.class);
        TYPE_CLASS_MAP.put("trak", TrackAtom.class);
        TYPE_CLASS_MAP.put("tkhd", TrackHeaderAtom.class);
        TYPE_CLASS_MAP.put("edts", EditAtom.class);
        TYPE_CLASS_MAP.put("elst", EditListAtom.class);
        TYPE_CLASS_MAP.put("mdia", MediaAtom.class);
        TYPE_CLASS_MAP.put("mdhd", MediaHeaderAtom.class);
        TYPE_CLASS_MAP.put("minf", MediaInformationAtom.class);
        TYPE_CLASS_MAP.put("hdlr", HandlerReferenceAtom.class);
        TYPE_CLASS_MAP.put("stbl", SampleTableAtom.class);
        TYPE_CLASS_MAP.put("stsc", SampleToChunk.class);
        TYPE_CLASS_MAP.put("ctts", CompositionOffsetTableAtom.class);
        TYPE_CLASS_MAP.put("cslg", CompositionShiftLeastGreatestAtom.class);
        TYPE_CLASS_MAP.put("stsd", SampleDescriptionsAtom.class);
        TYPE_CLASS_MAP.put("stsz", SampleSizeAtom.class);
        TYPE_CLASS_MAP.put("stz2", SampleSizeAtom.class);
        TYPE_CLASS_MAP.put("stco", ChunkOffsetAtom.class);
        TYPE_CLASS_MAP.put("co64", ChunkOffset64Atom.class);
        TYPE_CLASS_MAP.put("stts", SampleToTimeAtom.class);
        TYPE_CLASS_MAP.put("stss", SyncSampleAtom.class);
        TYPE_CLASS_MAP.put("tapt", TrackAperatureDimensionsAtom.class);
        TYPE_CLASS_MAP.put("clef", TrackCleanAperatureDimensionsAtom.class);
        TYPE_CLASS_MAP.put("prof", TrackProductionAperatureDimensionsAtom.class);
        TYPE_CLASS_MAP.put("enof", TrackEncodedPixelsDimensionsAtom.class);
        TYPE_CLASS_MAP.put("dinf", DataInformationAtom.class);
        TYPE_CLASS_MAP.put("dref", DataReferenceAtom.class);
        TYPE_CLASS_MAP.put("tref", TrackReferenceAtom.class);
        TYPE_CLASS_MAP.put("chap", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("sbtl", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("fall", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("tmcd", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("hint", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("tc64", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("forc", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("folw", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("mpod", TrackReferenceInstanceAtom.class);
        TYPE_CLASS_MAP.put("load", TrackLoadSettingsAtom.class);
        TYPE_CLASS_MAP.put("elng", ExtendedLanguageAtom.class);
        TYPE_CLASS_MAP.put("cmov", CompressedMovieAtom.class);
        TYPE_CLASS_MAP.put("dcom", DataCompressionAtom.class);
        TYPE_CLASS_MAP.put("cmvd", CompressedMovieDataAtom.class);
        TYPE_CLASS_MAP.put("udta", UserDataAtom.class);
        TYPE_CLASS_MAP.put("meta", MetaAtom.class);
        TYPE_CLASS_MAP.put("elng", ExtendedLanguageAtom.class);
        TYPE_CLASS_MAP.put("vmhd", VideoMediaHeaderAtom.class);
        TYPE_CLASS_MAP.put("mdat", MDatAtom.class);
        TYPE_CLASS_MAP.put("tgas", TrackGroupAssignmentAtom.class);
    }
}

