/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.atoms.SampleTableAtom;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import java.io.InputStream;

public class AtomInputStream
extends InputStream {
    private SeekableDataInput sdi;
    private long availableBytes;

    public AtomInputStream(SeekableDataInput sdi, SampleTableAtom.SampleCursor cursor) throws IOException {
        this.sdi = sdi;
        sdi.seek(cursor.getSamplePosition());
        this.availableBytes = cursor.getSampleLength();
    }

    public AtomInputStream(SeekableDataInput sdi, Atom atom) throws IOException {
        this.sdi = sdi;
        sdi.seek(atom.offset);
        this.availableBytes = atom.size;
    }

    @Override
    public int read() throws IOException {
        if (this.checkByteRange(1)) {
            --this.availableBytes;
            return this.sdi.readUnsignedByte();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.checkByteRange(len)) {
            this.sdi.readFully(bytes, off, len);
            this.availableBytes -= (long)len;
            return len;
        }
        if (this.availableBytes > 0L) {
            int newLength = (int)this.availableBytes;
            this.sdi.readFully(bytes, off, newLength);
            this.availableBytes = 0L;
            return newLength;
        }
        return -1;
    }

    private boolean checkByteRange(int amount) {
        return this.availableBytes >= (long)amount;
    }
}

