/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.quicktime;

import com.apple.jingle.leghorn.quicktime.Atom;
import com.apple.jingle.leghorn.quicktime.Container;

public class AtomCursor {
    protected Atom current;

    public static Atom findParentOfType(Atom atom, String type) {
        if (atom.parent == null) {
            return null;
        }
        if (atom.parent.atomType.equals(type)) {
            return atom.parent;
        }
        return AtomCursor.findParentOfType(atom.parent, type);
    }

    public static Atom findChildOfType(Container atom, String type) {
        for (Atom child : atom.getChildren()) {
            if (!child.atomType.equals(type)) continue;
            return child;
        }
        return null;
    }

    public static void printAllAtoms(Container atom, String indent) {
        for (Object currentAtom : atom.getChildren()) {
            System.out.println(indent + " " + currentAtom);
            if (!(currentAtom instanceof Container)) continue;
            AtomCursor.printAllAtoms((Container)currentAtom, indent + " ");
        }
    }
}

