/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.tools;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ProgramStreamValidationContext;
import com.apple.jingle.leghorn.mpeg2.packets.TransportPacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.TSPESPacket;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramAssociationTable;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramMapTable;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Program;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class TSStreamWriter {
    private Map<Integer, FileOutputStream> streamToFileMap = new HashMap<Integer, FileOutputStream>();
    private String outputFilePrefix;
    private ProgramAssociationTable pat;
    private Map<Integer, ProgramMapTable> programMapTables = new HashMap<Integer, ProgramMapTable>();
    private Map<Integer, Program> programs = new HashMap<Integer, Program>();
    private Map<Integer, byte[]> partialPacketMap = new HashMap<Integer, byte[]>();
    private TSPESPacket currentPESPacket;

    public static void main(String[] args) throws IOException {
        FileSeekableDataInput sdi = new FileSeekableDataInput(args[0]);
        ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(sdi.getFileName());
        TSStreamWriter tsStreamWriter = new TSStreamWriter();
        tsStreamWriter.outputFilePrefix = args[0];
        while (sdi.readByte() != 71) {
        }
        sdi.seek(sdi.getFilePointer() - 1L);
        while (sdi.getFilePointer() < sdi.length()) {
            TransportPacket packet = new TransportPacket();
            packet.parse(ctx, (SeekableDataInput)sdi);
            if (tsStreamWriter.isPSIPacket(packet)) {
                if (packet.getPid() == 0) {
                    tsStreamWriter.handlePAT(ctx, packet);
                    continue;
                }
                if (!tsStreamWriter.programMapTables.containsKey(packet.getPid())) continue;
                tsStreamWriter.handlePMT(ctx, packet);
                continue;
            }
            if (tsStreamWriter.isPESPacket(packet)) {
                tsStreamWriter.handlePESPacket(ctx, packet);
                continue;
            }
            if (!tsStreamWriter.isNullPacket(packet)) continue;
        }
    }

    private void writeToFile(int streamId, SeekableDataInput sdi) throws IOException {
        FileOutputStream writer = this.streamToFileMap.get(streamId);
        if (writer == null) {
            writer = new FileOutputStream(this.outputFilePrefix + "." + streamId);
            this.streamToFileMap.put(streamId, writer);
        }
        byte[] buffer = new byte[(int)sdi.length() - 1];
        if (sdi.length() > 0L) {
            sdi.seek(0L);
            sdi.readFully(buffer);
            writer.write(buffer);
        }
    }

    private long programIdFromStreamId(int streamId) {
        for (Map.Entry<Integer, ProgramMapTable> pairs : this.programMapTables.entrySet()) {
            if (!pairs.getValue().containsPid(streamId)) continue;
            return pairs.getValue().getProgramNumber();
        }
        return -1L;
    }

    private void handlePESPacket(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        byte[] newPayloadBytes = packet.getPayload();
        if (packet.getPayloadUnitStartIndication() == 1) {
            if (this.partialPacketMap.get(packet.getPid()) == null) {
                this.partialPacketMap.put(packet.getPid(), newPayloadBytes);
            } else {
                byte[] pesPacketByteArray = this.partialPacketMap.get(packet.getPid());
                ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(pesPacketByteArray, (long)pesPacketByteArray.length);
                byte[] nextBytes = new byte[3];
                basdi.readFully(nextBytes);
                int streamId = (int)MPEG2MediaReader.readU8((ByteSequence)basdi);
                int packetLength = (int)MPEG2MediaReader.readU16((ByteSequence)basdi);
                long offset = basdi.getFilePointer();
                TSPESPacket pesPacket = new TSPESPacket();
                pesPacket.setTsPid(packet.getPid());
                pesPacket.setAttributes(streamId, packetLength, offset);
                pesPacket.parse(ctx, (SeekableDataInput)basdi);
                byte[] arrayToWrite = new byte[(int)(basdi.length() - basdi.getFilePointer())];
                basdi.readFully(arrayToWrite);
                basdi = new ByteArraySeekableDataInput(arrayToWrite, (long)arrayToWrite.length);
                this.writeToFile(streamId, (SeekableDataInput)basdi);
                this.partialPacketMap.put(packet.getPid(), null);
            }
        } else if (this.partialPacketMap.get(packet.getPid()) != null) {
            byte[] currentBytes = this.partialPacketMap.get(packet.getPid());
            byte[] newBiggerPartialPesPacket = new byte[newPayloadBytes.length + currentBytes.length];
            System.arraycopy(currentBytes, 0, newBiggerPartialPesPacket, 0, currentBytes.length);
            System.arraycopy(newPayloadBytes, 0, newBiggerPartialPesPacket, currentBytes.length, newPayloadBytes.length);
            this.partialPacketMap.put(packet.getPid(), newBiggerPartialPesPacket);
        }
    }

    private void handlePAT(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        this.pat = new ProgramAssociationTable(packet.getPid(), this.programs, this.programMapTables);
        byte[] payload = packet.getPayload();
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(payload, (long)payload.length);
        this.pat.parse(ctx, (SeekableDataInput)basdi);
    }

    private void handlePMT(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        ProgramMapTable newPmt = this.programMapTables.get(packet.getPid());
        byte[] payload = packet.getPayload();
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(payload, (long)payload.length);
        newPmt.parse(ctx, (SeekableDataInput)basdi);
        this.programMapTables.put((int)newPmt.getProgramNumber(), newPmt);
        this.programs.get((int)newPmt.getProgramNumber()).setPMT(newPmt);
    }

    private boolean isPSIPacket(TransportPacket packet) {
        int pid = packet.getPid();
        if (pid == 0 || pid == 1 || pid == 2 || pid == 3) {
            return true;
        }
        return this.programMapTables.containsKey(pid);
    }

    private boolean isPESPacket(TransportPacket packet) {
        return packet.getPid() != 8191;
    }

    private boolean isNullPacket(TransportPacket packet) {
        return packet.getPid() == 8191;
    }
}

