/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.tools;

import com.apple.jingle.leghorn.mpeg2.ProgramStreamValidationContext;
import com.apple.jingle.leghorn.mpeg2.packets.TransportPacket;
import com.apple.jingle.leghorn.mpeg2.ts.AdaptationField;
import com.apple.jingle.media.foundation.io.FileSeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;

public class TSPacketPrinter {
    public static void main(String[] args) throws IOException {
        FileSeekableDataInput sdi = new FileSeekableDataInput(args[0]);
        ProgramStreamValidationContext ctx = new ProgramStreamValidationContext(sdi.getFileName());
        while (sdi.readByte() != 71) {
        }
        sdi.seek(sdi.getFilePointer() - 1L);
        while (sdi.getFilePointer() < sdi.length()) {
            TransportPacket packet = new TransportPacket();
            packet.parse(ctx, (SeekableDataInput)sdi);
            if (packet.getAdaptationField() == null) continue;
            TSPacketPrinter.printPacket(packet);
        }
    }

    public static void printPacket(TransportPacket packet) {
        System.out.print("--------------------------------------\n");
        System.out.print("TS-Packet: PID: " + packet.getPid() + "," + " Offset: " + packet.getOffset() + "\n");
        System.out.print("Transport error indicator: " + packet.getTransportErrorIndicator() + "\n");
        System.out.print("Payload unit start indicator: " + packet.getPayloadUnitStartIndication() + "\n");
        System.out.print("Transport priority: " + packet.getTransportPriority() + "\n");
        System.out.print("PID: " + packet.getPid() + "\n");
        System.out.print("Transport scrambling control: " + packet.getScramblingControl() + "\n");
        System.out.print("Adaptation Field Control: " + packet.getAdaptationFieldControl() + "\n");
        if (packet.getAdaptationFieldControl() == 2L || packet.getAdaptationFieldControl() == 3L) {
            System.out.print("Adaptation Field: " + TSPacketPrinter.adaptationFieldString(packet.getAdaptationField()) + "\n");
        }
        System.out.print("--------------------------------------\n");
    }

    public static String adaptationFieldString(AdaptationField adaptationField) {
        return "length=" + adaptationField.getLength() + "\n discontinuityIndicator=" + adaptationField.getDiscontinuityIndicator() + "\n randomAccessIndicator=" + adaptationField.getRandomAccessIndicator() + "\n esPriorityIndicator=" + adaptationField.getEsPriorityIndicator() + "\n pcrFlag=" + adaptationField.getPcrFlag() + "\n opcrFlag=" + adaptationField.getOpcrFlag() + "\n splicingPointFlag=" + adaptationField.getSplicingPointFlag() + "\n transportPrivateDataFlag=" + adaptationField.getTransportPrivateDataFlag() + "\n adaptationFieldExtensionFlag=" + adaptationField.getAdaptationFieldExtensionFlag() + "\n spliceCountdown=" + adaptationField.getSpliceCountdown() + "\n pcr=" + adaptationField.getPcr() + "\n opcr=" + adaptationField.getOpcr();
    }
}

