/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.streams;

import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.leghorn.bitstream.avc.AVCConstants;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.datatypes.AspectRatio;
import com.apple.jingle.leghorn.mpeg2.ts.packets.AVCVideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Stream;
import com.apple.jingle.leghorn.mpeg2.ts.streams.StreamInfo;
import java.math.BigInteger;

public class VideoStream
extends Stream {
    private int height;
    private int width;
    private AVCConstants.Profile profile;
    private double level;
    private boolean cabacEnabled;
    private AspectRatio displayAspectRatio;
    private MPEG2ProgramStreamConstants.ColorSpace colorSpace;
    private MPEG2ProgramStreamConstants.ChromaSubsampling chromaSubSampling;
    private int bitDepth;
    private FieldOrdering fieldOrdering;
    private String videoFormat;

    public VideoStream(AVCVideoSequencePacket avcPacket, StreamInfo streamInfo) {
        this.streamInfo = streamInfo;
        this.height = avcPacket.getHeight();
        this.width = avcPacket.getWidth();
        this.profile = avcPacket.getProfile();
        this.level = avcPacket.getLevel();
        this.cabacEnabled = avcPacket.getCabacEnabled();
        this.codecId = streamInfo.getStreamType();
        this.fieldOrdering = avcPacket.getFieldOrdering();
        this.colorSpace = avcPacket.getColorSpace();
        this.chromaSubSampling = avcPacket.getChromaSubsampling();
        this.videoFormat = avcPacket.getVideoFormat();
    }

    @Override
    public void populateStreamNode(noNamespace.Stream currentStream) {
        currentStream.addNewHeight().setBigIntegerValue(BigInteger.valueOf(this.height));
        currentStream.addNewWidth().setBigIntegerValue(BigInteger.valueOf(this.width));
        currentStream.addNewProfile().setStringValue(this.profile.toString());
        currentStream.addNewLevel().setDoubleValue(this.level);
        currentStream.setCabacEnabled(this.cabacEnabled);
        currentStream.setChromaFormat(this.chromaSubSampling.getToolParameter());
        currentStream.addNewFieldDominance().setStringValue(this.fieldOrdering.getToolParameter());
    }

    public String toString() {
        return "VideoStream{height=" + this.height + ", width=" + this.width + ", profile=" + (Object)((Object)this.profile) + ", level=" + this.level + ", cabacEnabled=" + this.cabacEnabled + ", codecId='" + this.codecId + '\'' + ", displayAspectRatio=" + this.displayAspectRatio + ", colorSpace=" + (Object)((Object)this.colorSpace) + ", chromaSubSampling=" + (Object)((Object)this.chromaSubSampling) + ", bitDepth=" + this.bitDepth + ", fieldOrdering=" + (Object)((Object)this.fieldOrdering) + '}';
    }
}

