/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.streams;

import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;

public class StreamInfo {
    private int streamType;
    private int elementaryPid;
    private int esInfoLength;

    public void parse(SeekableDataInput sdi) throws IOException {
        byte[] buffer = new byte[5];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.streamType = (int)bitReader.readUBits(8);
        bitReader.readUBits(3);
        this.elementaryPid = (int)bitReader.readUBits(13);
        bitReader.readUBits(4);
        this.esInfoLength = (int)bitReader.readUBits(12);
        sdi.skipBytes(this.esInfoLength);
    }

    public int getElementaryPid() {
        return this.elementaryPid;
    }

    public int getStreamType() {
        return this.streamType;
    }

    public String toString() {
        return "\n\t\t streamType: " + this.streamType + " (" + MPEG2ProgramStreamConstants.MAP_OF_STREAM_TYPE_CODES.get(this.streamType) + ")" + "\n\t\t elementaryPid: " + this.elementaryPid + "\n\t\t esInfoLength: " + this.esInfoLength + "\n";
    }
}

