/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.streams;

import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramMapTable;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Stream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Program {
    private static final Logger log = Logger.getLogger(Program.class);
    private Map<Integer, Stream> streams;
    ProgramMapTable pmt;
    private int programNumber;
    private int networkPid;

    public Program(int programNumber, int networkPid) {
        this.programNumber = programNumber;
        this.streams = new HashMap<Integer, Stream>();
        this.networkPid = networkPid;
    }

    public ProgramMapTable getPMT() {
        return this.pmt;
    }

    public void setPMT(ProgramMapTable pmt) {
        this.pmt = pmt;
    }

    public void addStream(int streamPid, Stream stream) {
        this.streams.put(streamPid, stream);
        log.debug((Object)("Added stream " + streamPid + " to program " + this.programNumber));
    }

    public Map<Integer, Stream> getStreams() {
        return this.streams;
    }

    public Stream getStream(int pid) {
        return this.streams.get(pid);
    }

    public int getProgramNumber() {
        return this.programNumber;
    }

    public int getNetworkPid() {
        return this.networkPid;
    }

    public List<Stream> getStreamsAsList() {
        return new ArrayList<Stream>(this.streams.values());
    }

    public String toString() {
        return "Program{streams=" + this.streams + ", programNumber=" + this.programNumber + ", networkPid=" + this.networkPid + '}';
    }
}

