/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.psi;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ts.TransportStreamPayload;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ProgramStreamInformation
extends TransportStreamPayload {
    protected long tableId;
    protected long sectionSyntaxIndicator;
    protected long reservedBits;
    protected long sectionLength;
    protected int pointerField;

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.offset = sdi.getFilePointer();
        this.pointerField = sdi.readUnsignedByte();
        sdi.seek(sdi.getFilePointer() + (long)this.pointerField);
        this.tableId = sdi.readUnsignedByte();
        byte[] buffer = new byte[2];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.sectionSyntaxIndicator = bitReader.readUBits(1);
        this.reservedBits = bitReader.readUBits(3);
        this.sectionLength = bitReader.readUBits(12);
    }

    public String toString() {
        return "ProgramStreamInformation{tableId=" + this.tableId + ", sectionSyntaxIndicator=" + this.sectionSyntaxIndicator + ", reservedBits=" + this.reservedBits + ", sectionLength=" + this.sectionLength + ", pointerField=" + this.pointerField + '}';
    }
}

