/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.psi;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramStreamInformation;
import com.apple.jingle.leghorn.mpeg2.ts.streams.StreamInfo;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class ProgramMapTable
extends ProgramStreamInformation {
    private long programNumber;
    private long versionNmber;
    private long currentNextIndicator;
    private long sectionNumber;
    private long lastSectionNumber;
    private long pcrPid;
    private long programInfoLength;
    private byte[] crc32;
    private List<StreamInfo> streamInfos;

    public ProgramMapTable(int pid) {
        this.pid = pid;
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        super.parse(ctx, sdi);
        byte[] buffer = new byte[9];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.programNumber = bitReader.readUBits(16);
        bitReader.readUBits(2);
        this.versionNmber = bitReader.readUBits(5);
        this.currentNextIndicator = bitReader.readUBits(1);
        this.sectionNumber = bitReader.readUBits(8);
        this.lastSectionNumber = bitReader.readUBits(8);
        bitReader.readUBits(3);
        this.pcrPid = bitReader.readUBits(13);
        bitReader.readUBits(4);
        this.programInfoLength = bitReader.readUBits(12);
        sdi.skipBytes((int)this.programInfoLength);
        this.streamInfos = new ArrayList<StreamInfo>();
        while (sdi.getFilePointer() < this.offset + this.sectionLength - 4L) {
            StreamInfo streamInfo = new StreamInfo();
            streamInfo.parse(sdi);
            this.streamInfos.add(streamInfo);
        }
        this.crc32 = new byte[4];
        sdi.readFully(this.crc32);
    }

    public boolean containsPid(int id) {
        if (this.streamInfos != null) {
            for (StreamInfo streamInfo : this.getStreamInfos()) {
                if (streamInfo.getElementaryPid() != id) continue;
                return true;
            }
        }
        return false;
    }

    public StreamInfo getStreamInfoForPid(int pid) {
        for (StreamInfo streamInfo : this.getStreamInfos()) {
            if (streamInfo.getElementaryPid() != pid) continue;
            return streamInfo;
        }
        return null;
    }

    public List<StreamInfo> getStreamInfos() {
        return this.streamInfos;
    }

    public long getProgramNumber() {
        return this.programNumber;
    }

    @Override
    public String toString() {
        return "programNumber: " + this.programNumber + "\n\t versionNmber: " + this.versionNmber + "\n\t currentNextIndicator: " + this.currentNextIndicator + "\n\t sectionNumber: " + this.sectionNumber + "\n\t lastSectionNumber: " + this.lastSectionNumber + "\n\t pcrPid: " + this.pcrPid + "\n\t programInfoLength: " + this.programInfoLength + "\n\t crc32: " + this.crc32 + "\n\t streams: " + this.streamInfos + '}';
    }
}

