/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.psi;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramMapTable;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramStreamInformation;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Program;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;

public class ProgramAssociationTable
extends ProgramStreamInformation {
    private Map<Integer, Program> programs;
    private Map<Integer, ProgramMapTable> programMapTables;
    private long transportStreamId;
    private long versionNumber;
    private long currentNextIndicator;
    private long sectionNumber;
    private long lastSectionNumber;
    private byte[] crc32;

    public ProgramAssociationTable(long pid, Map<Integer, Program> programs, Map<Integer, ProgramMapTable> programMapTables) {
        this.pid = pid;
        this.programs = programs;
        this.programMapTables = programMapTables;
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        super.parse(ctx, sdi);
        byte[] buffer = new byte[5];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.transportStreamId = bitReader.readUBits(16);
        bitReader.readUBits(2);
        this.versionNumber = bitReader.readUBits(5);
        this.currentNextIndicator = bitReader.readUBits(1);
        this.sectionNumber = bitReader.readUBits(8);
        this.lastSectionNumber = bitReader.readUBits(8);
        int i = 0;
        while ((long)i <= this.sectionNumber - this.lastSectionNumber) {
            buffer = new byte[4];
            sdi.readFully(buffer);
            bitReader = new BitReader(buffer);
            int programNumber = (int)bitReader.readUBits(16);
            int networkPid = -1;
            int programMapPid = -1;
            bitReader.readUBits(3);
            if (programNumber == 0) {
                networkPid = (int)bitReader.readUBits(13);
            } else {
                programMapPid = (int)bitReader.readUBits(13);
            }
            this.programMapTables.put(programMapPid, new ProgramMapTable(programMapPid));
            Program program = new Program(programNumber, networkPid);
            this.programs.put(programNumber, program);
            ++i;
        }
        this.crc32 = new byte[4];
        sdi.readFully(this.crc32);
    }

    public Map<Integer, Program> getPrograms() {
        return this.programs;
    }

    @Override
    public String toString() {
        return "\n\t tableId: " + this.tableId + "\n\t sectionSyntaxIndicator: " + this.sectionSyntaxIndicator + "\n\t reservedBits: " + this.reservedBits + "\n\t sectionLength: " + this.sectionLength + "\n\t transportStreamId: " + this.transportStreamId + "\n\t versionNumber: " + this.versionNumber + "\n\t currentNextIndicator: " + this.currentNextIndicator + "\n\t sectionNumber: " + this.sectionNumber + "\n\t lastSectionNumber: " + this.lastSectionNumber + this.programs + "\n\t crc32: " + this.crc32 + '}';
    }
}

