/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.packets;

import com.apple.jingle.foghorn.media.FrameGeometry;
import com.apple.jingle.foghorn.media.types.FieldOrdering;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.avc.AVCConstants;
import com.apple.jingle.leghorn.bitstream.avc.NALUByteStream;
import com.apple.jingle.leghorn.bitstream.avc.PictureParameterSet;
import com.apple.jingle.leghorn.bitstream.avc.SequenceParameterSet;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.ts.packets.TSPESPacket;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class AVCVideoSequencePacket
extends TSPESPacket {
    NALUByteStream naluByteStream;

    @Override
    public boolean parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        if (!super.parse(ctx, sdi)) {
            return true;
        }
        this.naluByteStream = new NALUByteStream();
        try {
            this.naluByteStream.parse(ctx, sdi);
        }
        catch (EOFException eofe) {
            ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INVALID_NALU_STREAM, MediaUtil.dictionary.add("message", eofe.getMessage()));
            return false;
        }
        return true;
    }

    public SequenceParameterSet getSPS() {
        return this.naluByteStream.getSPS();
    }

    public AVCConstants.Profile getProfile() {
        int profileIDC = this.getSPS().getProfileIdc();
        switch (profileIDC) {
            case 66: {
                return AVCConstants.Profile.Baseline;
            }
            case 77: {
                return AVCConstants.Profile.Main;
            }
            case 88: {
                return AVCConstants.Profile.Extended;
            }
            case 100: {
                return AVCConstants.Profile.High;
            }
            case 110: {
                return AVCConstants.Profile.High10;
            }
            case 122: {
                return AVCConstants.Profile.High422;
            }
            case 244: {
                return AVCConstants.Profile.High444;
            }
            case 44: {
                return AVCConstants.Profile.Cavlc444Intra;
            }
        }
        return AVCConstants.Profile.Unknown;
    }

    public double getLevel() {
        return (double)this.getSPS().getLevelIdc() / 10.0;
    }

    public int getHeight() {
        SequenceParameterSet sps = this.getSPS();
        FrameGeometry.CropRectangle crop = sps.frameCrop();
        return (int)((long)((2 - (sps.onlyContainsFrameMacroblocks() ? 1 : 0)) * sps.pictureHeightInMapUnits() * 16) - crop.getTop() * 2L - crop.getBottom() * 2L);
    }

    public int getWidth() {
        SequenceParameterSet sps = this.getSPS();
        FrameGeometry.CropRectangle crop = sps.frameCrop();
        return (int)((long)(sps.pictureWidthInMbs() * 16) - crop.getLeft() * 2L - crop.getRight() * 2L);
    }

    public boolean getCabacEnabled() {
        PictureParameterSet pps = this.naluByteStream.getPPS();
        return pps.entropyCodingMode();
    }

    public FieldOrdering getFieldOrdering() {
        if (this.getSPS().onlyContainsFrameMacroblocks()) {
            return FieldOrdering.PROGRESSIVE;
        }
        if (this.getSPS().getPictureOrderCountType() == 1 && this.naluByteStream.getPicTiming() != null) {
            int picStruct = this.naluByteStream.getPicTiming().getPicStruct();
            switch (picStruct) {
                case 0: {
                    return FieldOrdering.PROGRESSIVE;
                }
                case 1: {
                    return FieldOrdering.TOP_FIELD_FIRST;
                }
                case 2: {
                    return FieldOrdering.BOTTOM_FIELD_FIRST;
                }
                case 3: {
                    return FieldOrdering.TOP_FIELD_BOTTOM_FIELD_IN_THAT_ORDER;
                }
                case 4: {
                    return FieldOrdering.BOTTOM_FIELD_TOP_FIELD_IN_THAT_ORDER;
                }
                case 5: {
                    return FieldOrdering.TOP_FIELD_BOTTOM_FIELD_TOP_FIELD_REPEATED_IN_THAT_ORDER;
                }
                case 6: {
                    return FieldOrdering.BOTTOM_FIELD_TOP_FIELD_BOTTOM_FIELED_REPEATED_IN_THAT_ORDER;
                }
                case 7: {
                    return FieldOrdering.FRAME_DOUBLING;
                }
                case 8: {
                    return FieldOrdering.FRAME_TRIPLING;
                }
            }
        }
        return FieldOrdering.UNKNOWN;
    }

    public MPEG2ProgramStreamConstants.ColorSpace getColorSpace() {
        return MPEG2ProgramStreamConstants.ColorSpace.YUV;
    }

    public String getVideoFormat() {
        int videoFormat = this.getSPS().vui().videoSignalType().videoFormat().getCode();
        switch (videoFormat) {
            case 0: {
                return "Component";
            }
            case 1: {
                return "PAL";
            }
            case 2: {
                return "NTSC";
            }
            case 3: {
                return "SECAM";
            }
            case 4: {
                return "MAC";
            }
            case 5: {
                return "Unspecificed Video Format";
            }
            case 6: {
                return "Reserved";
            }
            case 7: {
                return "Reserved";
            }
        }
        return "";
    }

    @Override
    public String toString() {
        return "AVCVideoSequencePacket{\nProfile=" + (Object)((Object)this.getProfile()) + "\nLevel=" + this.getLevel() + "\nHeight=" + this.getHeight() + "\nWidth=" + this.getWidth() + "\nProfile=" + (Object)((Object)this.getProfile()) + '}';
    }

    public MPEG2ProgramStreamConstants.ChromaSubsampling getChromaSubsampling() {
        int chromeFormatIdc = this.naluByteStream.getSPS().getChromaFormatIdc();
        switch (chromeFormatIdc) {
            case 0: {
                return MPEG2ProgramStreamConstants.ChromaSubsampling.MONOCHROME;
            }
            case 1: {
                return MPEG2ProgramStreamConstants.ChromaSubsampling.FOURTWOZERO;
            }
            case 2: {
                return MPEG2ProgramStreamConstants.ChromaSubsampling.FOURTWOTWO;
            }
            case 3: {
                return MPEG2ProgramStreamConstants.ChromaSubsampling.FOURFOURFOUR;
            }
        }
        return MPEG2ProgramStreamConstants.ChromaSubsampling.UNKNOWN;
    }
}

