/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.bitstream.aac.ADTSByteStream;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.ts.packets.TSPESPacket;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class ADTSAACAudioSequencePacket
extends TSPESPacket {
    ADTSByteStream adtsByteStream;

    @Override
    public boolean parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        if (!super.parse(ctx, sdi)) {
            return false;
        }
        this.adtsByteStream = new ADTSByteStream();
        try {
            this.adtsByteStream.parse(sdi);
        }
        catch (EOFException eofe) {
            ctx.addCheckAlert(sdi.getFilePointer(), MediaValidationCode.MPEG2_INVALID_ADTS_STREAM, MediaUtil.dictionary.add("message", eofe.getMessage()));
            return false;
        }
        return true;
    }

    public long getProfile() {
        return this.adtsByteStream.getProfile();
    }
}

