/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.datatypes.ProgramClockReference;
import com.apple.jingle.leghorn.mpeg2.packets.TransportPacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.ADTSAACAudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.AVCVideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.ts.packets.TSPESPacket;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramAssociationTable;
import com.apple.jingle.leghorn.mpeg2.ts.psi.ProgramMapTable;
import com.apple.jingle.leghorn.mpeg2.ts.streams.AudioStream;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Program;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Stream;
import com.apple.jingle.leghorn.mpeg2.ts.streams.StreamInfo;
import com.apple.jingle.leghorn.mpeg2.ts.streams.VideoStream;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class TransportStream {
    private static final Logger log = Logger.getLogger(TransportStream.class);
    private ProgramAssociationTable pat;
    private Map<Integer, ProgramMapTable> programMapTables = new HashMap<Integer, ProgramMapTable>();
    private Map<Integer, Program> programs = new HashMap<Integer, Program>();
    private Map<Integer, byte[]> partialPacketMap = new HashMap<Integer, byte[]>();
    private TSPESPacket currentPESPacket;
    private Map<Integer, ProgramClockReference> firstPCRReferences = new HashMap<Integer, ProgramClockReference>();
    private Map<Integer, ProgramClockReference> lastPCRReferences = new HashMap<Integer, ProgramClockReference>();
    private long duration;

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        while (sdi.readByte() != 71) {
        }
        sdi.seek(sdi.getFilePointer() - 1L);
        boolean hasSkippedToTheEnd = false;
        while (sdi.getFilePointer() < sdi.length()) {
            TransportPacket packet = new TransportPacket();
            packet.parse(ctx, sdi);
            this.updatePCRReferences(packet);
            if (this.isPSIPacket(packet)) {
                if (packet.getPid() == 0 && this.pat == null) {
                    this.handlePAT(ctx, packet);
                } else if (this.programMapTables.containsKey(packet.getPid()) && this.programMapTables.get(packet.getPid()) != null) {
                    this.handlePMT(ctx, packet);
                }
            } else if (this.isPESPacket(packet)) {
                this.handlePESPacket(ctx, packet);
            } else if (this.isNullPacket(packet)) {
                // empty if block
            }
            if (this.currentPESPacket != null) {
                this.evaluateState(this.currentPESPacket);
            }
            int totalNumberOfStreams = 0;
            int numberOfStreamsReadSoFar = 0;
            for (Map.Entry<Integer, Program> pairs : this.programs.entrySet()) {
                if (pairs.getValue().getPMT() == null || pairs.getValue().getStreams() == null) continue;
                totalNumberOfStreams += pairs.getValue().getPMT().getStreamInfos().size();
                numberOfStreamsReadSoFar += pairs.getValue().getStreams().size();
            }
            if (sdi.getFilePointer() <= 1000000L || totalNumberOfStreams <= 0 || totalNumberOfStreams < numberOfStreamsReadSoFar || hasSkippedToTheEnd) continue;
            sdi.seek(sdi.length() - 18800L);
            hasSkippedToTheEnd = true;
            while (sdi.readByte() != 71) {
            }
            sdi.seek(sdi.getFilePointer() - 1L);
        }
    }

    private void updatePCRReferences(TransportPacket packet) {
        if (!this.firstPCRReferences.containsKey(packet.getPid()) && packet.getAdaptationField() != null && packet.getAdaptationField().getPcr() != null) {
            this.firstPCRReferences.put(packet.getPid(), packet.getAdaptationField().getPcr());
        }
        if (packet.getAdaptationField() != null && packet.getAdaptationField().getPcr() != null) {
            if (this.lastPCRReferences.get(packet.getPid()) == null) {
                this.lastPCRReferences.put(packet.getPid(), packet.getAdaptationField().getPcr());
            } else if (packet.getAdaptationField().getPcr().toMillis() > this.lastPCRReferences.get(packet.getPid()).toMillis()) {
                this.lastPCRReferences.put(packet.getPid(), packet.getAdaptationField().getPcr());
            }
        }
    }

    private boolean describable() {
        int totalStreams = 0;
        int currentStreams = 0;
        for (Program program : this.getProgramsAsList()) {
            if (program.getPMT() == null) {
                return false;
            }
            totalStreams += program.getPMT().getStreamInfos().size();
            currentStreams += program.getStreamsAsList().size();
        }
        return currentStreams >= totalStreams && totalStreams > 0;
    }

    private void evaluateState(TSPESPacket tspesPacket) {
        Program program = this.programs.get((int)this.programIdFromStreamId(tspesPacket.getTsPid()));
        Stream stream = program.getStream(tspesPacket.getTsPid());
        StreamInfo streamInfo = program.getPMT().getStreamInfoForPid(tspesPacket.getTsPid());
        if (tspesPacket instanceof AVCVideoSequencePacket) {
            AVCVideoSequencePacket avcPacket = (AVCVideoSequencePacket)tspesPacket;
            if (stream == null) {
                stream = new VideoStream(avcPacket, streamInfo);
                program.addStream(tspesPacket.getTsPid(), stream);
            }
        } else if (tspesPacket instanceof ADTSAACAudioSequencePacket) {
            ADTSAACAudioSequencePacket adtsAacPacket = (ADTSAACAudioSequencePacket)tspesPacket;
            if (stream == null) {
                stream = new AudioStream(adtsAacPacket, streamInfo);
                program.addStream(tspesPacket.getTsPid(), stream);
            }
        } else if (stream == null) {
            stream = new Stream(tspesPacket, streamInfo);
            program.addStream(tspesPacket.getTsPid(), stream);
        }
    }

    private long programIdFromStreamId(int streamId) {
        for (Map.Entry<Integer, ProgramMapTable> pairs : this.programMapTables.entrySet()) {
            if (!pairs.getValue().containsPid(streamId)) continue;
            return pairs.getValue().getProgramNumber();
        }
        return -1L;
    }

    private void handlePESPacket(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        byte[] newPayloadBytes = packet.getPayload();
        if (packet.getPayloadUnitStartIndication() == 1) {
            if (this.partialPacketMap.get(packet.getPid()) == null) {
                this.partialPacketMap.put(packet.getPid(), newPayloadBytes);
            } else {
                byte[] pesPacketByteArray = this.partialPacketMap.get(packet.getPid());
                ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(pesPacketByteArray, (long)pesPacketByteArray.length);
                byte[] nextBytes = new byte[3];
                basdi.readFully(nextBytes);
                int streamId = (int)MPEG2MediaReader.readU8((ByteSequence)basdi);
                int packetLength = (int)MPEG2MediaReader.readU16((ByteSequence)basdi);
                long offset = basdi.getFilePointer();
                TSPESPacket pesPacket = null;
                Program program = this.programs.get((int)this.programIdFromStreamId(packet.getPid()));
                if (program != null) {
                    StreamInfo streamInfo = program.getPMT().getStreamInfoForPid(packet.getPid());
                    if (MPEG2ProgramStreamConstants.MAP_OF_STREAM_TYPE_TO_CLASS.containsKey(streamInfo.getStreamType())) {
                        try {
                            pesPacket = MPEG2ProgramStreamConstants.MAP_OF_STREAM_TYPE_TO_CLASS.get(streamInfo.getStreamType()).newInstance();
                        }
                        catch (Exception e) {
                            pesPacket = new TSPESPacket();
                        }
                    }
                    if (pesPacket == null) {
                        pesPacket = new TSPESPacket();
                    }
                    pesPacket.setTsPid(packet.getPid());
                    pesPacket.setAttributes(streamId, packetLength, offset);
                    pesPacket.parse(ctx, (SeekableDataInput)basdi);
                    this.currentPESPacket = pesPacket;
                }
                this.partialPacketMap.put(packet.getPid(), null);
            }
        } else if (this.partialPacketMap.get(packet.getPid()) != null) {
            byte[] currentBytes = this.partialPacketMap.get(packet.getPid());
            byte[] newBiggerPartialPesPacket = new byte[newPayloadBytes.length + currentBytes.length];
            System.arraycopy(currentBytes, 0, newBiggerPartialPesPacket, 0, currentBytes.length);
            System.arraycopy(newPayloadBytes, 0, newBiggerPartialPesPacket, currentBytes.length, newPayloadBytes.length);
            this.partialPacketMap.put(packet.getPid(), newBiggerPartialPesPacket);
        }
    }

    private void handlePAT(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        this.pat = new ProgramAssociationTable(packet.getPid(), this.programs, this.programMapTables);
        byte[] payload = packet.getPayload();
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(payload, (long)payload.length);
        this.pat.parse(ctx, (SeekableDataInput)basdi);
        log.debug((Object)"Added Program Association Table");
    }

    private void handlePMT(@Nonnull LeghornValidationContext ctx, TransportPacket packet) throws IOException {
        ProgramMapTable newPmt = this.programMapTables.get(packet.getPid());
        byte[] payload = packet.getPayload();
        ByteArraySeekableDataInput basdi = new ByteArraySeekableDataInput(payload, (long)payload.length);
        newPmt.parse(ctx, (SeekableDataInput)basdi);
        this.programMapTables.put((int)newPmt.getProgramNumber(), newPmt);
        this.programs.get((int)newPmt.getProgramNumber()).setPMT(newPmt);
        log.debug((Object)(String.format("Added Program Map Table (streams = %s)", newPmt.getStreamInfos()) != null ? newPmt.getStreamInfos().size() : 0));
    }

    private boolean isPSIPacket(TransportPacket packet) {
        int pid = packet.getPid();
        if (pid == 0 || pid == 1 || pid == 2 || pid == 3) {
            return true;
        }
        return this.programMapTables.containsKey(pid);
    }

    private boolean isPESPacket(TransportPacket packet) {
        return packet.getPid() != 8191;
    }

    private boolean isNullPacket(TransportPacket packet) {
        return packet.getPid() == 8191;
    }

    public String toString() {
        return this.programs.toString();
    }

    public ProgramAssociationTable getPat() {
        return this.pat;
    }

    public Map<Integer, Program> getPrograms() {
        return this.programs;
    }

    public List<Program> getProgramsAsList() {
        return new ArrayList<Program>(this.programs.values());
    }

    public Map<Integer, ProgramClockReference> getFirstPCRReferences() {
        return this.firstPCRReferences;
    }

    public Map<Integer, ProgramClockReference> getLastPCRReferences() {
        return this.lastPCRReferences;
    }
}

