/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ts.TransportStreamPayload;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import javax.annotation.Nonnull;

public class PESPacketPiecePayload
extends TransportStreamPayload {
    private int pointerField;
    private long transportPacketOffset;
    private byte[] payloadBytes;

    public PESPacketPiecePayload(long pid, long transportPacketOffset) {
        this.pid = pid;
        this.transportPacketOffset = transportPacketOffset;
    }

    @Override
    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.offset = sdi.getFilePointer();
        super.parse(ctx, sdi);
        int bytesToRead = (int)(188L - (sdi.getFilePointer() - this.transportPacketOffset));
        if (sdi.length() - sdi.getFilePointer() < 188L) {
            bytesToRead = (int)(sdi.length() - sdi.getFilePointer());
        }
        this.payloadBytes = new byte[bytesToRead];
        sdi.readFully(this.payloadBytes);
    }

    public byte[] getPayloadBytes() {
        return this.payloadBytes;
    }
}

