/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts;

import com.apple.jingle.leghorn.Configuration;
import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.fileformat.ContainerDescription;
import com.apple.jingle.leghorn.fileformat.impl.SimpleContainerDescription;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.datatypes.ProgramClockReference;
import com.apple.jingle.leghorn.mpeg2.ts.TransportStream;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Program;
import com.apple.jingle.leghorn.mpeg2.ts.streams.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import noNamespace.ProgramsDocument;
import noNamespace.Streams;
import org.apache.xmlbeans.XmlCursor;
import org.w3c.dom.Node;

public class MPEG2TSDescriptionGenerator {
    public static ContainerDescription<Node> generateDescription(@Nonnull LeghornValidationContext ctx, @Nonnull TransportStream transportStream, @Nullable String toolName) {
        ProgramsDocument programsDocument = ProgramsDocument.Factory.newInstance();
        ProgramsDocument.Programs programs = programsDocument.addNewPrograms();
        if (toolName != null) {
            XmlCursor cursor = programs.newCursor();
            cursor.insertComment(String.format("Generated by the %s, version %s", toolName, Configuration.getVersion()));
        }
        for (Program program : transportStream.getProgramsAsList()) {
            noNamespace.Program programElement = programs.addNewProgram();
            Streams streams = programElement.addNewStreams();
            for (Stream stream : program.getStreamsAsList()) {
                noNamespace.Stream currentStream = streams.addNewStream();
                currentStream.setCodecId(stream.getCodecId());
                currentStream.setType(MPEG2ProgramStreamConstants.MAP_OF_STREAM_TYPE_CODES.get(stream.getCodecId()));
                stream.populateStreamNode(currentStream);
                MPEG2TSDescriptionGenerator.addDuration(currentStream, stream, transportStream);
            }
        }
        SimpleContainerDescription containerDescription = new SimpleContainerDescription();
        containerDescription.setDescriptionDocument(programsDocument.getDomNode());
        return containerDescription;
    }

    private static void addDuration(noNamespace.Stream currentStream, Stream stream, TransportStream transportStream) {
        ProgramClockReference firstPCR = transportStream.getFirstPCRReferences().get(stream.getStreamInfo().getElementaryPid());
        ProgramClockReference lastPCR = transportStream.getLastPCRReferences().get(stream.getStreamInfo().getElementaryPid());
        currentStream.addNewDuration().setMilliseconds(lastPCR.toMillis() - firstPCR.toMillis());
    }
}

