/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.ts;

import com.apple.jingle.leghorn.mpeg2.datatypes.ProgramClockReference;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;

public class AdaptationField {
    private int length;
    private int discontinuityIndicator;
    private int randomAccessIndicator;
    private int esPriorityIndicator;
    private int pcrFlag;
    private int opcrFlag;
    private int splicingPointFlag;
    private int transportPrivateDataFlag;
    private int adaptationFieldExtensionFlag;
    private int spliceCountdown;
    private ProgramClockReference pcr = new ProgramClockReference(0L, 0);
    private ProgramClockReference opcr = new ProgramClockReference(0L, 0);

    public long getPCRMillis() {
        return this.pcr.toMillis();
    }

    public long getOPCRMillis() {
        return this.opcr.toMillis();
    }

    public void parse(SeekableDataInput sdi) throws IOException {
        int extension;
        long base;
        long currentOffset = sdi.getFilePointer();
        this.length = sdi.readUnsignedByte();
        if (this.length == 0) {
            return;
        }
        byte[] buffer = new byte[1];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.discontinuityIndicator = bitReader.readBit();
        this.randomAccessIndicator = bitReader.readBit();
        this.esPriorityIndicator = bitReader.readBit();
        this.pcrFlag = bitReader.readBit();
        this.opcrFlag = bitReader.readBit();
        this.splicingPointFlag = bitReader.readBit();
        this.transportPrivateDataFlag = bitReader.readBit();
        this.adaptationFieldExtensionFlag = bitReader.readBit();
        if (this.pcrFlag == 1) {
            buffer = new byte[6];
            sdi.readFully(buffer);
            bitReader = new BitReader(buffer);
            base = bitReader.readUBits(33);
            bitReader.readUBits(6);
            extension = (int)bitReader.readUBits(9);
            this.pcr = new ProgramClockReference(base, extension);
        }
        if (this.opcrFlag == 1) {
            buffer = new byte[6];
            sdi.readFully(buffer);
            bitReader = new BitReader(buffer);
            base = bitReader.readUBits(33);
            bitReader.readUBits(6);
            extension = (int)bitReader.readUBits(9);
            this.opcr = new ProgramClockReference(base, extension);
        }
        if (this.splicingPointFlag == 1) {
            this.spliceCountdown = sdi.readByte();
        }
        sdi.seek(currentOffset + (long)this.length + 1L);
    }

    public int getLength() {
        return this.length;
    }

    public int getDiscontinuityIndicator() {
        return this.discontinuityIndicator;
    }

    public int getRandomAccessIndicator() {
        return this.randomAccessIndicator;
    }

    public int getEsPriorityIndicator() {
        return this.esPriorityIndicator;
    }

    public int getPcrFlag() {
        return this.pcrFlag;
    }

    public int getOpcrFlag() {
        return this.opcrFlag;
    }

    public int getSplicingPointFlag() {
        return this.splicingPointFlag;
    }

    public int getTransportPrivateDataFlag() {
        return this.transportPrivateDataFlag;
    }

    public int getAdaptationFieldExtensionFlag() {
        return this.adaptationFieldExtensionFlag;
    }

    public int getSpliceCountdown() {
        return this.spliceCountdown;
    }

    public ProgramClockReference getPcr() {
        return this.pcr;
    }

    public ProgramClockReference getOpcr() {
        return this.opcr;
    }

    public String toString() {
        return "AdaptationField{length=" + this.length + ", discontinuityIndicator=" + this.discontinuityIndicator + ", randomAccessIndicator=" + this.randomAccessIndicator + ", esPriorityIndicator=" + this.esPriorityIndicator + ", pcrFlag=" + this.pcrFlag + ", opcrFlag=" + this.opcrFlag + ", splicingPointFlag=" + this.splicingPointFlag + ", transportPrivateDataFlag=" + this.transportPrivateDataFlag + ", adaptationFieldExtensionFlag=" + this.adaptationFieldExtensionFlag + ", spliceCountdown=" + this.spliceCountdown + ", pcr=" + this.pcr + ", opcr=" + this.opcr + '}';
    }
}

