/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.streams;

import com.apple.jingle.leghorn.mpeg2.datatypes.AspectRatio;
import com.apple.jingle.leghorn.mpeg2.datatypes.FrameRate;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.packets.ProgramStreamMap;
import com.apple.jingle.leghorn.mpeg2.packets.VideoSequencePacket;
import com.apple.jingle.leghorn.mpeg2.streams.Stream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class VideoStream
extends Stream {
    private static final Logger logger = Logger.getLogger(VideoStream.class);
    private int height;
    private int width;
    private int displayHeight;
    private int displayWidth;
    private FrameRate frameRate;
    private AspectRatio displayAspectRatio;
    private AspectRatio sampleAspectRatio;
    private String fieldDominance = null;
    private String pixelFormat;
    private String videoFormat;
    private double bitRate;
    private ProgramStreamMap programStreamMap;
    public static Map<Integer, AspectRatio> ASPECT_RATIO_INFORMATION_MAP = new HashMap<Integer, AspectRatio>();
    public static Map<Integer, FrameRate> FRAME_RATE_CODE_MAP = new HashMap<Integer, FrameRate>();
    public static Map<Integer, String> VIDEO_FORMAT_MAP = new HashMap<Integer, String>();

    public VideoStream(int index) {
        this.index = index;
        this.type = "video";
    }

    public void materialize() {
        VideoSequencePacket firstPacketWithHeader = null;
        int packetIndex = 0;
        for (PESPacket packet : this.packets) {
            VideoSequencePacket videoPacket = (VideoSequencePacket)packet;
            if (null != videoPacket && null != videoPacket.getSequenceHeader()) {
                firstPacketWithHeader = videoPacket;
                break;
            }
            ++packetIndex;
        }
        VideoSequencePacket firstPacket = (VideoSequencePacket)this.packets.get(0);
        if (null == firstPacketWithHeader) {
            logger.debug((Object)("No video packet found with header, checked " + (packetIndex + 1) + " packet(s), using first packet"));
        } else {
            logger.debug((Object)("Got first packet with header at index " + packetIndex));
            firstPacket = firstPacketWithHeader;
        }
        if (firstPacket == null) {
            logger.error((Object)"No video packets found in video stream !");
            return;
        }
        VideoSequencePacket.SequenceHeader header = firstPacket.getSequenceHeader();
        VideoSequencePacket.SequenceHeaderExtension headerExtension = firstPacket.getSequenceHeaderExtension();
        VideoSequencePacket.SequenceDisplayExtension displayExtension = firstPacket.getSequenceDisplayExtension();
        VideoSequencePacket.SequenceScalableExtension scalableExtension = firstPacket.getSequenceScalableExtension();
        this.codecName = firstPacket.isMPEG2Header() ? "MPEG2Video" : "MPEG1Video";
        this.id = ((PESPacket)this.packets.get(0)).getStreamId();
        if (header != null) {
            long denominator;
            long numerator;
            AspectRatio tempAspectRatio;
            this.bitRate = header.getBitRateValue() * 400 / 1000000;
            this.height = header.getVerticalSizeValue();
            this.width = header.getHorizontalSizeValue();
            this.sampleAspectRatio = ASPECT_RATIO_INFORMATION_MAP.get(header.getAspectRatioInformation());
            if (displayExtension == null) {
                tempAspectRatio = this.sampleAspectRatio;
                if (tempAspectRatio != null) {
                    numerator = tempAspectRatio.getAspectRatioNumerator() * (long)this.width;
                    denominator = tempAspectRatio.getAspectRatioDenominator() * (long)this.height;
                    this.displayAspectRatio = new AspectRatio(numerator, denominator);
                }
            } else {
                tempAspectRatio = this.sampleAspectRatio;
                if (tempAspectRatio != null) {
                    numerator = displayExtension.getDisplayHorizontalSize() * this.width;
                    denominator = displayExtension.getDisplayVerticalSize() * this.height;
                    this.displayAspectRatio = new AspectRatio(numerator, denominator);
                }
            }
            this.frameRate = FRAME_RATE_CODE_MAP.get(header.getFrameRateCode());
        }
        if (displayExtension != null) {
            this.displayHeight = displayExtension.getDisplayVerticalSize();
            this.displayWidth = header.getAspectRatioInformation() != 1 ? (int)((long)this.height * this.sampleAspectRatio.getAspectRatioDenominator() / this.sampleAspectRatio.getAspectRatioNumerator()) : this.width;
            this.videoFormat = VIDEO_FORMAT_MAP.get(displayExtension.getVideoFormat());
        } else {
            this.displayHeight = this.height;
            this.displayWidth = header != null && header.getAspectRatioInformation() != 1 ? (int)((long)this.height * this.sampleAspectRatio.getAspectRatioDenominator() / this.sampleAspectRatio.getAspectRatioNumerator()) : this.width;
        }
        if (headerExtension != null) {
            String string = this.fieldDominance = headerExtension.getProgressiveSequence() == 1 ? "progressive" : "interlaced";
        }
        if ("interlaced".equals(this.fieldDominance) || this.fieldDominance == null) {
            this.fieldDominance = null;
            for (int packetCount = 0; this.fieldDominance == null && packetCount < this.packets.size(); ++packetCount) {
                VideoSequencePacket currentPacket = (VideoSequencePacket)this.packets.get(packetCount);
                VideoSequencePacket.GroupOfPictures gop = currentPacket.getGop();
                if (gop == null) continue;
                this.fieldDominance = gop.getFieldDominance();
            }
        }
        if (this.fieldDominance == null) {
            this.fieldDominance = "progressive";
        }
        if (scalableExtension != null) {
            // empty if block
        }
        StringBuilder sb = new StringBuilder("yuv");
        if (null != headerExtension) {
            sb.append(headerExtension.getChromaFormat());
        } else {
            sb.append("420");
        }
        sb.append("p");
        this.pixelFormat = sb.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public AspectRatio getDisplayAspectRatio() {
        return this.displayAspectRatio;
    }

    public AspectRatio getSampleAspectRatio() {
        return this.sampleAspectRatio;
    }

    public String getFieldDominance() {
        return this.fieldDominance;
    }

    public String getPixelFormat() {
        return this.pixelFormat;
    }

    public String getVideoFormat() {
        return this.videoFormat;
    }

    public double getBitRate() {
        return this.bitRate;
    }

    static {
        ASPECT_RATIO_INFORMATION_MAP.put(1, new AspectRatio(1L, 1L));
        ASPECT_RATIO_INFORMATION_MAP.put(2, new AspectRatio(3L, 4L));
        ASPECT_RATIO_INFORMATION_MAP.put(3, new AspectRatio(9L, 16L));
        ASPECT_RATIO_INFORMATION_MAP.put(4, new AspectRatio(100L, 221L));
        FRAME_RATE_CODE_MAP.put(1, new FrameRate(24.0, 1.001));
        FRAME_RATE_CODE_MAP.put(2, new FrameRate(24.0, 1.0));
        FRAME_RATE_CODE_MAP.put(3, new FrameRate(25.0, 1.0));
        FRAME_RATE_CODE_MAP.put(4, new FrameRate(30.0, 1.001));
        FRAME_RATE_CODE_MAP.put(5, new FrameRate(30.0, 1.0));
        FRAME_RATE_CODE_MAP.put(6, new FrameRate(50.0, 1.0));
        FRAME_RATE_CODE_MAP.put(7, new FrameRate(60.0, 1.001));
        FRAME_RATE_CODE_MAP.put(8, new FrameRate(60.0, 1.0));
        VIDEO_FORMAT_MAP.put(0, "component");
        VIDEO_FORMAT_MAP.put(1, "PAL");
        VIDEO_FORMAT_MAP.put(2, "NTSC");
        VIDEO_FORMAT_MAP.put(3, "SECAM");
        VIDEO_FORMAT_MAP.put(4, "MAC");
        VIDEO_FORMAT_MAP.put(5, "unspecified");
    }

    public static enum FIELD_DOMINANCE {
        PROGRESSIVE,
        INTERLACED;

        private String value;

        private String value() {
            return this.value;
        }
    }
}

