/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.streams;

import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Stream {
    protected int index;
    protected String type = "Unknown";
    protected boolean enabled;
    protected int id;
    protected String codecName;
    protected long dataSize;
    protected int sampleRate;
    protected int duration;
    protected long dataRate;
    protected List<PESPacket> packets = new ArrayList<PESPacket>();
    protected List<Long> presentationTimeStamps = new ArrayList<Long>();
    protected List<Long> decodeTimeStamps = new ArrayList<Long>();

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public void setCodecName(String codecName) {
        this.codecName = codecName;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public long getDuration() {
        if (!this.presentationTimeStamps.isEmpty()) {
            long firstPts = this.presentationTimeStamps.get(0);
            long lastPts = this.presentationTimeStamps.get(this.presentationTimeStamps.size() - 1);
            return (lastPts - firstPts) / 180L;
        }
        if (!this.decodeTimeStamps.isEmpty()) {
            long firstDts = this.decodeTimeStamps.get(0);
            long lastDts = this.decodeTimeStamps.get(this.decodeTimeStamps.size() - 1);
            return (lastDts - firstDts) / 180L;
        }
        return -1L;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public long getDataRate() {
        return this.dataRate;
    }

    public void setDataRate(int dataRate) {
        this.dataRate = dataRate;
    }

    public void addPacket(PESPacket packet) {
        this.packets.add(packet);
        long pts = packet.getPts();
        long dts = packet.getDts();
        if (pts != 0L) {
            this.presentationTimeStamps.add(pts);
        }
        if (dts != 0L) {
            this.decodeTimeStamps.add(dts);
        }
    }

    public void sortPacketsAndTimestamps() {
        Collections.sort(this.packets, new Comparator<PESPacket>(){

            @Override
            public int compare(PESPacket p1, PESPacket p2) {
                long diff = p1.getOffset() - p2.getOffset();
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
        });
        Collections.sort(this.presentationTimeStamps);
        Collections.sort(this.decodeTimeStamps);
    }
}

