/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.streams;

import com.apple.jingle.leghorn.mpeg2.packets.AudioSequencePacket;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.streams.Stream;

public class AudioStream
extends Stream {
    private String layer;
    private float bitRate;
    private float samplingFrequency;
    private String mode;
    private Integer channels;
    private boolean copyright;
    private boolean originalOrHome;
    private String emphasis;

    public AudioStream(int index) {
        this.index = index;
        this.type = "audio";
    }

    public void materialize() {
        this.codecName = "MPEG1Audio";
        this.id = ((PESPacket)this.packets.get(0)).getStreamId();
        this.mode = ((AudioSequencePacket)this.packets.get(0)).getMode();
        this.channels = ((AudioSequencePacket)this.packets.get(0)).getChannels();
        this.layer = ((AudioSequencePacket)this.packets.get(0)).getLayer();
        this.bitRate = ((AudioSequencePacket)this.packets.get(0)).getBitRate();
        this.samplingFrequency = ((AudioSequencePacket)this.packets.get(0)).getSamplingFrequency().floatValue();
        this.copyright = ((AudioSequencePacket)this.packets.get(0)).getCopyright();
        this.originalOrHome = ((AudioSequencePacket)this.packets.get(0)).getOriginal();
        this.emphasis = ((AudioSequencePacket)this.packets.get(0)).getEmphasis();
    }

    public String getLayer() {
        return this.layer;
    }

    public float getBitRate() {
        return this.bitRate;
    }

    public Float getSamplingFrequency() {
        return Float.valueOf(this.samplingFrequency);
    }

    public String getMode() {
        return this.mode;
    }

    public void setCopyright(boolean copyright) {
        this.copyright = copyright;
    }

    public Integer getChannels() {
        return this.channels;
    }

    public void setChannels(Integer channels) {
        this.channels = channels;
    }
}

