/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets.descriptors;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class Descriptor {
    private static final Logger logger = Logger.getLogger(Descriptor.class);
    int descriptorTag;
    int descriptorLength;

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi, long positionInFile) throws IOException {
        this.parse(ctx, sdi, positionInFile, true);
    }

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi, long positionInFile, boolean shouldSkipToEnd) throws IOException {
        long descriptorStartOffset = sdi.getFilePointer();
        this.descriptorTag = sdi.readUnsignedByte();
        String descriptorType = MPEG2ProgramStreamConstants.MAP_OF_DESCRIPTOR_TYPES.get(this.descriptorTag);
        this.descriptorLength = sdi.readByte();
        if (shouldSkipToEnd) {
            logger.debug((Object)String.format("%d (%d): Skipping descriptor %d (%s) : %d bytes", descriptorStartOffset, positionInFile + descriptorStartOffset, this.descriptorTag, descriptorType, this.descriptorLength));
            int actualSkippedBytes = sdi.skipBytes(this.descriptorLength);
            if (actualSkippedBytes != this.descriptorLength) {
                String msg = String.format("Need to skip %d bytes in descriptor (%s), but found only %d bytes before descriptor end", this.descriptorLength, descriptorType, actualSkippedBytes);
                ctx.addCheckAlert(descriptorStartOffset, MediaValidationCode.MPEG2_INSUFFICIENT_DESCRIPTOR_BYTES, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(positionInFile)).add("length", Long.toString(this.descriptorLength)).add("type", descriptorType).add("bytesSkipped", Integer.toString(actualSkippedBytes)));
            }
        }
    }
}

