/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.media.foundation.io.ByteSequence;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class VideoSequencePacket
extends PESPacket {
    private static final Logger log = Logger.getLogger(VideoSequencePacket.class);
    private SequenceHeader sequenceHeader;
    private SequenceHeaderExtension sequenceHeaderExtension;
    private SequenceDisplayExtension sequenceDisplayExtension;
    private SequenceScalableExtension sequenceScalableExtension;
    private GroupOfPictures gop;

    @Override
    public boolean parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        if (!super.parse(ctx, sdi)) {
            return true;
        }
        byte[] b = new byte[4];
        sdi.readFully(b);
        if (!Arrays.equals(b, MPEG2ProgramStreamConstants.VIDEO_STREAM_SEQUENCE_HEADER_CODE)) {
            this.skipToEndOfSequence(sdi);
            return true;
        }
        this.sequenceHeader = new SequenceHeader();
        this.sequenceHeader.parse(sdi);
        byte[] code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
        while (Arrays.equals(code, MPEG2ProgramStreamConstants.VIDEO_STREAM_EXTENSION_START_CODE)) {
            b = new byte[1];
            sdi.readFully(b);
            BitReader bitReader = new BitReader(b);
            long extensionStartCodeIdentifier = bitReader.readUBits(4);
            sdi.seek(sdi.getFilePointer() - 1L);
            if (extensionStartCodeIdentifier == 1L) {
                this.sequenceHeaderExtension = new SequenceHeaderExtension();
                this.sequenceHeaderExtension.parse(sdi);
            } else if (extensionStartCodeIdentifier == 2L) {
                this.sequenceDisplayExtension = new SequenceDisplayExtension();
                this.sequenceDisplayExtension.parse(sdi);
            } else if (extensionStartCodeIdentifier == 3L) {
                this.sequenceScalableExtension = new SequenceScalableExtension();
                this.sequenceScalableExtension.parse(sdi);
            } else {
                this.skipToEndOfSequence(sdi);
            }
            code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
        }
        if (Arrays.equals(code, MPEG2ProgramStreamConstants.GOP_START_CODE)) {
            this.gop = new GroupOfPictures();
            this.gop.parse(sdi);
        }
        sdi.seek(sdi.getFilePointer() - 4L);
        this.skipToEndOfSequence(sdi);
        return true;
    }

    public SequenceHeader getSequenceHeader() {
        return this.sequenceHeader;
    }

    public SequenceHeaderExtension getSequenceHeaderExtension() {
        return this.sequenceHeaderExtension;
    }

    public SequenceDisplayExtension getSequenceDisplayExtension() {
        return this.sequenceDisplayExtension;
    }

    public SequenceScalableExtension getSequenceScalableExtension() {
        return this.sequenceScalableExtension;
    }

    public GroupOfPictures getGop() {
        return this.gop;
    }

    public class SequenceHeader {
        int horizontalSizeValue;
        int verticalSizeValue;
        int aspectRatioInformation;
        int frameRateCode;
        int bitRateValue;
        int vbvBufferSizeValue;
        int constrainedParametersFlag;
        int loadIntraQuantiserMatrix;
        byte[] intraQuantiserMatrix;
        int loadNonIntraQuantiserMatrix;
        byte[] nonIntraQuantiserMatrix;

        public void parse(SeekableDataInput sdi) throws IOException {
            long headerOffset = sdi.getFilePointer();
            byte[] b = new byte[4];
            sdi.readFully(b);
            BitReader bitReader = new BitReader(b);
            this.horizontalSizeValue = (int)bitReader.readUBits(12);
            this.verticalSizeValue = (int)bitReader.readUBits(12);
            this.aspectRatioInformation = (int)bitReader.readUBits(4);
            this.frameRateCode = (int)bitReader.readUBits(4);
            b = new byte[4];
            sdi.readFully(b);
            bitReader = new BitReader(b);
            this.bitRateValue = (int)bitReader.readUBits(18);
            MPEG2MediaReader.readMarker((BitReader)bitReader);
            this.vbvBufferSizeValue = (int)bitReader.readUBits(10);
            this.constrainedParametersFlag = (int)bitReader.readUBits(1);
            this.loadIntraQuantiserMatrix = (int)bitReader.readUBits(1);
            if (this.loadIntraQuantiserMatrix == 1) {
                this.intraQuantiserMatrix = new byte[64];
                sdi.readFully(this.intraQuantiserMatrix);
            }
            this.loadNonIntraQuantiserMatrix = (int)bitReader.readUBits(1);
            if (this.loadNonIntraQuantiserMatrix == 1) {
                this.nonIntraQuantiserMatrix = new byte[64];
                sdi.readFully(this.nonIntraQuantiserMatrix);
            }
            log.debug((Object)("At " + headerOffset + ", frameRateCode = " + this.frameRateCode + ", bitRateValue = " + this.bitRateValue));
        }

        public int getHorizontalSizeValue() {
            return this.horizontalSizeValue;
        }

        public int getVerticalSizeValue() {
            return this.verticalSizeValue;
        }

        public int getAspectRatioInformation() {
            return this.aspectRatioInformation;
        }

        public int getFrameRateCode() {
            return this.frameRateCode;
        }

        public int getBitRateValue() {
            return this.bitRateValue;
        }

        public String toString() {
            return "SequenceHeader{horizontalSizeValue=" + this.horizontalSizeValue + ", verticalSizeValue=" + this.verticalSizeValue + ", aspectRatioInformation=" + this.aspectRatioInformation + ", frameRateCode=" + this.frameRateCode + ", bitRateValue=" + this.bitRateValue + ", vbvBufferSizeValue=" + this.vbvBufferSizeValue + ", constrainedParametersFlag=" + this.constrainedParametersFlag + ", loadIntraQuantiserMatrix=" + this.loadIntraQuantiserMatrix + ", loadNonIntraQuantiserMatrix=" + this.loadNonIntraQuantiserMatrix + '}';
        }
    }

    public class SequenceHeaderExtension {
        int extensionStartCodeIdentifier;
        int profileLevelAndIndication;
        int progressiveSequence;
        int chromaFormat;
        int horizontalSizeExtension;
        int verticalSizeExtension;
        int bitRateExtension;
        int vbvBufferSizeExtension;
        int lowDelay;
        int frameRateExtensionN;
        int frameRateExtensionD;

        public void parse(SeekableDataInput sdi) throws IOException {
            byte[] b = new byte[6];
            sdi.readFully(b);
            BitReader bitReader = new BitReader(b);
            this.extensionStartCodeIdentifier = (int)bitReader.readUBits(4);
            this.profileLevelAndIndication = (int)bitReader.readUBits(8);
            this.progressiveSequence = (int)bitReader.readUBits(1);
            this.chromaFormat = (int)bitReader.readUBits(2);
            this.horizontalSizeExtension = (int)bitReader.readUBits(2);
            this.verticalSizeExtension = (int)bitReader.readUBits(2);
            this.bitRateExtension = (int)bitReader.readUBits(12);
            MPEG2MediaReader.readMarker((BitReader)bitReader);
            this.vbvBufferSizeExtension = (int)bitReader.readUBits(8);
            this.lowDelay = (int)bitReader.readUBits(1);
            this.frameRateExtensionN = (int)bitReader.readUBits(2);
            this.frameRateExtensionD = (int)bitReader.readUBits(5);
        }

        public int getProgressiveSequence() {
            return this.progressiveSequence;
        }

        public String getChromaFormat() {
            switch (this.chromaFormat) {
                case 1: {
                    return "420";
                }
                case 2: {
                    return "422";
                }
                case 3: {
                    return "444";
                }
            }
            return "420";
        }
    }

    public class SequenceDisplayExtension {
        int extensionStartCodeIdentifier;
        int videoFormat;
        int colourDescription;
        int colourPrimaries;
        int transferCharacteristics;
        int matrixCoefficeints;
        int displayHorizontalSize;
        int displayVerticalSize;

        public void parse(SeekableDataInput sdi) throws IOException {
            byte[] b = new byte[1];
            sdi.readFully(b);
            BitReader bitReader = new BitReader(b);
            this.extensionStartCodeIdentifier = (int)bitReader.readUBits(4);
            this.videoFormat = (int)bitReader.readUBits(3);
            this.colourDescription = (int)bitReader.readUBits(1);
            if (this.colourDescription == 1) {
                b = new byte[3];
                sdi.readFully(b);
                bitReader = new BitReader(b);
                this.colourPrimaries = (int)bitReader.readUBits(8);
                this.transferCharacteristics = (int)bitReader.readUBits(8);
                this.matrixCoefficeints = (int)bitReader.readUBits(8);
            }
            b = new byte[4];
            sdi.readFully(b);
            bitReader = new BitReader(b);
            this.displayHorizontalSize = (int)bitReader.readUBits(14);
            MPEG2MediaReader.readMarker((BitReader)bitReader);
            this.displayVerticalSize = (int)bitReader.readUBits(14);
        }

        public int getVideoFormat() {
            return this.videoFormat;
        }

        public int getDisplayHorizontalSize() {
            return this.displayHorizontalSize;
        }

        public int getDisplayVerticalSize() {
            return this.displayVerticalSize;
        }
    }

    public class SequenceScalableExtension {
        int extensionStartCodeIdentifier;
        int scalableMode;
        int layerId;
        int lowerLayerPredictionHorizontalSize;
        int lowerLayerPredictionVerticalSize;
        int horizontalSubsamplingFactorM;
        int horizontalSubsamplingFactorN;
        int verticalSubsamplingFactorM;
        int verticalSubsamplingFactorN;
        int pictureMuxEnable;
        int muxToProgressiveSequence;
        int pictureMuxOrder;
        int pictureMuxFactor;

        public void parse(SeekableDataInput sdi) throws IOException {
            byte[] b = new byte[5];
            sdi.readFully(b);
            BitReader bitReader = new BitReader(b);
            this.extensionStartCodeIdentifier = (int)bitReader.readUBits(4);
            this.scalableMode = (int)bitReader.readUBits(2);
            this.layerId = (int)bitReader.readUBits(4);
            if (this.scalableMode == 1) {
                this.lowerLayerPredictionHorizontalSize = (int)bitReader.readUBits(14);
                MPEG2MediaReader.readMarker((BitReader)bitReader);
                this.lowerLayerPredictionVerticalSize = (int)bitReader.readUBits(14);
                this.horizontalSubsamplingFactorM = (int)bitReader.readUBits(5);
                this.horizontalSubsamplingFactorN = (int)bitReader.readUBits(5);
                this.verticalSubsamplingFactorM = (int)bitReader.readUBits(5);
                this.verticalSubsamplingFactorN = (int)bitReader.readUBits(5);
            } else if (this.scalableMode == 3) {
                this.pictureMuxEnable = (int)bitReader.readUBits(1);
                if (this.pictureMuxEnable == 1) {
                    this.muxToProgressiveSequence = (int)bitReader.readUBits(1);
                }
                this.pictureMuxOrder = (int)bitReader.readUBits(3);
                this.pictureMuxFactor = (int)bitReader.readUBits(1);
            }
        }
    }

    public class Picture {
        int temporalReference;
        int pictureCodingType;
        int vbvDelay;
        int fullPelForwardVector;
        int forwardFCode;
        int fullPelBackwardVector;
        int backwardFCode;
        int extraBitPictureOne;
        int topFieldFirst = -1;
        int progressiveFrame = -1;

        public void parse(SeekableDataInput sdi) throws IOException {
            byte[] code;
            byte[] buffer = new byte[5];
            sdi.readFully(buffer);
            BitReader bitReader = new BitReader(buffer);
            this.temporalReference = (int)bitReader.readUBits(10);
            this.pictureCodingType = (int)bitReader.readUBits(3);
            this.vbvDelay = (int)bitReader.readUBits(16);
            if (this.pictureCodingType == 1) {
                sdi.seek(sdi.getFilePointer() - 1L);
            }
            if (this.pictureCodingType == 2 || this.pictureCodingType == 3) {
                this.fullPelForwardVector = bitReader.readBit();
                this.forwardFCode = (int)bitReader.readUBits(3);
            }
            if (this.pictureCodingType == 3) {
                this.fullPelBackwardVector = bitReader.readBit();
                this.backwardFCode = (int)bitReader.readUBits(3);
            }
            this.extraBitPictureOne = bitReader.readBit();
            if (this.extraBitPictureOne == 1) {
                MPEG2MediaReader.skipToNextStartCode((SeekableDataInput)sdi);
            }
            if (Arrays.equals(code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi), MPEG2ProgramStreamConstants.EXTENSION_START_CODE)) {
                buffer = new byte[5];
                sdi.readFully(buffer);
                bitReader = new BitReader(buffer);
                int extensionStartCodeID = (int)bitReader.readUBits(4);
                if (extensionStartCodeID == 8) {
                    bitReader.readUBits(16);
                    bitReader.readUBits(4);
                    this.topFieldFirst = bitReader.readBit();
                    bitReader.readUBits(7);
                    this.progressiveFrame = bitReader.readBit();
                }
            }
        }

        public int getTopFieldFirst() {
            return this.topFieldFirst;
        }

        public int getProgressiveFrame() {
            return this.progressiveFrame;
        }
    }

    public class GroupOfPictures {
        private List<Picture> pictures = new ArrayList<Picture>();

        public void parse(SeekableDataInput sdi) throws IOException {
            sdi.skipBytes(4);
            byte[] code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
            while (Arrays.equals(code, MPEG2ProgramStreamConstants.PICTURE_START_CODE)) {
                Picture pic = new Picture();
                pic.parse(sdi);
                this.pictures.add(pic);
                code = MPEG2MediaReader.readFourByteCode((ByteSequence)sdi);
            }
            sdi.seek(sdi.getFilePointer() - 4L);
        }

        public String getFieldDominance() {
            for (Picture picture : this.pictures) {
                int topFieldFirst = picture.getTopFieldFirst();
                int progressiveFrame = picture.getProgressiveFrame();
                if (topFieldFirst == -1 || progressiveFrame == -1) continue;
                if (progressiveFrame == 1) {
                    return "progressive";
                }
                if (topFieldFirst == 1) {
                    return "Top Field First";
                }
                return "Bottom Field First";
            }
            return null;
        }
    }
}

