/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.mpeg2.ts.AdaptationField;
import com.apple.jingle.leghorn.mpeg2.ts.TransportStream;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import java.io.IOException;
import javax.annotation.Nonnull;

public class TransportPacket {
    protected TransportStream transportStream;
    private long offset;
    private byte[] transportPacketBuffer = new byte[188];
    private int syncByte;
    private int transportErrorIndicator;
    private int payloadUnitStartIndication;
    private int transportPriority;
    private int pid;
    private long scramblingControl;
    private long adaptationFieldControl;
    private long continuityCounter;
    private int pointerField;
    private AdaptationField adaptationField;
    private byte[] payload;

    public void parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        this.offset = sdi.getFilePointer();
        this.syncByte = sdi.readByte();
        byte[] buffer = new byte[3];
        sdi.readFully(buffer);
        BitReader bitReader = new BitReader(buffer);
        this.transportErrorIndicator = bitReader.readBit();
        this.payloadUnitStartIndication = bitReader.readBit();
        this.transportPriority = bitReader.readBit();
        this.pid = (int)bitReader.readUBits(13);
        this.scramblingControl = bitReader.readUBits(2);
        this.adaptationFieldControl = bitReader.readUBits(2);
        this.continuityCounter = bitReader.readUBits(4);
        if (this.adaptationFieldControl == 2L || this.adaptationFieldControl == 3L) {
            this.adaptationField = new AdaptationField();
            this.adaptationField.parse(sdi);
        }
        this.payload = this.adaptationField == null ? new byte[184] : new byte[184 - this.adaptationField.getLength() - 1];
        sdi.readFully(this.payload);
    }

    public int getPid() {
        return this.pid;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getPayloadUnitStartIndication() {
        return this.payloadUnitStartIndication;
    }

    public AdaptationField getAdaptationField() {
        return this.adaptationField;
    }

    public int getSyncByte() {
        return this.syncByte;
    }

    public int getTransportErrorIndicator() {
        return this.transportErrorIndicator;
    }

    public int getTransportPriority() {
        return this.transportPriority;
    }

    public long getScramblingControl() {
        return this.scramblingControl;
    }

    public long getAdaptationFieldControl() {
        return this.adaptationFieldControl;
    }

    public long getContinuityCounter() {
        return this.continuityCounter;
    }

    public int getPointerField() {
        return this.pointerField;
    }

    public String toString() {
        return "TransportStream{transportPacketBuffer=" + this.transportPacketBuffer + ", syncByte=" + this.syncByte + ", transportErrorIndicator=" + this.transportErrorIndicator + ", payloadUnitStartIndication=" + this.payloadUnitStartIndication + ", transportPriority=" + this.transportPriority + ", pid=" + this.pid + ", scramblingControl=" + this.scramblingControl + ", adaptationFieldExists=" + this.adaptationFieldControl + ", continuityCounter=" + this.continuityCounter + ", adaptationField=" + this.adaptationField + ", payload=" + this.payload + '}';
    }
}

