/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.leghorn.mpeg2.MPEG2ProgramStreamConstants;
import com.apple.jingle.leghorn.mpeg2.packets.ElementaryStream;
import com.apple.jingle.leghorn.mpeg2.packets.PESPacket;
import com.apple.jingle.leghorn.mpeg2.packets.descriptors.Descriptor;
import com.apple.jingle.media.foundation.io.ByteArraySeekableDataInput;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class ProgramStreamMap
extends PESPacket {
    private static final Logger logger = Logger.getLogger(ProgramStreamMap.class);
    int currentNextIndicator;
    int programStreamMapVersion;
    int programStreamInfoLength;
    List<Descriptor> programStreamInfoDescriptors = Lists.newLinkedList();
    int elementaryStreamMapLength;
    List<ElementaryStream> elementaryStreams = Lists.newLinkedList();
    byte[] crc32;

    @Override
    public boolean parse(@Nonnull LeghornValidationContext ctx, @Nonnull SeekableDataInput sdi) throws IOException {
        long programStreamMapStartOffset = sdi.getFilePointer();
        logger.debug((Object)("==== start: " + programStreamMapStartOffset));
        byte[] b = new byte[4];
        sdi.readFully(b);
        BitReader bitReader = new BitReader(b);
        this.currentNextIndicator = bitReader.readBit();
        logger.debug((Object)("===> currentNextIndicator=" + this.currentNextIndicator));
        bitReader.readUBits(2);
        this.programStreamMapVersion = (int)bitReader.readUBits(5);
        logger.debug((Object)("===> programStreamMapVersion=" + this.programStreamMapVersion));
        bitReader.readUBits(7);
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        this.programStreamInfoLength = (int)bitReader.readUBits(16);
        logger.debug((Object)("===> progreamStreamInfoLength=" + this.programStreamInfoLength));
        long posInFile = sdi.getFilePointer();
        b = new byte[this.programStreamInfoLength];
        sdi.readFully(b);
        ByteArraySeekableDataInput bsdi = new ByteArraySeekableDataInput(b, (long)this.programStreamInfoLength);
        while (bsdi.getFilePointer() < bsdi.length()) {
            long descriptorStartOffset = posInFile + bsdi.getFilePointer();
            long bytesLeftInFile = bsdi.length() - bsdi.getFilePointer();
            if (bytesLeftInFile < 2L) {
                String msg = String.format("Found only %d bytes before descriptors end, need at least 2 bytes", bytesLeftInFile);
                ctx.addCheckAlert(descriptorStartOffset, MediaValidationCode.MPEG2_INSUFFICIENT_DESCRIPTOR_BYTES, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(descriptorStartOffset)).add("bytesAvailable", Long.toString(bytesLeftInFile)).add("bytesRequired", "2"));
            }
            int descriptorTag = bsdi.readUnsignedByte();
            bsdi.seek(bsdi.getFilePointer() - 1L);
            Descriptor descriptor = new Descriptor();
            if (MPEG2ProgramStreamConstants.MAP_OF_DESCRIPTOR_IDS_TO_CLASS.containsKey(descriptorTag)) {
                try {
                    descriptor = MPEG2ProgramStreamConstants.MAP_OF_DESCRIPTOR_IDS_TO_CLASS.get(descriptorTag).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            descriptor.parse(ctx, (SeekableDataInput)bsdi, descriptorStartOffset);
            this.programStreamInfoDescriptors.add(descriptor);
        }
        b = new byte[2];
        sdi.readFully(b);
        bitReader = new BitReader(b);
        this.elementaryStreamMapLength = (int)bitReader.readUBits(16);
        logger.debug((Object)("---> elementaryStreamMapLength=" + this.elementaryStreamMapLength));
        b = new byte[this.elementaryStreamMapLength];
        sdi.readFully(b);
        bsdi = new ByteArraySeekableDataInput(b, (long)this.elementaryStreamMapLength);
        logger.debug((Object)("Read " + bsdi.length()));
        while (bsdi.getFilePointer() < bsdi.length()) {
            byte[] bb = new byte[2];
            bsdi.readFully(bb);
            BitReader elementaryStreambitReader = new BitReader(bb);
            int elementaryStreamType = (int)elementaryStreambitReader.readUBits(8);
            int elementaryStreamId = (int)elementaryStreambitReader.readUBits(8);
            logger.debug((Object)("elementaryStream " + elementaryStreamType + "." + elementaryStreamId));
            ElementaryStream elementaryStream = new ElementaryStream();
            if (MPEG2ProgramStreamConstants.MAP_OF_ELEMENTARY_STREAM_IDS_TO_CLASS.containsKey(elementaryStreamType)) {
                try {
                    elementaryStream = MPEG2ProgramStreamConstants.MAP_OF_ELEMENTARY_STREAM_IDS_TO_CLASS.get(elementaryStreamType).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.debug((Object)("---> elementaryStream: " + elementaryStream));
            }
            elementaryStream.setAttributes(elementaryStreamType, elementaryStreamId);
            if (bsdi.getFilePointer() < bsdi.length()) {
                elementaryStream.parse(ctx, (SeekableDataInput)bsdi);
            }
            this.elementaryStreams.add(elementaryStream);
        }
        b = new byte[4];
        sdi.readFully(b);
        this.crc32 = b;
        return true;
    }
}

