/*
 * Decompiled with CFR 0.152.
 */
package com.apple.jingle.leghorn.mpeg2.packets;

import com.apple.jingle.leghorn.LeghornValidationContext;
import com.apple.jingle.leghorn.media.MediaUtil;
import com.apple.jingle.leghorn.media.MediaValidationCode;
import com.apple.jingle.media.foundation.io.SeekableDataInput;
import com.apple.jingle.media.foundation.util.BitReader;
import com.apple.jingle.media.foundation.util.MPEG2MediaReader;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class PESPacket {
    private static final Logger logger = Logger.getLogger(PESPacket.class);
    protected int streamId;
    protected long length;
    protected long offset;
    protected int pesScramblingControl;
    protected int pesPriority;
    protected int dataAlignmentIndicator;
    protected int copyright;
    protected int originalOrCopy;
    protected int ptsDtsFlags;
    protected int escrFlag;
    protected int esRateFlag;
    protected int dsmTrickModeFlag;
    protected int additionalCopyInfoFlag;
    protected int pesCRCFlag;
    protected int pesExtensionFlag;
    protected int pesHeaderDataLength;
    protected long pts3230;
    protected long pts2915;
    protected long pts140;
    protected long dts3230;
    protected long dts2915;
    protected long dts140;
    protected boolean isMPEG2Header;

    public boolean parse(@Nonnull LeghornValidationContext ctx, SeekableDataInput sdi) throws IOException {
        long pesPacketStartOffset = sdi.getFilePointer() - 4L;
        logger.debug((Object)("Parsing PES packet @" + pesPacketStartOffset + " (length = " + this.length + ")"));
        if (this.streamId == 191 || this.streamId == 190 || this.streamId == 189) {
            logger.debug((Object)("Skipping private stream packet @" + sdi.getFilePointer() + " : " + this.streamId + " for " + this.length + " bytes"));
            return (long)sdi.skipBytes((int)this.length) == this.length;
        }
        byte firstByte = sdi.readByte();
        sdi.seek(sdi.getFilePointer() - 1L);
        if ((firstByte & 0xC0) == 128) {
            this.isMPEG2Header = true;
            return this.parseMPEG2PESHeader(ctx, pesPacketStartOffset, sdi);
        }
        this.isMPEG2Header = false;
        return this.parseMPEG1PESHeader(ctx, pesPacketStartOffset, sdi);
    }

    private boolean parseMPEG1PESHeader(@Nonnull LeghornValidationContext ctx, long pesPacketStartOffset, SeekableDataInput sdi) throws IOException {
        logger.debug((Object)"Parsing MPEG1 PES ext. header");
        int bytesSkipped = PESPacket.skipPaddingBytes(sdi);
        if ((long)bytesSkipped >= this.length) {
            return true;
        }
        byte firstByte = sdi.readByte();
        sdi.seek(sdi.getFilePointer() - 1L);
        if ((firstByte & 0xC0) == 64) {
            byte[] b = new byte[2];
            sdi.readFully(b);
            if ((long)(bytesSkipped += 2) >= this.length) {
                return true;
            }
            firstByte = sdi.readByte();
            sdi.seek(sdi.getFilePointer() - 1L);
        }
        if ((firstByte & 0xF0) == 32) {
            if (!this.parseFiveBytePTSOrDTS(sdi, 2, false)) {
                return false;
            }
        } else if ((firstByte & 0xF0) == 48) {
            if (!this.parseFiveBytePTSOrDTS(sdi, 3, false)) {
                return false;
            }
            if (!this.parseFiveBytePTSOrDTS(sdi, 1, true)) {
                return false;
            }
        } else if (firstByte == 15) {
            sdi.readByte();
            logger.debug((Object)"Reading and ignoring 1 byte");
        } else {
            sdi.readByte();
            logger.warn((Object)("First byte is " + Integer.toHexString(firstByte) + ", not expected !"));
        }
        return true;
    }

    private boolean parseFiveBytePTSOrDTS(SeekableDataInput sdi, int requiredMarker, boolean isDTS) throws IOException {
        if (sdi.length() - sdi.getFilePointer() < 5L) {
            return false;
        }
        byte[] b = new byte[5];
        sdi.readFully(b);
        if ((b[0] & 0xF0) >> 4 != requiredMarker) {
            logger.warn((Object)String.format("Marker bits at start should be %d, but is %d", requiredMarker, (b[0] & 0xF0) >> 4));
        }
        BitReader bitReader = new BitReader(b);
        bitReader.readUBits(4);
        if (isDTS) {
            this.dts3230 = (int)bitReader.readUBits(3);
        } else {
            this.pts3230 = (int)bitReader.readUBits(3);
        }
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        if (isDTS) {
            this.dts2915 = (int)bitReader.readUBits(15);
        } else {
            this.pts2915 = (int)bitReader.readUBits(15);
        }
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        if (isDTS) {
            this.dts140 = (int)bitReader.readUBits(15);
        } else {
            this.pts140 = (int)bitReader.readUBits(15);
        }
        MPEG2MediaReader.readMarker((BitReader)bitReader);
        return true;
    }

    public static int skipPaddingBytes(SeekableDataInput sdi) throws IOException {
        long bytesLeftInFile;
        int bytesSkipped = 0;
        for (bytesLeftInFile = sdi.length() - sdi.getFilePointer(); bytesLeftInFile > 0L && sdi.readByte() == 255; --bytesLeftInFile) {
            ++bytesSkipped;
        }
        if (bytesLeftInFile > 0L) {
            sdi.seek(sdi.getFilePointer() - 1L);
        }
        return bytesSkipped;
    }

    private boolean parseMPEG2PESHeader(@Nonnull LeghornValidationContext ctx, long pesPacketStartOffset, SeekableDataInput sdi) throws IOException {
        int headerBytesAlreadyRead;
        int bytesToSkip;
        byte[] b = new byte[3];
        sdi.readFully(b);
        BitReader bitReader = new BitReader(b);
        bitReader.readUBits(2);
        this.pesScramblingControl = (int)bitReader.readUBits(2);
        this.pesPriority = (int)bitReader.readUBits(1);
        this.dataAlignmentIndicator = (int)bitReader.readUBits(1);
        this.copyright = (int)bitReader.readUBits(1);
        this.originalOrCopy = (int)bitReader.readUBits(1);
        this.ptsDtsFlags = (int)bitReader.readUBits(2);
        this.escrFlag = (int)bitReader.readUBits(1);
        this.esRateFlag = (int)bitReader.readUBits(1);
        this.dsmTrickModeFlag = (int)bitReader.readUBits(1);
        this.additionalCopyInfoFlag = (int)bitReader.readUBits(1);
        this.pesCRCFlag = (int)bitReader.readUBits(1);
        this.pesExtensionFlag = (int)bitReader.readUBits(1);
        this.pesHeaderDataLength = (int)bitReader.readUBits(8);
        long headerDataOffset = sdi.getFilePointer();
        logger.debug((Object)("PES packet header offset: " + headerDataOffset + ", length: " + this.pesHeaderDataLength));
        long bytesLeftInFile = sdi.length() - headerDataOffset;
        if (this.ptsDtsFlags == 2) {
            if (bytesLeftInFile < 5L) {
                String msg = String.format("PTS/DTS flag = 10, but only %d bytes left in file, expected 5 bytes for PTS data.", bytesLeftInFile);
                ctx.addCheckAlert(pesPacketStartOffset, MediaValidationCode.MPEG2_INCOMPLETE_LAST_PACKET, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(headerDataOffset)).add("ptsFlag", "0x2").add("bytesRemaining", Long.toString(bytesLeftInFile)).add("bytesRequired", "5"));
                return false;
            }
            if (!this.parseFiveBytePTSOrDTS(sdi, 2, false)) {
                logger.error((Object)"Failed to get PTS from PES header.");
                return false;
            }
        } else if (this.ptsDtsFlags == 3) {
            if (bytesLeftInFile < 10L) {
                String msg = String.format("PTS/DTS flag = 11, but only %d bytes left in file, expected 10 bytes for PTS data.", bytesLeftInFile);
                ctx.addCheckAlert(pesPacketStartOffset, MediaValidationCode.MPEG2_INCOMPLETE_LAST_PACKET, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(headerDataOffset)).add("ptsFlag", "0x3").add("bytesRemaining", Long.toString(bytesLeftInFile)).add("bytesRequired", "10"));
                return false;
            }
            if (!this.parseFiveBytePTSOrDTS(sdi, 3, false)) {
                logger.error((Object)"Failed to get PTS from PES header (first)");
                return false;
            }
            if (!this.parseFiveBytePTSOrDTS(sdi, 1, true)) {
                logger.error((Object)"Failed to get DTS from PES header (second)");
                return false;
            }
        }
        if ((bytesToSkip = this.pesHeaderDataLength - (headerBytesAlreadyRead = (int)(sdi.getFilePointer() - headerDataOffset))) < 0) {
            String msg = String.format("Incorrect PES header data length = %d, less than %d bytes (PTS/DTS) already processed in header !", this.pesHeaderDataLength, headerBytesAlreadyRead);
            ctx.addCheckAlert(pesPacketStartOffset, MediaValidationCode.MPEG2_INCOMPLETE_LAST_PACKET, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(headerDataOffset)).add("headerBytes", Long.toString(this.pesHeaderDataLength)).add("bytesRead", Integer.toString(headerBytesAlreadyRead)));
            return false;
        }
        int actualSkippedBytes = sdi.skipBytes(bytesToSkip);
        if (actualSkippedBytes != bytesToSkip) {
            String msg = String.format("PES header data length = %d, skipping %d bytes, but found only %d bytes before file end", this.pesHeaderDataLength, bytesToSkip, actualSkippedBytes);
            logger.debug((Object)("At file offset " + pesPacketStartOffset + ", " + msg));
            ctx.addCheckAlert(pesPacketStartOffset, MediaValidationCode.MPEG2_INCOMPLETE_LAST_PACKET, MediaUtil.dictionary.add("message", msg).add("offset", Long.toString(headerDataOffset)).add("headerBytes", Long.toString(bytesLeftInFile)).add("bytesRemaining", Integer.toString(bytesToSkip)).add("bytesRequired", Integer.toString(actualSkippedBytes)));
            return false;
        }
        return true;
    }

    public int getPtsDtsFlags() {
        return this.ptsDtsFlags;
    }

    public long getDts() {
        long dts = 0L;
        dts += this.dts3230 << 31;
        dts += this.dts2915 << 16;
        return dts += this.dts140;
    }

    public long getPts() {
        long pts = 0L;
        pts += this.pts3230 << 31;
        pts += this.pts2915 << 16;
        return pts += this.pts140;
    }

    protected void skipToEndOfSequence(SeekableDataInput sdi) throws IOException {
        sdi.seek(this.offset + this.length);
    }

    public int getStreamId() {
        return this.streamId;
    }

    public long getLength() {
        return this.length;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setAttributes(int streamId, long length, long offset) {
        this.streamId = streamId;
        this.length = length;
        this.offset = offset;
    }

    public boolean isMPEG2Header() {
        return this.isMPEG2Header;
    }

    public String toString() {
        return "PESPacket{streamId=" + this.streamId + ", length=" + this.length + ", offset=" + this.offset + ", pesScramblingControl=" + this.pesScramblingControl + ", pesPriority=" + this.pesPriority + ", dataAlignmentIndicator=" + this.dataAlignmentIndicator + ", copyright=" + this.copyright + ", originalOrCopy=" + this.originalOrCopy + ", ptsDtsFlags=" + this.ptsDtsFlags + ", escrFlag=" + this.escrFlag + ", esRateFlag=" + this.esRateFlag + ", dsmTrickModeFlag=" + this.dsmTrickModeFlag + ", additionalCopyInfoFlag=" + this.additionalCopyInfoFlag + ", pesCRCFlag=" + this.pesCRCFlag + ", pesExtensionFlag=" + this.pesExtensionFlag + ", pesHeaderDataLength=" + this.pesHeaderDataLength + ", pts3230=" + this.pts3230 + ", pts2915=" + this.pts2915 + ", pts140=" + this.pts140 + ", dts3230=" + this.dts3230 + ", dts2915=" + this.dts2915 + ", dts140=" + this.dts140 + ", iSMPEG2Header=" + this.isMPEG2Header + '}';
    }
}

